/*
 * Decompiled with CFR 0.152.
 */
package com.worklight.common.security;

import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.PackageManager;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.provider.Settings;
import com.worklight.common.WLConfig;
import com.worklight.common.security.WLCertManager;
import com.worklight.utils.Base64;
import java.security.KeyStore;
import java.util.UUID;
import org.json.JSONObject;

public class WLDeviceAuthManager
extends WLCertManager {
    private static WLDeviceAuthManager instance;
    private static String KEYSTORE_FILENAME;
    private static char[] keyStorePassword;
    private String deviceUuid;

    public static synchronized WLDeviceAuthManager getInstance() {
        if (instance == null) {
            instance = new WLDeviceAuthManager();
        }
        return instance;
    }

    protected WLDeviceAuthManager() {
        super(KEYSTORE_FILENAME, keyStorePassword);
    }

    @Override
    protected String getAlias(String provisioningEntity) {
        if (provisioningEntity.equals("application")) {
            return "app:" + WLConfig.getInstance().getAppId();
        }
        return provisioningEntity;
    }

    public String signDeviceAuth(String payloadJSON, String provisioningEntity, boolean isProvisioningEnabled) throws Exception {
        String jwsHeader = "";
        String result = "";
        if (isProvisioningEnabled && this.isCertificateExists(provisioningEntity)) {
            JSONObject jwsHeaderJson = new JSONObject();
            KeyStore.PrivateKeyEntry pke = null;
            jwsHeaderJson.put("alg", (Object)"RS256");
            pke = this.getPrivateKeyEntry(provisioningEntity);
            byte[] cert = pke.getCertificate().getEncoded();
            String x5cValue = Base64.encodeUrlSafe(cert, "UTF-8");
            jwsHeaderJson.put("x5c", (Object)x5cValue);
            jwsHeader = jwsHeaderJson.toString();
            String jwsHeaderAndPayload = Base64.encodeUrlSafe(jwsHeader.getBytes(), "UTF-8") + "." + Base64.encodeUrlSafe(payloadJSON.getBytes(), "UTF-8");
            String jwsSignature = null;
            jwsSignature = Base64.encodeUrlSafe(this.signData(jwsHeaderAndPayload, pke.getPrivateKey()), "UTF-8");
            pke = null;
            result = jwsHeaderAndPayload + "." + jwsSignature;
        } else {
            result = payloadJSON;
        }
        return result;
    }

    public String getDeviceUUID(Context context) {
        if (this.deviceUuid == null) {
            String macAddr = null;
            PackageManager packageManager = context.getPackageManager();
            if (packageManager.hasSystemFeature("android.hardware.wifi")) {
                WifiManager wfManager = (WifiManager)context.getSystemService("wifi");
                WifiInfo wifiinfo = wfManager.getConnectionInfo();
                macAddr = wifiinfo.getMacAddress();
            }
            String uuid = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
            if (macAddr != null) {
                uuid = uuid + macAddr;
            }
            this.deviceUuid = UUID.nameUUIDFromBytes(uuid.getBytes()).toString();
        }
        return this.deviceUuid;
    }

    static {
        KEYSTORE_FILENAME = ".keystore";
        keyStorePassword = null;
    }
}

