/*
 * Decompiled with CFR 0.152.
 */
package com.worklight.common.security;

import android.content.Context;
import android.content.pm.PackageManager;
import com.worklight.common.Logger;
import com.worklight.utils.Base64;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.UnrecoverableEntryException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import java.util.HashMap;
import java.util.Iterator;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.jce.PKCS10CertificationRequest;
import org.json.JSONObject;

public abstract class WLCertManager {
    private static Logger logger = Logger.getInstance("wl.certManager");
    protected static final String ALG = "alg";
    protected static final String JPK = "jpk";
    protected static final String X5C = "x5c";
    protected static final String MOD = "mod";
    protected static final String EXP = "exp";
    protected static final String RSA = "RSA";
    private static final String APPLICATION = "application";
    protected Context context;
    private HashMap<String, KeyPair> keyPairHash = new HashMap();
    private static String KEYSTORE_FILENAME;
    private static char[] keyStorePassword;

    protected WLCertManager(String keystoreFilename, char[] keystorePassword) {
        KEYSTORE_FILENAME = keystoreFilename;
        keyStorePassword = keystorePassword;
    }

    public void init(Context ctx) {
        this.context = ctx;
    }

    public KeyPair generateKeyPair(String provisioningEntity, int rsaKeySize) throws NoSuchAlgorithmException {
        KeyPairGenerator kpg = KeyPairGenerator.getInstance(RSA);
        kpg.initialize(rsaKeySize);
        KeyPair keyPair = kpg.genKeyPair();
        this.keyPairHash.put(this.getAlias(provisioningEntity), keyPair);
        return keyPair;
    }

    public boolean isCertificateExists(String provisioningEntity) {
        if (this.context == null) {
            return false;
        }
        try {
            KeyStore.PrivateKeyEntry pke = this.getPrivateKeyEntry(provisioningEntity);
            boolean ret = pke != null;
            pke = null;
            return ret;
        }
        catch (Exception e) {
            logger.error("Failed to determine the existence of certificate for device authentication with " + e.getMessage(), e);
            return false;
        }
    }

    protected abstract String getAlias(String var1);

    private byte[] signCsrData(String csrJSONData, PrivateKey privateKey) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        Signature signature = Signature.getInstance("SHA256withRSA");
        signature.initSign(privateKey);
        signature.update(csrJSONData.getBytes());
        return signature.sign();
    }

    public String signCsr(JSONObject csrJSON, String provisioningEntity) throws Exception {
        String csrHeader = "";
        JSONObject csrHeaderJson = new JSONObject();
        csrHeaderJson.put(ALG, (Object)"RS256");
        JSONObject publicKeyDataJson = new JSONObject();
        String alias = this.getAlias(provisioningEntity);
        KeyPair keyPair = this.keyPairHash.get(alias);
        RSAPublicKey publicKey = (RSAPublicKey)keyPair.getPublic();
        publicKeyDataJson.put(ALG, (Object)RSA);
        String mod = Base64.encodeUrlSafe(publicKey.getModulus().toByteArray(), "UTF-8");
        publicKeyDataJson.put(MOD, (Object)mod);
        String exp = Base64.encodeUrlSafe(publicKey.getPublicExponent().toByteArray(), "UTF-8");
        publicKeyDataJson.put(EXP, (Object)exp);
        csrHeaderJson.put(JPK, (Object)publicKeyDataJson);
        csrHeader = csrHeaderJson.toString();
        String payload = csrJSON.toString();
        String csrHeaderAndPayload = Base64.encodeUrlSafe(csrHeader.getBytes(), "UTF-8") + "." + Base64.encodeUrlSafe(payload.getBytes(), "UTF-8");
        String jwsSignature = null;
        jwsSignature = Base64.encodeUrlSafe(this.signCsrData(csrHeaderAndPayload, keyPair.getPrivate()), "UTF-8");
        String result = csrHeaderAndPayload + "." + jwsSignature;
        return result;
    }

    public String createSignedCSR(JSONObject csrJSON, String provisioningEntity) throws Exception {
        String csrHeader = "";
        JSONObject subjectJSON = csrJSON.getJSONObject("subject");
        JSONObject attributesJSON = csrJSON.optJSONObject("attributes");
        Iterator subjectKeys = subjectJSON.keys();
        String subjectString = "";
        while (subjectKeys.hasNext()) {
            String name = (String)subjectKeys.next();
            subjectString = subjectString + name + "=" + subjectJSON.getString(name);
            if (!subjectKeys.hasNext()) continue;
            subjectString = subjectString + ",";
        }
        ASN1Set attributesSet = null;
        String alias = this.getAlias(provisioningEntity);
        KeyPair keyPair = this.keyPairHash.get(alias);
        X500Principal subject = new X500Principal(subjectString);
        PKCS10CertificationRequest csr = new PKCS10CertificationRequest("SHA1withRSA", subject, keyPair.getPublic(), attributesSet, keyPair.getPrivate());
        csrHeader = Base64.encode(csr.getEncoded(), "UTF-8");
        return csrHeader;
    }

    public void saveCertificate(String provisioningEntity, String certString, String realm) throws Exception {
        if (certString == null) {
            throw new Exception("cannot save null certificate");
        }
        byte[] encodedCert = Base64.decode(certString.getBytes());
        ByteArrayInputStream inStream = new ByteArrayInputStream(encodedCert);
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        X509Certificate cert = (X509Certificate)cf.generateCertificate(inStream);
        ((InputStream)inStream).close();
        this.saveCertificate(provisioningEntity, cert, realm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearKeystore(String provisioningEntity) throws KeyStoreException {
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        File keyStoreFile = new File(this.context.getFilesDir().getAbsolutePath() + "/" + KEYSTORE_FILENAME);
        FileInputStream fis = null;
        FileOutputStream fos = null;
        try {
            if (keyStoreFile.exists()) {
                fis = new FileInputStream(keyStoreFile);
                keyStore.load(fis, keyStorePassword);
                fis.close();
            } else {
                keyStore.load(null, keyStorePassword);
            }
            String alias = this.getAlias(provisioningEntity);
            if (keyStore.containsAlias(alias)) {
                keyStore.deleteEntry(alias);
                fos = new FileOutputStream(keyStoreFile);
                keyStore.store(fos, keyStorePassword);
            }
            logger.debug("Key store cleared.");
        }
        catch (Exception e) {
            logger.error("Error deleting the keystore containing the certificate " + e.getMessage(), e);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    logger.error(e.getClass() + ": " + e.getMessage(), e);
                }
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    logger.error(e.getClass() + ": " + e.getMessage(), e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEntityKeyStoreValues(String provisioningEntity) throws KeyStoreException {
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        File keyStoreFile = new File(this.context.getFilesDir().getAbsolutePath() + "/" + KEYSTORE_FILENAME);
        FileInputStream fis = null;
        FileOutputStream fos = null;
        try {
            String[] packages;
            String alias = this.getAlias(provisioningEntity);
            if (keyStoreFile.exists()) {
                fis = new FileInputStream(keyStoreFile);
                keyStore.load(fis, keyStorePassword);
                if (keyStore.containsAlias(alias)) {
                    keyStore.deleteEntry(alias);
                    fos = new FileOutputStream(keyStoreFile);
                    keyStore.store(fos, keyStorePassword);
                }
                fis.close();
            }
            if (provisioningEntity.equals(APPLICATION)) {
                return;
            }
            for (String packageName : packages = this.context.getPackageManager().getPackagesForUid(this.context.getApplicationInfo().uid)) {
                keyStoreFile = new File(this.context.createPackageContext(packageName, 0).getFilesDir().getAbsolutePath() + "/" + KEYSTORE_FILENAME);
                fis = null;
                fos = null;
                if (!keyStoreFile.exists()) continue;
                try {
                    fis = new FileInputStream(keyStoreFile);
                    keyStore.load(fis, keyStorePassword);
                    keyStore.deleteEntry(alias);
                    fos = new FileOutputStream(keyStoreFile);
                    keyStore.store(fos, keyStorePassword);
                    fos.close();
                    fis.close();
                }
                catch (IOException e) {
                }
                finally {
                    if (fis != null) {
                        fis.close();
                    }
                    if (fos != null) {
                        fos.close();
                    }
                }
            }
            logger.debug("certificate cleared for entity: " + provisioningEntity);
        }
        catch (Exception e) {
            logger.error("Error deleting the keystore containing the certificate " + e.getMessage(), e);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), e);
                }
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveCertificate(String provisioningEntity, Certificate certificate, String realm) throws Exception {
        if (this.isCertificateExists(provisioningEntity)) {
            throw new Exception("Error - Got a new Certificate, but an older one already exists, exiting process");
        }
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        File keyStoreFile = new File(this.context.getFilesDir().getAbsolutePath() + "/" + KEYSTORE_FILENAME);
        FileInputStream fis = null;
        FileOutputStream fos = null;
        try {
            if (keyStoreFile.exists()) {
                fis = new FileInputStream(keyStoreFile);
                keyStore.load(fis, keyStorePassword);
                fis.close();
            } else {
                keyStore.load(null, keyStorePassword);
            }
            String alias = this.getAlias(provisioningEntity);
            KeyPair keypair = this.keyPairHash.get(this.getAlias(provisioningEntity));
            keyStore.setKeyEntry(alias, keypair.getPrivate(), keyStorePassword, new Certificate[]{certificate});
            fos = new FileOutputStream(keyStoreFile);
            keyStore.store(fos, keyStorePassword);
            this.keyPairHash.remove(realm);
            keypair = null;
            logger.debug("Certificate saved.");
        }
        catch (Exception e) {
            logger.error("Certificate for device authentication could not be saved with " + e.getMessage(), e);
        }
        finally {
            if (fos != null) {
                fos.close();
            }
            if (fis != null) {
                fis.close();
            }
        }
    }

    protected byte[] signData(String data, PrivateKey privateKey) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, SignatureException {
        Signature signature = Signature.getInstance("SHA256withRSA");
        signature.initSign(privateKey);
        signature.update(data.getBytes());
        return signature.sign();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected KeyStore.PrivateKeyEntry getPrivateKeyEntry(String provisioningEntity) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException, PackageManager.NameNotFoundException, UnrecoverableEntryException {
        myKeyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        myKeyStoreFile = new File(this.context.getFilesDir().getAbsolutePath() + "/" + WLCertManager.KEYSTORE_FILENAME);
        alias = this.getAlias(provisioningEntity);
        myFis = null;
        if (myKeyStoreFile.exists()) {
            try {
                myFis = new FileInputStream(myKeyStoreFile);
                myKeyStore.load(myFis, WLCertManager.keyStorePassword);
                pke = (KeyStore.PrivateKeyEntry)myKeyStore.getEntry(alias, new KeyStore.PasswordProtection(WLCertManager.keyStorePassword));
                if (pke != null) {
                    var7_8 = pke;
                    return var7_8;
                }
                if (!"application".equalsIgnoreCase(provisioningEntity)) ** GOTO lbl26
                var7_9 = pke = null;
                return var7_9;
            }
            catch (IOException e) {
                WLCertManager.logger.error("Failed to determine the existence of certificate for device authentication with " + e.getMessage(), e);
            }
            finally {
                if (myFis != null) {
                    myFis.close();
                }
            }
        } else {
            if ("application".equalsIgnoreCase(provisioningEntity)) {
                return null;
            }
            myKeyStore.load(null, WLCertManager.keyStorePassword);
        }
lbl26:
        // 3 sources

        packages = this.context.getPackageManager().getPackagesForUid(this.context.getApplicationInfo().uid);
        keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        for (String packageName : packages) {
            keyStoreFile = new File(this.context.createPackageContext(packageName, 0).getFilesDir().getAbsolutePath() + "/" + WLCertManager.KEYSTORE_FILENAME);
            fis = null;
            fos = null;
            if (!keyStoreFile.exists()) continue;
            try {
                fis = new FileInputStream(keyStoreFile);
                keyStore.load(fis, WLCertManager.keyStorePassword);
                pke = (KeyStore.PrivateKeyEntry)keyStore.getEntry(alias, new KeyStore.PasswordProtection(WLCertManager.keyStorePassword));
                if (pke != null) {
                    fos = new FileOutputStream(myKeyStoreFile);
                    myKeyStore.setKeyEntry(alias, pke.getPrivateKey(), WLCertManager.keyStorePassword, pke.getCertificateChain());
                    myKeyStore.store(fos, WLCertManager.keyStorePassword);
                    fos.close();
                    fis.close();
                    var16_21 = pke;
                    return var16_21;
                }
                fis.close();
            }
            catch (IOException e) {
                WLCertManager.logger.error("Failed copying certificate for device authentication with " + e.getMessage() + " , device authentication certificate will recreate.", e);
            }
            finally {
                if (fis != null) {
                    fis.close();
                }
                if (fos != null) {
                    fos.close();
                }
            }
        }
        return null;
    }
}

