/*
 * Decompiled with CFR 0.152.
 */
package com.worklight.common.internal;

import android.content.Context;
import android.content.res.AssetManager;
import android.text.TextUtils;
import com.trusteer.tas.TAS_CLIENT_INFO;
import com.trusteer.tas.TAS_DRA_ITEM_INFO;
import com.trusteer.tas.TAS_INT_REF;
import com.trusteer.tas.TAS_LONG_REF;
import com.trusteer.tas.TAS_OBJECT;
import com.trusteer.tas.TAS_OBJECT_REF;
import com.trusteer.tas.TAS_STRING_REF;
import com.trusteer.tas.atas;
import com.trusteer.tas.tas;
import com.worklight.common.Logger;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public final class WLTrusteerInternal {
    private static final Logger logger = Logger.getInstance(WLTrusteerInternal.class.getName());
    private static final String TAS_INIT_ERROR = "TasInitialize() failed. Invalid or missing license.";
    private static final String TAS_RECALC_ERROR = "TasDraRecalcRiskAssessment() failed.";
    private static final String TAS_GET_RISK_ERROR = "TasDraGetRiskAssessment() failed.";
    private static final String TAS_GET_DEVICE_KEY_ERROR = "TasGetDeviceKey() failed.";
    private static final String TAS_RISK_TO_JSON_ERROR = "getRiskAssessmentAsJson() failed.";
    private Thread recalcTask = null;
    private String deviceKey;

    public boolean init(Context context) {
        try {
            int initFlags = 0;
            TAS_CLIENT_INFO client = this.getClientInfo(context);
            if (atas.TasInitialize((Context)context, (TAS_CLIENT_INFO)client, (int)initFlags) != 0) {
                logger.error(TAS_INIT_ERROR);
                return false;
            }
            logger.info("Trusteer initialized successfully");
            this.forceRiskAssessment();
            return true;
        }
        catch (Throwable e) {
            logger.error("TasInitialize() failed. Invalid or missing license. " + e);
            return false;
        }
    }

    private void forceRiskAssessment() {
        this.recalcTask = new Thread(new RecalcTask());
        this.recalcTask.start();
    }

    private TAS_CLIENT_INFO getClientInfo(Context context) {
        TAS_CLIENT_INFO client = new TAS_CLIENT_INFO();
        Map<String, String> clientInfo = this.extractClientInformation(context);
        client.setVendorId(clientInfo.get("vendorId"));
        client.setClientId(clientInfo.get("clientId"));
        client.setClientKey(clientInfo.get("clientKey"));
        return client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> extractClientInformation(Context context) {
        HashMap<String, String> clientInfo = new HashMap<String, String>();
        AssetManager assetManager = context.getAssets();
        BufferedReader reader = null;
        try {
            String line;
            InputStream input = assetManager.open("tas.license");
            reader = new BufferedReader(new InputStreamReader(input));
            while ((line = reader.readLine()) != null) {
                String[] strings = TextUtils.split((String)line, (String)"=");
                if (strings.length < 2) continue;
                clientInfo.put(strings[0], strings[1]);
            }
            reader.readLine();
        }
        catch (IOException e) {
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {}
            }
        }
        return clientInfo;
    }

    protected void finalize() {
        try {
            super.finalize();
            tas.TasFinalize();
        }
        catch (Throwable t) {
            logger.debug("TasFinalize failed with error " + t);
        }
    }

    public boolean isRiskAssessmentAvailable() {
        return this.recalcTask == null || !this.recalcTask.isAlive();
    }

    public void waitForRiskAssessment() {
        try {
            if (this.recalcTask != null && this.recalcTask.isAlive()) {
                this.recalcTask.join();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public JSONObject getRiskAssessmentAsJson() {
        JSONObject result = new JSONObject();
        TAS_OBJECT risk = null;
        try {
            TAS_INT_REF count;
            int tasResult;
            result.put("device_key", (Object)this.getDeviceKey());
            risk = this.getRiskAssessment();
            if (risk != null && (tasResult = tas.TasDraGetRiskItemCount((TAS_OBJECT)risk, (TAS_INT_REF)(count = new TAS_INT_REF()))) == 0) {
                for (int index = 0; index < count.get_value(); ++index) {
                    TAS_DRA_ITEM_INFO info = new TAS_DRA_ITEM_INFO();
                    tasResult = tas.TasDraGetRiskAssessmentItemByIndex((TAS_OBJECT)risk, (int)index, (TAS_DRA_ITEM_INFO)info);
                    if (tasResult != 0) continue;
                    JSONObject riskItem = new JSONObject();
                    riskItem.put("value", info.getItemValue());
                    riskItem.put("lastCalculated", info.getLastCalculated().getTime());
                    riskItem.put("additionalData", (Object)info.getAdditionalData());
                    riskItem.put("name", (Object)info.getItemName());
                    result.put(info.getItemName(), (Object)riskItem);
                }
            }
            if (risk == null) return result;
        }
        catch (JSONException e) {
            try {
                logger.error(TAS_RISK_TO_JSON_ERROR);
                if (risk == null) return result;
            }
            catch (Throwable throwable) {
                if (risk == null) throw throwable;
                tas.TasDraReleaseRiskAssessment(risk);
                throw throwable;
            }
            tas.TasDraReleaseRiskAssessment((TAS_OBJECT)risk);
            return result;
        }
        tas.TasDraReleaseRiskAssessment((TAS_OBJECT)risk);
        return result;
    }

    public String getDeviceKey() {
        if (this.deviceKey == null) {
            TAS_STRING_REF key = new TAS_STRING_REF();
            TAS_LONG_REF size = new TAS_LONG_REF();
            tas.TasGetDeviceKey(null, (TAS_LONG_REF)size);
            int tasResult = tas.TasGetDeviceKey((TAS_STRING_REF)key, (TAS_LONG_REF)size);
            if (tasResult == 0) {
                this.deviceKey = key.get_value();
            } else {
                logger.error(TAS_GET_DEVICE_KEY_ERROR);
            }
        }
        return this.deviceKey;
    }

    public TAS_OBJECT getRiskAssessment() {
        TAS_OBJECT_REF tasO = new TAS_OBJECT_REF();
        int tasResult = tas.TasDraGetRiskAssessment((TAS_OBJECT_REF)tasO);
        if (tasResult != 0) {
            logger.error(TAS_GET_RISK_ERROR);
            return null;
        }
        return tasO.get_value();
    }

    private class RecalcTask
    implements Runnable {
        private RecalcTask() {
        }

        @Override
        public void run() {
            try {
                int tasResult = tas.TasDraRecalcRiskAssessment((int)1);
                if (tasResult != 0) {
                    logger.error("TasDraRecalcRiskAssessment() failed. " + tasResult);
                } else {
                    logger.info("TasDraRecalcRiskAssessment() succeeded");
                }
            }
            catch (Throwable e) {
                logger.error("TasDraRecalcRiskAssessment() failed. " + e);
            }
        }
    }
}

