/*
 * Decompiled with CFR 0.152.
 */
package com.worklight.common;

import android.content.Context;
import com.worklight.common.Logger;
import com.worklight.common.internal.WLTrusteerInternal;
import org.json.JSONObject;

public class WLTrusteer {
    private static final Logger logger = Logger.getInstance(WLTrusteer.class.getName());
    private Object _wlTrusteer = new WLTrusteerInternal();
    private static WLTrusteer wlTrusteer = null;
    private static boolean trusteerTest = false;

    public static synchronized WLTrusteer createInstance(Context context) {
        if (wlTrusteer != null) {
            logger.info("WLTrusteer has already been created.");
        } else if (wlTrusteer == null && !trusteerTest) {
            WLTrusteer tmp;
            if (WLTrusteer.checkTrusteerSDK() && (tmp = new WLTrusteer()).init(context)) {
                wlTrusteer = tmp;
            }
            trusteerTest = true;
        }
        return wlTrusteer;
    }

    public static WLTrusteer getInstance() {
        return wlTrusteer;
    }

    public static boolean hasTrusteerSDK() {
        return wlTrusteer != null;
    }

    protected static void releaseInstance() {
        try {
            wlTrusteer.finalize();
            wlTrusteer = null;
            trusteerTest = false;
        }
        catch (Throwable t) {
            logger.warn("WLTrusteer failed to clean up with error " + t);
        }
    }

    private WLTrusteer() {
    }

    private boolean init(Context context) {
        if (this._wlTrusteer == null) {
            return false;
        }
        return ((WLTrusteerInternal)this._wlTrusteer).init(context);
    }

    public String getDeviceKey() {
        if (!WLTrusteer.hasTrusteerSDK()) {
            return null;
        }
        return ((WLTrusteerInternal)this._wlTrusteer).getDeviceKey();
    }

    public JSONObject getRiskAssessment() {
        if (!WLTrusteer.hasTrusteerSDK()) {
            return new JSONObject();
        }
        if (!((WLTrusteerInternal)this._wlTrusteer).isRiskAssessmentAvailable()) {
            ((WLTrusteerInternal)this._wlTrusteer).waitForRiskAssessment();
        }
        return ((WLTrusteerInternal)this._wlTrusteer).getRiskAssessmentAsJson();
    }

    private static boolean checkTrusteerSDK() {
        try {
            Class.forName("com.trusteer.tas.TAS_CLIENT_INFO");
            logger.info("Trusteer SDK found.");
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }
}

