/*
 * Decompiled with CFR 0.152.
 */
package com.worklight.common;

import android.content.Context;
import android.content.pm.PackageManager;
import com.worklight.common.Logger;
import com.worklight.nativeandroid.common.WLUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class WLSimpleDataSharing {
    private static final Logger logger = Logger.getInstance(WLSimpleDataSharing.class.getName());
    private final Context context;
    private static boolean shouldPersist = false;

    public WLSimpleDataSharing(Context context) {
        this.context = context;
        try {
            String sharedUserId = context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).sharedUserId;
            shouldPersist = sharedUserId != null && !sharedUserId.isEmpty();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSharedToken(String key, byte[] value) {
        String[] packages;
        if (key == null || key.trim().equals("")) {
            logger.error("Cannot share a key/value pair where key is empty");
            return;
        }
        for (String packageName : packages = this.context.getPackageManager().getPackagesForUid(this.context.getApplicationInfo().uid)) {
            logger.debug("Attempt to share '" + key + "' with " + packageName);
            try {
                String sanitizedFileName = this.getSanitizedFileName(key);
                File sharedFile = new File(this.context.createPackageContext(packageName, 0).getFilesDir().getAbsolutePath() + "/" + sanitizedFileName);
                if (sharedFile.exists() && !sharedFile.isFile() || sanitizedFileName.length() <= 0 || !shouldPersist) continue;
                FileOutputStream myFos = null;
                try {
                    myFos = new FileOutputStream(sharedFile);
                    myFos.write(value == null ? "".getBytes() : value);
                    myFos.close();
                    logger.debug("Successfully shared '" + key + "' with " + packageName + " to file " + sharedFile.getPath());
                }
                catch (IOException e) {
                    logger.error("Failed to share '" + key + "' with " + packageName + " to file " + sharedFile.getPath(), e);
                }
                finally {
                    if (myFos != null) {
                        try {
                            myFos.close();
                        }
                        catch (IOException e) {}
                    }
                }
            }
            catch (PackageManager.NameNotFoundException e) {
                logger.error("Failed to share '" + key + "' with " + packageName, e);
            }
        }
    }

    public void setSharedToken(String key, String value) {
        this.setSharedToken(key, value == null ? null : value.getBytes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getSharedToken(String key) {
        String[] packages;
        String[] arr$ = packages = this.context.getPackageManager().getPackagesForUid(this.context.getApplicationInfo().uid);
        int len$ = arr$.length;
        int i$ = 0;
        while (i$ < len$) {
            block15: {
                String packageName = arr$[i$];
                try {
                    File sharedFile = new File(this.context.createPackageContext(packageName, 0).getFilesDir().getAbsolutePath() + "/" + this.getSanitizedFileName(key));
                    FileInputStream myFis = null;
                    if (!sharedFile.exists() || !sharedFile.isFile() || !shouldPersist) break block15;
                    try {
                        logger.debug("Attempt to retrieve '" + key + "' from " + packageName + " in file " + sharedFile.getPath());
                        myFis = new FileInputStream(sharedFile);
                        String s = WLUtils.convertStreamToString(myFis);
                        this.setSharedToken(key, s);
                        String string = s == null ? s : s.trim();
                        return string;
                    }
                    catch (IOException e) {
                        logger.error("Failed to retrieve '" + key + "' from " + packageName + " in file " + sharedFile.getPath(), e);
                    }
                    finally {
                        if (myFis != null) {
                            try {
                                myFis.close();
                            }
                            catch (IOException e2) {}
                        }
                    }
                }
                catch (PackageManager.NameNotFoundException e3) {
                    logger.error("Failed to retrieve '" + key + "' with " + packageName, e3);
                }
            }
            ++i$;
        }
        return null;
    }

    public void clearSharedToken(String key) {
        String[] packages;
        for (String packageName : packages = this.context.getPackageManager().getPackagesForUid(this.context.getApplicationInfo().uid)) {
            try {
                File sharedFile = new File(this.context.createPackageContext(packageName, 0).getFilesDir().getAbsolutePath() + "/" + this.getSanitizedFileName(key));
                if (!sharedFile.exists() || !sharedFile.isFile() || !shouldPersist) continue;
                logger.debug("Attempt to delete file '" + sharedFile.getPath() + "' from " + packageName);
                sharedFile.delete();
            }
            catch (PackageManager.NameNotFoundException e) {
                logger.error("Failed to find '" + key + "' with " + packageName, e);
            }
        }
    }

    private String getSanitizedFileName(String key) {
        return key.replaceAll("[^a-zA-Z0-9\\._-]+", "_");
    }
}

