/*
 * Decompiled with CFR 0.152.
 */
package com.worklight.common;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.preference.CheckBoxPreference;
import android.preference.EditTextPreference;
import android.preference.Preference;
import android.preference.PreferenceActivity;
import android.preference.PreferenceCategory;
import android.preference.PreferenceScreen;
import android.util.DisplayMetrics;
import android.util.Patterns;
import com.worklight.common.WLConfig;
import com.worklight.nativeandroid.common.WLUtils;
import java.net.MalformedURLException;
import java.net.URL;

public class WLPreferences
extends PreferenceActivity {
    public static final String EDIT_WL_SERVER_URL_PREF_KEY = "editWLServerURLPref";
    public static final String MODIFY_WL_SERVER_URL_PREF_KEY = "resetWLServerURLPref";
    public static final String SHOULD_MODIFY_URL_PREF_KEY = "shouldModifyUrlPref";
    public static final String LAST_SETTINGS_URL_STATE_PREF_KEY = "lastSettingsUrlStatePref";
    public static final String APP_ID_PREF_KEY = "appIdPref";
    public static final String APP_VERSION_PREF_KEY = "appVersionPref";
    private static final String NEW_APP_ID_PREF_KEY = "newAppIdPref";
    private static final String NEW_APP_VERSION_PREF_KEY = "newAppVersionPref";
    private static final String CANCEL_ID = "WLClient.cancel";
    private static final String OK_ID = "WLClient.ok";
    private static final String RESOURCE_BUNDLE = "com/worklight/wlclient/messages";
    public static final String WL_SERVER_URL = "WLServerURL";
    private static final String NEW_LINE = "\n";
    private String serverURLbefore = null;
    private String serverURLafter = null;
    private EditTextPreference serverURLEditTextPreference = null;
    private CheckBoxPreference modifyServerURLCheckBoxPreference = null;
    private EditTextPreference appIdEditTextPreference = null;
    private EditTextPreference appVersionEditTextPreference = null;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        PreferenceScreen root = this.getPreferenceManager().createPreferenceScreen((Context)this);
        root.setTitle((CharSequence)WLUtils.getResourceString("worklightSettingsTitle", (Context)this));
        PreferenceCategory networkSettingsCategory = new PreferenceCategory((Context)this);
        networkSettingsCategory.setTitle((CharSequence)WLUtils.getResourceString("networkSettingsTitleWLServerUrl", (Context)this));
        root.addPreference((Preference)networkSettingsCategory);
        this.serverURLbefore = WLConfig.getInstance().readWLPref(WL_SERVER_URL);
        this.createModifyServerCheckbox();
        this.createServerURLTextField();
        networkSettingsCategory.addPreference((Preference)this.modifyServerURLCheckBoxPreference);
        networkSettingsCategory.addPreference((Preference)this.serverURLEditTextPreference);
        PreferenceCategory webResourcesCategory = new PreferenceCategory((Context)this);
        webResourcesCategory.setTitle((CharSequence)WLUtils.getResourceString("wlWebResourcesCategory", (Context)this));
        root.addPreference((Preference)webResourcesCategory);
        WLConfig config = WLConfig.getInstance();
        this.appIdEditTextPreference = this.createTextField("wlAppIdTitle", NEW_APP_ID_PREF_KEY, config.getAppId());
        this.appVersionEditTextPreference = this.createTextField("wlAppVersionTitle", NEW_APP_VERSION_PREF_KEY, config.getApplicationVersion());
        webResourcesCategory.addPreference((Preference)this.appIdEditTextPreference);
        webResourcesCategory.addPreference((Preference)this.appVersionEditTextPreference);
        this.setPreferenceScreen(root);
        this.modifyServerURLCheckBoxPreference.setOnPreferenceChangeListener(new Preference.OnPreferenceChangeListener(){

            public boolean onPreferenceChange(Preference preference, Object newValue) {
                Boolean allowModifyURL = (Boolean)newValue;
                if (allowModifyURL.booleanValue()) {
                    WLConfig.getInstance().writeWLPref(WLPreferences.SHOULD_MODIFY_URL_PREF_KEY, "true");
                    WLPreferences.this.serverURLEditTextPreference.setEnabled(true);
                    WLPreferences.this.serverURLafter = WLPreferences.this.serverURLEditTextPreference.getText();
                    WLConfig.getInstance().writeWLPref(WLPreferences.WL_SERVER_URL, WLPreferences.this.serverURLafter);
                } else {
                    WLConfig.getInstance().writeWLPref(WLPreferences.SHOULD_MODIFY_URL_PREF_KEY, "false");
                    WLPreferences.this.serverURLafter = WLConfig.getInstance().getRootURL();
                    WLConfig.getInstance().writeWLPref(WLPreferences.WL_SERVER_URL, WLPreferences.this.serverURLafter);
                    WLPreferences.this.serverURLEditTextPreference.setEnabled(false);
                }
                return true;
            }
        });
        this.serverURLEditTextPreference.setOnPreferenceChangeListener(new Preference.OnPreferenceChangeListener(){

            public boolean onPreferenceChange(Preference preference, Object newValue) {
                block8: {
                    WLPreferences.this.serverURLafter = (String)newValue;
                    try {
                        if (WLPreferences.this.serverURLafter.startsWith("http://[") || WLPreferences.this.serverURLafter.startsWith("https://[")) {
                            try {
                                String ipv6domain = WLPreferences.this.serverURLafter.substring(WLPreferences.this.serverURLafter.indexOf(91) + 1, WLPreferences.this.serverURLafter.indexOf(93));
                                String ipv6path = WLPreferences.this.serverURLafter.substring(WLPreferences.this.serverURLafter.indexOf(93) + 1);
                                if (!ipv6domain.matches("(([0-9a-fA-F]{1,4}:){7,7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:)|fe80:(:[0-9a-fA-F]{0,4}){0,4}%[0-9a-zA-Z]{1,}|::(ffff(:0{1,4}){0,1}:){0,1}((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9]).){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])|([0-9a-fA-F]{1,4}:){1,4}:((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9]).){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9]))")) {
                                    throw new MalformedURLException();
                                }
                                if (!Patterns.WEB_URL.matcher("http://9.8.7.6" + ipv6path).matches()) {
                                    throw new MalformedURLException();
                                }
                                break block8;
                            }
                            catch (StringIndexOutOfBoundsException e) {
                                throw new MalformedURLException();
                            }
                        }
                        new URL(WLPreferences.this.serverURLafter);
                        if (!Patterns.WEB_URL.matcher(WLPreferences.this.serverURLafter).matches()) {
                            throw new MalformedURLException();
                        }
                    }
                    catch (MalformedURLException e) {
                        new AlertDialog.Builder((Context)WLPreferences.this).setTitle((CharSequence)WLUtils.getResourceString("titleInvalidWLServerUrl", (Context)WLPreferences.this)).setMessage((CharSequence)WLUtils.getResourceString("errorInvalidWLServerUrl", WLPreferences.this.serverURLafter, (Context)WLPreferences.this)).setNeutralButton((CharSequence)WLUtils.getResourceString("OKTitleWLServerUrl", (Context)WLPreferences.this), new DialogInterface.OnClickListener(){

                            public void onClick(DialogInterface dialog, int which) {
                            }
                        }).show();
                        return false;
                    }
                }
                WLConfig.getInstance().writeWLPref(WLPreferences.WL_SERVER_URL, WLPreferences.this.serverURLafter);
                WLConfig.getInstance().writeWLPref(WLPreferences.LAST_SETTINGS_URL_STATE_PREF_KEY, WLPreferences.this.serverURLafter);
                WLPreferences.this.setServerURLFieldSummary();
                return true;
            }
        });
        this.appIdEditTextPreference.setOnPreferenceChangeListener(new Preference.OnPreferenceChangeListener(){

            public boolean onPreferenceChange(Preference preference, Object newValue) {
                String newAppId = (String)newValue;
                WLConfig.getInstance().writeWLPref(WLPreferences.NEW_APP_ID_PREF_KEY, newAppId);
                WLPreferences.this.appIdEditTextPreference.setSummary((CharSequence)newAppId);
                return true;
            }
        });
        this.appVersionEditTextPreference.setOnPreferenceChangeListener(new Preference.OnPreferenceChangeListener(){

            public boolean onPreferenceChange(Preference preference, Object newValue) {
                String newAppVersion = (String)newValue;
                WLConfig.getInstance().writeWLPref(WLPreferences.NEW_APP_VERSION_PREF_KEY, newAppVersion);
                WLPreferences.this.appVersionEditTextPreference.setSummary((CharSequence)newAppVersion);
                return true;
            }
        });
    }

    private void createServerURLTextField() {
        String description = WLUtils.getResourceString("summaryWLServerUrl", (Context)this);
        this.serverURLEditTextPreference = new EditTextPreference((Context)this);
        this.serverURLbefore = WLConfig.getInstance().readWLPref(WL_SERVER_URL);
        if (this.serverURLbefore == null || this.serverURLbefore.trim().equals("")) {
            this.serverURLbefore = WLConfig.getInstance().getRootURL();
        }
        this.serverURLEditTextPreference.setTitle((CharSequence)WLUtils.getResourceString("titleWLServerUrl", (Context)this));
        this.serverURLEditTextPreference.setKey(EDIT_WL_SERVER_URL_PREF_KEY);
        this.serverURLEditTextPreference.setPositiveButtonText((CharSequence)WLUtils.getResourceString("OKTitleWLServerUrl", (Context)this));
        this.serverURLEditTextPreference.setNegativeButtonText((CharSequence)WLUtils.getResourceString("cancel", (Context)this));
        this.serverURLEditTextPreference.setDefaultValue((Object)this.serverURLbefore);
        String lastSavedUrl = WLConfig.getInstance().readWLPref(LAST_SETTINGS_URL_STATE_PREF_KEY);
        this.serverURLEditTextPreference.setSummary((CharSequence)(lastSavedUrl == null ? description : lastSavedUrl + NEW_LINE + description));
        String modifyCheckState = WLConfig.getInstance().readWLPref(SHOULD_MODIFY_URL_PREF_KEY);
        this.serverURLEditTextPreference.setEnabled(modifyCheckState != null && Boolean.valueOf(modifyCheckState) != false);
        this.serverURLEditTextPreference.setPersistent(true);
    }

    private void createModifyServerCheckbox() {
        this.modifyServerURLCheckBoxPreference = new CheckBoxPreference((Context)this);
        this.modifyServerURLCheckBoxPreference.setTitle((CharSequence)WLUtils.getResourceString("serverAddress", (Context)this));
        this.modifyServerURLCheckBoxPreference.setSummary((CharSequence)WLUtils.getResourceString("changeServerAddress", (Context)this));
        this.modifyServerURLCheckBoxPreference.setKey(MODIFY_WL_SERVER_URL_PREF_KEY);
        this.modifyServerURLCheckBoxPreference.setPersistent(true);
    }

    private void setServerURLFieldSummary() {
        String summary = (String)this.serverURLEditTextPreference.getSummary();
        if (summary.contains(NEW_LINE)) {
            summary = summary.substring(summary.lastIndexOf(NEW_LINE) + 1, summary.length());
        }
        if (this.serverURLafter == null) {
            this.serverURLEditTextPreference.setSummary((CharSequence)(this.serverURLbefore + NEW_LINE + summary));
        } else {
            this.serverURLEditTextPreference.setSummary((CharSequence)(this.serverURLafter + NEW_LINE + summary));
        }
    }

    private boolean isUrlChanged() {
        if (this.serverURLafter == null) {
            return false;
        }
        if (this.serverURLbefore == null) {
            return this.serverURLafter != null;
        }
        return !this.serverURLbefore.equals(this.serverURLafter);
    }

    private EditTextPreference createTextField(String titleKey, String prefKey, String defaultValue) {
        EditTextPreference pref = new EditTextPreference((Context)this);
        pref.setTitle((CharSequence)WLUtils.getResourceString(titleKey, (Context)this));
        String value = WLConfig.getInstance().readWLPref(prefKey);
        if (value == null) {
            value = defaultValue;
        }
        WLConfig.getInstance().writeWLPref(prefKey, value);
        pref.setSummary((CharSequence)value);
        pref.setDefaultValue((Object)value);
        pref.setKey(prefKey);
        pref.setPersistent(true);
        pref.setPositiveButtonText((CharSequence)WLUtils.getResourceString("OKTitleWLServerUrl", (Context)this));
        pref.setNegativeButtonText((CharSequence)WLUtils.getResourceString("cancel", (Context)this));
        DisplayMetrics displaymetrics = new DisplayMetrics();
        this.getWindowManager().getDefaultDisplay().getMetrics(displaymetrics);
        int screenWidth = displaymetrics.widthPixels;
        pref.getEditText().setWidth(screenWidth - 20);
        return pref;
    }

    private boolean isWebResourcesChanged() {
        boolean appIdChanged = !WLConfig.getInstance().getAppId().equals(WLConfig.getInstance().readWLPref(NEW_APP_ID_PREF_KEY));
        boolean appVersionChanged = !WLConfig.getInstance().getApplicationVersion().equals(WLConfig.getInstance().readWLPref(NEW_APP_VERSION_PREF_KEY));
        return appIdChanged || appVersionChanged;
    }

    public void onBackPressed() {
        Intent settings = new Intent();
        settings.putExtra("isServerURLChanged", this.isUrlChanged());
        settings.putExtra("serverURL", this.serverURLafter);
        settings.putExtra("isWebResourcesChanged", this.isWebResourcesChanged());
        this.setResult(-1, settings);
        super.onBackPressed();
    }
}

