/*
 * Decompiled with CFR 0.152.
 */
package com.worklight.common;

import android.content.Context;
import android.content.SharedPreferences;
import com.worklight.nativeandroid.common.WLUtils;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;

public class WLConfig {
    public static final String WL_CLIENT_PROPS_NAME = "wlclient.properties";
    public static final String WL_X_VERSION_HEADER = "x-wl-app-version";
    public static final String WL_X_PLATFORM_VERSION = "x-wl-platform-version";
    public static final String ENABLE_SETTINGS = "enableSettings";
    public static final String WL_APP_VERSION = "wlAppVersion";
    public static final String WL_APP_ID = "wlAppId";
    public static final String WL_SERVER_HOST = "wlServerHost";
    public static final String WL_SERVER_PROTOCOL = "wlServerProtocol";
    public static final String WL_SERVER_PORT = "wlServerPort";
    public static final String WL_SERVER_CONTEXT = "wlServerContext";
    private static final String WL_ENVIRONMENT = "wlEnvironment";
    public static final String WL_GCM_SENDER = "GcmSenderId";
    public static final String WL_WEB_RESOURCES_UNPACKD_SIZE = "webResourcesSize";
    public static final String WL_PLATFORM_VERSION = "wlPlatformVersion";
    public static final String WL_MAIN_FILE_PATH = "wlMainFilePath";
    public static final String WL_SHARE_COOKIES = "wlShareCookies";
    public static final String WL_SHARE_USER_CERT = "wlShareUserCert";
    private static final String WL_IS_EXTERNAL_WEBRESOURCES = "WLIsExternalWebResources";
    private static final String IGNORED_FILE_EXTENSIONS = "ignoredFileExtensions";
    private static final String WL_PREFS = "WLPrefs";
    private static final String WL_TEST_WEB_RESOURCES_CHECKSUM = "testWebResourcesChecksum";
    private static final String WL_RESOURCES_CHECKSUM_PREF_KEY = "wlResourcesChecksum";
    private static final String WL_SKIN_NAME_PREF_KEY = "wlSkinName";
    private static final String CLEAR_CACHE_NEXT_LOAD = "com.worklight.clearCacheNextLoad";
    private static final String EXIT_ON_SKIN_LOADER = "exitOnSkinLoader";
    private static final String WL_DEFAULT_SERVER_URL = "WLDefaultServerURL";
    private static final String APP_INSTALL_TIME_KEY = "appInstallTime";
    private static final String ANDROID_ASSET = "/android_asset";
    private static final String NATIVE_EMPTY_APP_HTML = "NativeEmptyApp.html";
    private static final String IN_PROGRESS_CHECKSUM = "inProgressChecksum";
    private static final String LANGUAGE_PREFS = "languagePreferences";
    private Properties wlProperties = new Properties();
    private SharedPreferences prefs = null;
    private String absolutePathToExternalAppFiles;
    private boolean isInitComplete = false;
    private boolean isApplicationForeground = false;
    private static WLConfig singleton = null;

    private WLConfig(Context context) {
        try {
            this.wlProperties.load(context.getAssets().open(WL_CLIENT_PROPS_NAME));
            this.prefs = context.getSharedPreferences(WL_PREFS, 0);
            this.absolutePathToExternalAppFiles = context.getFilesDir().getAbsolutePath();
        }
        catch (IOException e) {
            throw new RuntimeException("WLConfig(): Can't load wlclient.properties file");
        }
    }

    public static synchronized void createInstance(Context context) {
        if (singleton == null) {
            singleton = new WLConfig(context.getApplicationContext());
        }
    }

    public static WLConfig getInstance() {
        if (singleton == null) {
            throw new IllegalStateException("getInstance can't be called before createInstance");
        }
        return singleton;
    }

    public void writeWLPref(String prefName, String PrefValue) {
        SharedPreferences.Editor editor = this.prefs.edit();
        editor.putString(prefName, PrefValue);
        editor.commit();
    }

    public String readWLPref(String prefName) {
        return this.prefs.getString(prefName, null);
    }

    public void writeLongWLPref(String prefName, long PrefValue) {
        SharedPreferences.Editor editor = this.prefs.edit();
        editor.putLong(prefName, PrefValue);
        editor.commit();
    }

    public long readLongWLPref(String prefName) {
        return this.prefs.getLong(prefName, 0L);
    }

    public void clearWLPref() {
        SharedPreferences.Editor editor = this.prefs.edit();
        editor.clear();
        editor.commit();
    }

    public void setExternalWebResourcesPref(boolean isExternal) {
        this.writeWLPref(WL_IS_EXTERNAL_WEBRESOURCES, Boolean.toString(isExternal));
    }

    public boolean isShareUserCert() {
        String isGroupSupportUserCertEnabled = this.wlProperties.getProperty(WL_SHARE_USER_CERT);
        return Boolean.valueOf(isGroupSupportUserCertEnabled);
    }

    public List<String> getShareCookies() {
        String credShareCookies = this.wlProperties.getProperty(WL_SHARE_COOKIES);
        credShareCookies = credShareCookies == null ? "" : credShareCookies;
        return Arrays.asList(credShareCookies.split(","));
    }

    public boolean isExternalWebResources() {
        String isExternal = this.readWLPref(WL_IS_EXTERNAL_WEBRESOURCES);
        return Boolean.valueOf(isExternal);
    }

    public void setClearCacheNextLoadPref(boolean value) {
        SharedPreferences.Editor editor = this.prefs.edit();
        editor.putBoolean(CLEAR_CACHE_NEXT_LOAD, value);
        editor.commit();
    }

    public boolean isClearCacheNextLoad() {
        return this.prefs.getBoolean(CLEAR_CACHE_NEXT_LOAD, false);
    }

    public void setExitOnSkinLoaderPref(boolean value) {
        this.writeWLPref(EXIT_ON_SKIN_LOADER, Boolean.toString(value));
    }

    public String getSkinNamePref() {
        return this.readWLPref(WL_SKIN_NAME_PREF_KEY);
    }

    public String getResourceChecksumPref() {
        return this.readWLPref(WL_RESOURCES_CHECKSUM_PREF_KEY);
    }

    public void setResourceChecksumPref(String value) {
        this.writeWLPref(WL_RESOURCES_CHECKSUM_PREF_KEY, value);
    }

    public URL getAppURL() {
        try {
            return new URL(this.getRootURL() + "/apps/services/api/" + this.getAppId() + "/" + this.getWLEnvironment() + "/");
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Could not parse URL; check assets/wlclient.properties. " + e.getMessage(), e);
        }
    }

    public String getAppId() {
        return this.getPropertyOrPref(WL_APP_ID, "appIdPref");
    }

    public String getWLEnvironment() {
        String result = this.wlProperties.getProperty(WL_ENVIRONMENT, null);
        if (result == null) {
            result = "android";
        }
        return result;
    }

    public String getApplicationVersion() {
        return this.getPropertyOrPref(WL_APP_VERSION, "appVersionPref");
    }

    public void setDefaultRootUrlPref() {
        this.writeWLPref(WL_DEFAULT_SERVER_URL, this.getDefaultRootUrl());
    }

    private String getDefaultRootUrl() {
        boolean isDefaultHttpsPort = "https".equalsIgnoreCase(this.getProtocol()) && "443".equals(this.getPort());
        String port = WLUtils.isStringEmpty(this.getPort()) || isDefaultHttpsPort ? "" : ":" + this.getPort();
        String context = WLUtils.isStringEmpty(this.getServerContext()) || this.getServerContext().equals("/") ? "" : this.getServerContext();
        String url = String.format("%s://%s%s%s", this.getProtocol(), this.getHost(), port, context);
        if (url.endsWith("/")) {
            url = url.substring(0, url.length() - 1);
        }
        return url;
    }

    public String getRootURL() {
        String result = this.prefs.getString("WLServerURL", null);
        if (result == null) {
            result = this.getDefaultRootUrl();
        }
        return result;
    }

    public String[] getMediaExtensions() {
        String mediaExtentionStr = this.wlProperties.getProperty(IGNORED_FILE_EXTENSIONS);
        if (mediaExtentionStr != null) {
            String[] mediaExtentionArr = mediaExtentionStr.replaceAll(" ", "").split(",");
            return mediaExtentionArr;
        }
        return null;
    }

    public String getGCMSender() {
        String wlGCMSender = this.wlProperties.getProperty(WL_GCM_SENDER);
        if (wlGCMSender != null) {
            return wlGCMSender.trim();
        }
        return wlGCMSender;
    }

    public String getSettingsFlag() {
        return this.wlProperties.getProperty(ENABLE_SETTINGS);
    }

    public String getTestWebResourcesChecksumFlag() {
        return this.wlProperties.getProperty(WL_TEST_WEB_RESOURCES_CHECKSUM);
    }

    public String getProtocol() {
        return this.wlProperties.getProperty(WL_SERVER_PROTOCOL);
    }

    public String getHost() {
        return this.wlProperties.getProperty(WL_SERVER_HOST);
    }

    public String getPort() {
        return this.wlProperties.getProperty(WL_SERVER_PORT);
    }

    public String getServerContext() {
        return this.wlProperties.getProperty(WL_SERVER_CONTEXT);
    }

    private String getPropertyOrPref(String propertyKey, String prefKey) {
        String result = this.prefs.getString(prefKey, null);
        if (result == null) {
            result = (String)this.wlProperties.get(propertyKey);
        }
        return result;
    }

    public String getMainFilePath() {
        return this.getAppId() + ".html";
    }

    public String getWebResourcesUnpackedSize() {
        return this.wlProperties.getProperty(WL_WEB_RESOURCES_UNPACKD_SIZE);
    }

    public String getPlatformVersion() {
        return this.wlProperties.getProperty(WL_PLATFORM_VERSION);
    }

    public String getMainFileFromDescriptor() {
        return this.wlProperties.getProperty(WL_MAIN_FILE_PATH);
    }

    public String getLanguagePreferences() {
        return this.wlProperties.getProperty(LANGUAGE_PREFS);
    }

    public boolean isShouldTestWebResourcesChecksum() {
        return this.getTestWebResourcesChecksumFlag().equals("true");
    }

    public long getApplicationInstallTime() {
        return this.readLongWLPref(APP_INSTALL_TIME_KEY);
    }

    public void setApplicationInstallTime(long value) {
        this.writeLongWLPref(APP_INSTALL_TIME_KEY, value);
    }

    public String getApplicationAbsolutePathToExternalAppFiles() {
        return this.absolutePathToExternalAppFiles;
    }

    public String getApplicationAbsolutePathToExternalWWWFiles() {
        return this.absolutePathToExternalAppFiles + "/www";
    }

    public String getLocalStorageRoot() {
        return this.isExternalWebResources() ? this.getApplicationAbsolutePathToExternalAppFiles() : ANDROID_ASSET;
    }

    public String getWebResourcesUrl() {
        return this.getLocalStorageRoot() + "/www";
    }

    public String getWebUrl() {
        return "file://" + this.getWebResourcesUrl();
    }

    public boolean isHybridActivityInForeground() {
        return this.isApplicationForeground;
    }

    public void setHybridActivityInForeground(boolean value) {
        this.isApplicationForeground = value;
    }

    public boolean isInitComplete() {
        return this.isInitComplete;
    }

    public void setInitComplete(boolean value) {
        this.isInitComplete = value;
    }

    public long getInProgressChecksumPref() {
        return this.readLongWLPref(IN_PROGRESS_CHECKSUM);
    }

    public void setInProgressChecksumPref(long currentChecksum) {
        this.writeLongWLPref(IN_PROGRESS_CHECKSUM, currentChecksum);
    }

    public String getAppWebUrl(String skinName) {
        String mainHTMLFile = this.getMainFileFromDescriptor();
        File file = new File(this.getWebResourcesUrl() + "/" + skinName + "/" + NATIVE_EMPTY_APP_HTML);
        if (file.exists()) {
            mainHTMLFile = NATIVE_EMPTY_APP_HTML;
        }
        return this.getWebUrl() + "/" + skinName + "/" + mainHTMLFile;
    }
}

