/*
 * Decompiled with CFR 0.152.
 */
package com.worklight.common;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.os.Build;
import android.util.Log;
import com.worklight.common.WLAnalytics;
import com.worklight.common.WLConfig;
import com.worklight.common.internal.JULHandler;
import com.worklight.common.security.WLDeviceAuthManager;
import com.worklight.wlclient.WLRequest;
import com.worklight.wlclient.WLRequestListener;
import com.worklight.wlclient.api.WLClient;
import com.worklight.wlclient.api.WLFailResponse;
import com.worklight.wlclient.api.WLRequestOptions;
import com.worklight.wlclient.api.WLResponse;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.WeakHashMap;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import javax.security.auth.x500.X500Principal;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class Logger {
    public static final Object WAIT_LOCK = new Object();
    private static final String LOG_TAG = Logger.class.getName();
    private static final String CONTEXT_NULL_MSG = Logger.class.getName() + ".setContext(Context) must be called to fully enable debug log capture.  Currently, the 'capture' flag is set but the 'context' field is not.  This warning will only be printed once.";
    private static boolean context_null_msg_already_printed = false;
    public static final String FILENAME = "wl.log";
    public static final String ANALYTICS_FILENAME = "analytics.log";
    public static final String SHARED_PREF_KEY = Logger.class.getName();
    protected static final String SHARED_PREF_KEY_logFileMaxSize = "logFileMaxSize";
    protected static final String SHARED_PREF_KEY_autoSendLogs = "autoSendLogs";
    protected static final String SHARED_PREF_KEY_autoUpdateConfig = "autoUpdateConfig";
    public static final String SHARED_PREF_KEY_CRASH_DETECTED = "crashDetected";
    public static final String SHARED_PREF_KEY_logPersistence = "logPersistence";
    public static final String SHARED_PREF_KEY_level = "level";
    public static final String SHARED_PREF_KEY_filters = "filters";
    public static final String SHARED_PREF_KEY_logPersistence_from_server = "logPersistenceFromServer";
    public static final String SHARED_PREF_KEY_level_from_server = "levelFromServer";
    public static final String SHARED_PREF_KEY_filters_from_server = "filtersFromServer";
    public static final boolean DEFAULT_capture = true;
    public static final boolean DEFAULT_analyticsCapture = true;
    protected static final int DEFAULT_logFileMaxSize = 100000;
    public static final int MAX_NUM_LOG_FILES = 2;
    private static long priorAutoTriggerTime = 0L;
    private static Timer timer;
    private static Boolean autoSendLogs;
    private static Boolean autoUpdateConfig;
    private static final String HEADER_PREFIX = "x-wl-clientlog-";
    private static final String HEADER_DEVICE_ID = "deviceId";
    private static final String HEADER_APP_NAME = "appname";
    private static final String HEADER_APP_VERSION = "appversion";
    private static final String HEADER_ENVIRONMENT = "env";
    private static final String HEADER_MODEL = "model";
    private static final String HEADER_OS_VERSION = "osversion";
    private static Context context;
    private static Boolean capture;
    private static Boolean analyticsCapture;
    private static Integer logFileMaxSize;
    private static LEVEL level;
    private static JULHandler julHandler;
    private static HashMap<String, LEVEL> filters;
    private static UncaughtExceptionHandler uncaughtExceptionHandler;
    private static WeakHashMap<String, Logger> instances;
    private static final ThreadPoolExecutor ThreadPoolWorkQueue;
    private final String tag;
    private static FileLoggerInterface fileLoggerInstance;

    private Logger(String tag) {
        if (fileLoggerInstance == null) {
            fileLoggerInstance = FileLogger.getInstance();
        }
        this.tag = tag == null || tag.trim().equals("") ? "NONE" : tag.trim();
    }

    protected static void unsetContext() {
        instances.clear();
        context = null;
        capture = null;
        analyticsCapture = null;
        logFileMaxSize = null;
        level = null;
        filters = null;
        uncaughtExceptionHandler = null;
        fileLoggerInstance = null;
        autoSendLogs = null;
        autoUpdateConfig = null;
        LogManager.getLogManager().getLogger("").removeHandler(julHandler);
    }

    public static synchronized Logger getInstance(String tag) {
        Logger logger = instances.get(tag);
        if (null == logger) {
            logger = new Logger(tag);
            instances.put(tag, logger);
        }
        return logger;
    }

    public static void setContext(Context _context) {
        if (null == context) {
            LogManager.getLogManager().getLogger("").addHandler(julHandler);
            java.util.logging.Logger.getLogger("").setLevel(Level.ALL);
            context = _context;
            if (fileLoggerInstance == null || fileLoggerInstance instanceof FileLogger) {
                fileLoggerInstance = FileLogger.getInstance();
            }
            try {
                WLClient.getInstance();
            }
            catch (RuntimeException e) {
                WLClient.createInstance(context);
            }
            SharedPreferences prefs = context.getSharedPreferences(SHARED_PREF_KEY, 0);
            if (null != level) {
                Logger.setLevelSync(level);
            } else {
                Logger.setLevelSync(LEVEL.fromString(prefs.getString(SHARED_PREF_KEY_level, Logger.getLevelDefault().toString())));
            }
            if (null != logFileMaxSize) {
                Logger.setMaxFileSize(logFileMaxSize);
            } else {
                Logger.setMaxFileSize(prefs.getInt(SHARED_PREF_KEY_logFileMaxSize, 100000));
            }
            if (null != capture) {
                Logger.setCaptureSync(capture);
            } else {
                Logger.setCaptureSync(prefs.getBoolean(SHARED_PREF_KEY_logPersistence, true));
            }
            if (null != autoSendLogs) {
                Logger.setAutoSendLogsSync(autoSendLogs);
            } else {
                Logger.setAutoSendLogsSync(prefs.getBoolean(SHARED_PREF_KEY_autoSendLogs, true));
            }
            if (null != autoUpdateConfig) {
                Logger.setAutoUpdateConfigSync(autoUpdateConfig);
            } else {
                Logger.setAutoUpdateConfigSync(prefs.getBoolean(SHARED_PREF_KEY_autoUpdateConfig, true));
            }
            if (null != filters) {
                Logger.setFiltersSync(filters);
            } else {
                try {
                    Logger.setFiltersSync(Logger.JSONObjectToHashMap(new JSONObject(prefs.getString(SHARED_PREF_KEY_filters, "{}"))));
                }
                catch (JSONException jSONException) {
                    // empty catch block
                }
            }
            uncaughtExceptionHandler = new UncaughtExceptionHandler();
            Thread.setDefaultUncaughtExceptionHandler(uncaughtExceptionHandler);
        }
    }

    public static void setLevel(final LEVEL desiredLevel) {
        ThreadPoolWorkQueue.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Logger.setLevelSync(desiredLevel);
                Object object = WAIT_LOCK;
                synchronized (object) {
                    WAIT_LOCK.notifyAll();
                }
            }
        });
    }

    private static synchronized void setLevelSync(LEVEL desiredLevel) {
        if (null == desiredLevel) {
            return;
        }
        level = desiredLevel;
        if (null != context) {
            SharedPreferences prefs = context.getSharedPreferences(SHARED_PREF_KEY, 0);
            prefs.edit().putString(SHARED_PREF_KEY_level, level.toString()).commit();
            level = LEVEL.fromString(prefs.getString(SHARED_PREF_KEY_level_from_server, level.toString()));
        }
    }

    public static LEVEL getLevel() {
        Future<LEVEL> task = ThreadPoolWorkQueue.submit(new Callable<LEVEL>(){

            @Override
            public LEVEL call() {
                return Logger.getLevelSync();
            }
        });
        try {
            return task.get();
        }
        catch (Exception e) {
            return Logger.getLevelSync();
        }
    }

    private static synchronized LEVEL getLevelSync() {
        LEVEL returnValue;
        LEVEL lEVEL = returnValue = null == level ? Logger.getLevelDefault() : level;
        if (null != context) {
            SharedPreferences prefs = context.getSharedPreferences(SHARED_PREF_KEY, 0);
            returnValue = LEVEL.fromString(prefs.getString(SHARED_PREF_KEY_level_from_server, returnValue.toString()));
        }
        return returnValue;
    }

    public static void setCapture(final boolean _capture) {
        ThreadPoolWorkQueue.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Logger.setCaptureSync(_capture);
                Object object = WAIT_LOCK;
                synchronized (object) {
                    WAIT_LOCK.notifyAll();
                }
            }
        });
    }

    private static synchronized void setCaptureSync(boolean _capture) {
        capture = _capture;
        if (null != context) {
            SharedPreferences prefs = context.getSharedPreferences(SHARED_PREF_KEY, 0);
            prefs.edit().putBoolean(SHARED_PREF_KEY_logPersistence, capture.booleanValue()).commit();
            capture = prefs.getBoolean(SHARED_PREF_KEY_logPersistence_from_server, capture.booleanValue());
        }
    }

    public static void setAutoSendLogs(final boolean _autoSendLogs) {
        ThreadPoolWorkQueue.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Logger.setAutoSendLogsSync(_autoSendLogs);
                Object object = WAIT_LOCK;
                synchronized (object) {
                    WAIT_LOCK.notifyAll();
                }
            }
        });
    }

    private static synchronized void setAutoSendLogsSync(boolean _autoSendLogs) {
        autoSendLogs = _autoSendLogs;
        if (null != context) {
            SharedPreferences prefs = context.getSharedPreferences(SHARED_PREF_KEY, 0);
            prefs.edit().putBoolean(SHARED_PREF_KEY_autoSendLogs, autoSendLogs.booleanValue()).commit();
        }
    }

    public static void setAutoUpdateConfig(final boolean _autoUpdateConfig) {
        ThreadPoolWorkQueue.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Logger.setAutoUpdateConfigSync(_autoUpdateConfig);
                Object object = WAIT_LOCK;
                synchronized (object) {
                    WAIT_LOCK.notifyAll();
                }
            }
        });
    }

    private static synchronized void setAutoUpdateConfigSync(boolean _autoUpdateConfig) {
        autoUpdateConfig = _autoUpdateConfig;
        if (null != context) {
            SharedPreferences prefs = context.getSharedPreferences(SHARED_PREF_KEY, 0);
            prefs.edit().putBoolean(SHARED_PREF_KEY_autoUpdateConfig, autoUpdateConfig.booleanValue()).commit();
        }
    }

    public static boolean getCapture() {
        Future<Boolean> task = ThreadPoolWorkQueue.submit(new Callable<Boolean>(){

            @Override
            public Boolean call() {
                return Logger.getCaptureSync();
            }
        });
        try {
            return task.get();
        }
        catch (Exception e) {
            return Logger.getCaptureSync();
        }
    }

    private static synchronized boolean getCaptureSync() {
        boolean returnValue;
        boolean bl = returnValue = null == capture ? true : capture;
        if (null != context) {
            SharedPreferences prefs = context.getSharedPreferences(SHARED_PREF_KEY, 0);
            returnValue = prefs.getBoolean(SHARED_PREF_KEY_logPersistence_from_server, returnValue);
        }
        return returnValue;
    }

    public static void setAnalyticsCapture(final boolean _capture) {
        ThreadPoolWorkQueue.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Logger.setAnalyticsCaptureSync(_capture);
                Object object = WAIT_LOCK;
                synchronized (object) {
                    WAIT_LOCK.notifyAll();
                }
            }
        });
    }

    private static synchronized void setAnalyticsCaptureSync(boolean _capture) {
        analyticsCapture = _capture;
    }

    public static boolean getAnalyticsCapture() {
        Future<Boolean> task = ThreadPoolWorkQueue.submit(new Callable<Boolean>(){

            @Override
            public Boolean call() {
                return Logger.getAnalyticsCaptureSync();
            }
        });
        try {
            return task.get();
        }
        catch (Exception e) {
            return Logger.getAnalyticsCaptureSync();
        }
    }

    private static synchronized boolean getAnalyticsCaptureSync() {
        boolean returnValue = null == analyticsCapture ? true : analyticsCapture;
        return returnValue;
    }

    public static void setFilters(final HashMap<String, LEVEL> _filters) {
        ThreadPoolWorkQueue.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Logger.setFiltersSync(_filters);
                Object object = WAIT_LOCK;
                synchronized (object) {
                    WAIT_LOCK.notifyAll();
                }
            }
        });
    }

    private static void setFiltersSync(HashMap<String, LEVEL> _filters) {
        filters = _filters;
        if (null != context) {
            SharedPreferences prefs = context.getSharedPreferences(SHARED_PREF_KEY, 0);
            prefs.edit().putString(SHARED_PREF_KEY_filters, Logger.HashMapToJSONObject(filters).toString()).commit();
            try {
                filters = Logger.JSONObjectToHashMap(new JSONObject(prefs.getString(SHARED_PREF_KEY_filters_from_server, Logger.HashMapToJSONObject(filters).toString())));
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
    }

    public static HashMap<String, LEVEL> getFilters() {
        Future<HashMap<String, LEVEL>> task = ThreadPoolWorkQueue.submit(new Callable<HashMap<String, LEVEL>>(){

            @Override
            public HashMap<String, LEVEL> call() {
                return Logger.getFiltersSync();
            }
        });
        try {
            return task.get();
        }
        catch (Exception e) {
            return Logger.getFiltersSync();
        }
    }

    private static synchronized HashMap<String, LEVEL> getFiltersSync() {
        HashMap<String, LEVEL> returnValue = filters;
        if (null != context) {
            SharedPreferences prefs = context.getSharedPreferences(SHARED_PREF_KEY, 0);
            try {
                returnValue = Logger.JSONObjectToHashMap(new JSONObject(prefs.getString(SHARED_PREF_KEY_filters_from_server, Logger.HashMapToJSONObject(returnValue).toString())));
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return returnValue;
    }

    public static void setMaxFileSize(int bytes) {
        if (bytes >= 10000) {
            logFileMaxSize = bytes;
        }
        if (null != context) {
            SharedPreferences prefs = context.getSharedPreferences(SHARED_PREF_KEY, 0);
            prefs.edit().putInt(SHARED_PREF_KEY_logFileMaxSize, logFileMaxSize.intValue()).commit();
        }
    }

    public static int getMaxFileSize() {
        return null == logFileMaxSize ? 100000 : logFileMaxSize;
    }

    public static void send() {
        Logger.sendFiles(FILENAME);
    }

    public static void sendAnalytics() {
        Logger.sendFiles(ANALYTICS_FILENAME);
    }

    public static synchronized void updateConfigFromServer() {
        WLRequestListener requestListener = new WLRequestListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSuccess(WLResponse wlResponse) {
                block28: {
                    try {
                        if (null == context) {
                            return;
                        }
                        if (wlResponse.getStatus() == 200) {
                            JSONObject responseJSONObject = wlResponse.getResponseJSON();
                            if (responseJSONObject == null) {
                                Logger.getInstance(LOG_TAG).error("Server replied with 200 but had no JSON payload.  Ignoring this reply.");
                                return;
                            }
                            Logger.getInstance(LOG_TAG).trace("Processing server reply 200 OK.  Payload: " + responseJSONObject.toString());
                            if (!responseJSONObject.has("wllogger")) break block28;
                            try {
                                JSONObject loggerJSONObject = responseJSONObject.getJSONObject("wllogger");
                                if (loggerJSONObject.has("capture")) {
                                    context.getSharedPreferences(SHARED_PREF_KEY, 0).edit().putBoolean(Logger.SHARED_PREF_KEY_logPersistence_from_server, loggerJSONObject.getBoolean("capture")).commit();
                                }
                                if (loggerJSONObject.has(Logger.SHARED_PREF_KEY_level)) {
                                    context.getSharedPreferences(SHARED_PREF_KEY, 0).edit().putString(Logger.SHARED_PREF_KEY_level_from_server, loggerJSONObject.getString(Logger.SHARED_PREF_KEY_level)).commit();
                                }
                                if (loggerJSONObject.has(Logger.SHARED_PREF_KEY_filters)) {
                                    JSONObject filtersFromServer = loggerJSONObject.getJSONObject(Logger.SHARED_PREF_KEY_filters);
                                    context.getSharedPreferences(SHARED_PREF_KEY, 0).edit().putString(Logger.SHARED_PREF_KEY_filters_from_server, filtersFromServer == null ? "{}" : filtersFromServer.toString()).commit();
                                    break block28;
                                }
                                context.getSharedPreferences(SHARED_PREF_KEY, 0).edit().putString(Logger.SHARED_PREF_KEY_filters_from_server, "{}").commit();
                            }
                            catch (JSONException e) {
                                Logger.getInstance(LOG_TAG).error("Failed to parse response from server.  Payload: " + responseJSONObject.toString(), e);
                            }
                            break block28;
                        }
                        if (wlResponse.getStatus() == 204) {
                            Logger.getInstance(LOG_TAG).trace("Processing server reply 204 NO_CONTENT.  No matching client configuration profiles were found at the Worklight server, so removing any server-directed configuration overrides.");
                            SharedPreferences prefs = context.getSharedPreferences(SHARED_PREF_KEY, 0);
                            SharedPreferences.Editor editor = prefs.edit();
                            editor.remove(Logger.SHARED_PREF_KEY_logPersistence_from_server);
                            editor.remove(Logger.SHARED_PREF_KEY_level_from_server);
                            editor.remove(Logger.SHARED_PREF_KEY_filters_from_server);
                            editor.commit();
                            Logger.setLevel(LEVEL.fromString(prefs.getString(Logger.SHARED_PREF_KEY_level, Logger.getLevelDefault().toString())));
                            Logger.setCapture(prefs.getBoolean(Logger.SHARED_PREF_KEY_logPersistence, true));
                            try {
                                Logger.setFilters(Logger.JSONObjectToHashMap(new JSONObject(prefs.getString(Logger.SHARED_PREF_KEY_filters, "{}"))));
                            }
                            catch (JSONException e) {
                                // empty catch block
                            }
                        }
                    }
                    finally {
                        Object object = WAIT_LOCK;
                        synchronized (object) {
                            WAIT_LOCK.notifyAll();
                        }
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onFailure(WLFailResponse wlFailResponse) {
                Object object = WAIT_LOCK;
                synchronized (object) {
                    WAIT_LOCK.notifyAll();
                }
            }
        };
        WLRequestOptions requestOptions = new WLRequestOptions();
        String deviceid = "UNKNOWN";
        try {
            deviceid = WLDeviceAuthManager.getInstance().getDeviceUUID(context);
        }
        catch (Exception e) {
            Logger.getInstance(LOG_TAG).error("Could not get device id from WLDeviceAuthManager; using value '" + deviceid + "' instead.", e);
        }
        requestOptions.addHeader("x-wl-clientlog-deviceId", deviceid);
        requestOptions.addHeader("x-wl-clientlog-appname", WLConfig.getInstance().getAppId());
        requestOptions.addHeader("x-wl-clientlog-appversion", WLConfig.getInstance().getApplicationVersion());
        requestOptions.addHeader("x-wl-clientlog-osversion", Build.VERSION.RELEASE);
        requestOptions.addHeader("x-wl-clientlog-env", "Android");
        requestOptions.addHeader("x-wl-clientlog-model", Build.MODEL);
        WLRequest updateOptionsFromServerRequest = new WLRequest(requestListener, requestOptions, WLConfig.getInstance(), context);
        updateOptionsFromServerRequest.makeRequest("apps/services/configprofile", true);
    }

    @Deprecated
    public static synchronized void sendIfUnCaughtExceptionDetected(Context context) {
        boolean detected;
        Logger.setContext(context);
        boolean bl = detected = null == context ? false : context.getSharedPreferences(SHARED_PREF_KEY, 0).getBoolean(SHARED_PREF_KEY_CRASH_DETECTED, false);
        if (detected) {
            Logger.send();
        }
    }

    public static boolean isUnCaughtExceptionDetected() {
        if (context == null) {
            if (!context_null_msg_already_printed) {
                Log.w((String)LOG_TAG, (String)CONTEXT_NULL_MSG);
                context_null_msg_already_printed = true;
            }
            return false;
        }
        return context.getSharedPreferences(SHARED_PREF_KEY, 0).getBoolean(SHARED_PREF_KEY_CRASH_DETECTED, false);
    }

    public void analytics(String message, JSONObject additionalMetadata) {
        this.doLog(LEVEL.ANALYTICS, message, new Date().getTime(), additionalMetadata, null);
    }

    public void fatal(String message, JSONObject additionalMetadata, Throwable t) {
        this.doLog(LEVEL.FATAL, message, new Date().getTime(), additionalMetadata, t);
    }

    public void error(String message) {
        this.error(message, null, null);
    }

    public void error(String message, JSONObject additionalMetadata) {
        this.error(message, additionalMetadata, null);
    }

    public void error(String message, Throwable t) {
        this.error(message, null, t);
    }

    public void error(String message, JSONObject additionalMetadata, Throwable t) {
        this.doLog(LEVEL.ERROR, message, new Date().getTime(), additionalMetadata, t);
    }

    public void warn(String message) {
        this.warn(message, null, null);
    }

    public void warn(String message, JSONObject additionalMetadata) {
        this.warn(message, additionalMetadata, null);
    }

    public void warn(String message, Throwable t) {
        this.warn(message, null, t);
    }

    public void warn(String message, JSONObject additionalMetadata, Throwable t) {
        this.doLog(LEVEL.WARN, message, new Date().getTime(), additionalMetadata, t);
    }

    public void info(String message) {
        this.info(message, null);
    }

    public void info(String message, JSONObject additionalMetadata) {
        this.doLog(LEVEL.INFO, message, new Date().getTime(), additionalMetadata, null);
    }

    public void log(String message) {
        this.log(message, null);
    }

    public void log(String message, JSONObject additionalMetadata) {
        this.doLog(LEVEL.LOG, message, new Date().getTime(), additionalMetadata, null);
    }

    public void debug(String message) {
        this.debug(message, null, null);
    }

    public void debug(String message, JSONObject additionalMetadata) {
        this.debug(message, additionalMetadata, null);
    }

    public void debug(String message, Throwable t) {
        this.debug(message, null, t);
    }

    public void debug(String message, JSONObject additionalMetadata, Throwable t) {
        this.doLog(LEVEL.DEBUG, message, new Date().getTime(), additionalMetadata, t);
    }

    public void trace(String message) {
        this.trace(message, null);
    }

    public void trace(String message, JSONObject additionalMetadata) {
        this.doLog(LEVEL.TRACE, message, new Date().getTime(), additionalMetadata, null);
    }

    public void doLog(LEVEL calledLevel, String message, long timestamp, JSONObject additionalMetadata, Throwable t) {
        additionalMetadata = this.appendStackMetadata(additionalMetadata);
        ThreadPoolWorkQueue.execute(new DoLogRunnable(calledLevel, message, timestamp, additionalMetadata, t, this));
    }

    private static String prependMetadata(String message, JSONObject additionalMetadata) {
        try {
            if (null != additionalMetadata) {
                String clazz = "";
                String method = "";
                String file = "";
                String line = "";
                if (additionalMetadata.has("$class")) {
                    clazz = additionalMetadata.getString("$class");
                    clazz = clazz.substring(clazz.lastIndexOf(46) + 1, clazz.length());
                }
                if (additionalMetadata.has("$method")) {
                    method = additionalMetadata.getString("$method");
                }
                if (additionalMetadata.has("$file")) {
                    file = additionalMetadata.getString("$file");
                }
                if (additionalMetadata.has("$line")) {
                    line = additionalMetadata.getString("$line");
                }
                if (!(clazz + method + file + line).equals("")) {
                    message = clazz + "." + method + " in " + file + ":" + line + " :: " + message;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return message;
    }

    public static HashMap<String, LEVEL> JSONObjectToHashMap(JSONObject object) {
        HashMap<String, LEVEL> pairs = new HashMap<String, LEVEL>();
        Iterator it = object.keys();
        while (it.hasNext()) {
            String n = (String)it.next();
            try {
                pairs.put(n, LEVEL.valueOf(object.getString(n).toUpperCase()));
            }
            catch (JSONException e) {}
        }
        return pairs;
    }

    public static JSONObject HashMapToJSONObject(HashMap<String, LEVEL> pairs) {
        if (pairs == null) {
            return new JSONObject();
        }
        Set<String> set = pairs.keySet();
        JSONObject jsonObj = new JSONObject();
        for (String n : set) {
            try {
                jsonObj.put(n, (Object)pairs.get(n).toString());
            }
            catch (JSONException e) {}
        }
        return jsonObj;
    }

    public static LEVEL getLevelDefault() {
        if (context == null) {
            return LEVEL.DEBUG;
        }
        X500Principal DEBUG_DN = new X500Principal("CN=Android Debug,O=Android,C=US");
        PackageManager packageManager = context.getPackageManager();
        boolean debug = false;
        try {
            Signature raw = packageManager.getPackageInfo((String)Logger.context.getPackageName(), (int)64).signatures[0];
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            X509Certificate cert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(raw.toByteArray()));
            debug = cert.getSubjectX500Principal().equals(DEBUG_DN);
        }
        catch (Exception e) {
            debug = false;
        }
        return debug ? LEVEL.DEBUG : LEVEL.FATAL;
    }

    public static void processAutomaticTrigger() {
        Long now = new Date().getTime();
        if (now - priorAutoTriggerTime >= 60000L) {
            if (timer != null) {
                timer.cancel();
            }
            timer = new Timer("trigger timer");
            timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    if (autoUpdateConfig == null || autoUpdateConfig.booleanValue()) {
                        Logger.updateConfigFromServer();
                    }
                    if (autoSendLogs == null || autoSendLogs.booleanValue()) {
                        Logger.send();
                        Logger.sendAnalytics();
                    }
                }
            }, 50L);
            priorAutoTriggerTime = new Date().getTime();
        }
    }

    private JSONObject appendStackMetadata(JSONObject jsonMetadata) {
        try {
            if (null != jsonMetadata && jsonMetadata.has("$src")) {
                try {
                    String src = jsonMetadata.getString("$src");
                    if (null != src && src.equals("js")) {
                        return jsonMetadata;
                    }
                }
                catch (JSONException e) {
                    // empty catch block
                }
            }
            StackTraceElement[] stackTraceElements = new Exception().getStackTrace();
            int index = 0;
            while (!stackTraceElements[index].getClassName().equals(Logger.class.getName())) {
                ++index;
            }
            while (stackTraceElements[index].getClassName().equals(Logger.class.getName()) || stackTraceElements[index].getClassName().startsWith(JULHandler.class.getName()) || stackTraceElements[index].getClassName().startsWith(java.util.logging.Logger.class.getName()) || stackTraceElements[index].getClassName().startsWith(WLAnalytics.class.getName())) {
                ++index;
            }
            if (null == jsonMetadata) {
                jsonMetadata = new JSONObject();
            }
            if (!jsonMetadata.has("$class")) {
                jsonMetadata.put("$class", (Object)stackTraceElements[index].getClassName());
            }
            if (!jsonMetadata.has("$file")) {
                jsonMetadata.put("$file", (Object)stackTraceElements[index].getFileName());
            }
            if (!jsonMetadata.has("$method")) {
                jsonMetadata.put("$method", (Object)stackTraceElements[index].getMethodName());
            }
            if (!jsonMetadata.has("$line")) {
                jsonMetadata.put("$line", stackTraceElements[index].getLineNumber());
            }
            if (!jsonMetadata.has("$src")) {
                jsonMetadata.put("$src", (Object)"java");
            }
        }
        catch (Exception e) {
            Log.e((String)LOG_TAG, (String)"Could not generate jsonMetadata object.", (Throwable)e);
        }
        return jsonMetadata;
    }

    private static JSONObject createJSONObject(LEVEL level, String pkg, String message, long timestamp, JSONObject jsonMetadata, Throwable t) {
        JSONObject jsonObject = new JSONObject();
        SimpleDateFormat s = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss:S");
        String format = s.format(timestamp);
        try {
            jsonObject.put("timestamp", (Object)format);
            jsonObject.put(SHARED_PREF_KEY_level, (Object)level.toString());
            jsonObject.put("pkg", (Object)pkg);
            jsonObject.put("msg", (Object)message);
            jsonObject.put("threadid", Thread.currentThread().getId());
            if (null != jsonMetadata) {
                jsonObject.put("metadata", (Object)jsonMetadata);
            }
            if (null != t) {
                jsonObject.put("metadata", (Object)Logger.appendFullStackTrace(jsonMetadata, t));
            }
        }
        catch (JSONException e) {
            Log.e((String)LOG_TAG, (String)"Error adding JSONObject key/value pairs", (Throwable)e);
        }
        return jsonObject;
    }

    private static JSONObject appendFullStackTrace(JSONObject jsonMetadata, Throwable t) {
        JSONArray stackArray = new JSONArray();
        StackTraceElement[] stackTraceElements = t.getStackTrace();
        for (int i = 0; i < stackTraceElements.length; ++i) {
            stackArray.put((Object)stackTraceElements[i].toString());
        }
        try {
            if (null == jsonMetadata) {
                jsonMetadata = new JSONObject();
            }
            jsonMetadata.put("$stacktrace", (Object)stackArray);
            jsonMetadata.put("$exceptionMessage", (Object)t.getLocalizedMessage());
            jsonMetadata.put("$exceptionClass", (Object)t.getClass().getName());
        }
        catch (JSONException e) {
            // empty catch block
        }
        return jsonMetadata;
    }

    private static synchronized void captureToFile(JSONObject jsonObject, LEVEL calledLevel) {
        boolean cap = Logger.getCaptureSync();
        boolean analyticsCap = Logger.getAnalyticsCaptureSync();
        if (context == null) {
            if (!context_null_msg_already_printed) {
                Log.w((String)LOG_TAG, (String)CONTEXT_NULL_MSG);
                context_null_msg_already_printed = true;
            }
            return;
        }
        if (jsonObject.length() == 0) {
            return;
        }
        try {
            if (analyticsCap && calledLevel.equals((Object)LEVEL.ANALYTICS)) {
                fileLoggerInstance.log(jsonObject, ANALYTICS_FILENAME);
            } else if (cap) {
                fileLoggerInstance.log(jsonObject, FILENAME);
            }
        }
        catch (Exception e) {
            Log.e((String)LOG_TAG, (String)"An error occurred capturing data to file.", (Throwable)e);
        }
    }

    public static byte[] getByteArrayFromFile(File file) throws UnsupportedEncodingException {
        return fileLoggerInstance == null ? new byte[]{} : fileLoggerInstance.getFileContentsAsByteArray(file);
    }

    private static synchronized void sendFiles(String fileName) {
        if (context == null) {
            return;
        }
        for (int i = 1; i > -1; --i) {
            File file = new File(context.getFilesDir(), fileName + "." + i);
            if (file.length() <= 0L) continue;
            File fileToSend = new File(file + ".send");
            if (!fileToSend.exists()) {
                Logger.getInstance(LOG_TAG).trace("Moving " + file + " to " + fileToSend);
                file.renameTo(fileToSend);
            }
            SendLogsRequestListener requestListener = new SendLogsRequestListener(fileToSend);
            WLRequestOptions requestOptions = new WLRequestOptions();
            String deviceid = "UNKNOWN";
            try {
                deviceid = WLDeviceAuthManager.getInstance().getDeviceUUID(context);
            }
            catch (Exception e) {
                Logger.getInstance(LOG_TAG).error("Could not get device id from WLDeviceAuthManager.", e);
            }
            requestOptions.addHeader("x-wl-clientlog-deviceId", deviceid);
            requestOptions.addHeader("x-wl-clientlog-appname", WLConfig.getInstance().getAppId());
            requestOptions.addHeader("x-wl-clientlog-appversion", WLConfig.getInstance().getApplicationVersion());
            requestOptions.addHeader("x-wl-clientlog-osversion", Build.VERSION.RELEASE);
            requestOptions.addHeader("x-wl-clientlog-env", "Android");
            requestOptions.addHeader("x-wl-clientlog-model", Build.MODEL);
            try {
                byte[] payload = Logger.getByteArrayFromFile(fileToSend);
                if (payload.length == 0) {
                    return;
                }
                requestOptions.addParameter("__logdata", new String(payload, "UTF-8"));
                WLRequest sendLogsRequest = new WLRequest(requestListener, requestOptions, WLConfig.getInstance(), context);
                sendLogsRequest.makeRequest("apps/services/loguploader", true);
                continue;
            }
            catch (IOException e) {
                Logger.getInstance(LOG_TAG).error("Failed to send logs due to exception.", e);
            }
        }
    }

    static {
        capture = null;
        analyticsCapture = null;
        logFileMaxSize = null;
        level = null;
        julHandler = new JULHandler();
        filters = new HashMap();
        uncaughtExceptionHandler = null;
        instances = new WeakHashMap();
        ThreadPoolWorkQueue = new ThreadPoolExecutor(1, 1, 100L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(1000));
        ThreadPoolWorkQueue.setRejectedExecutionHandler(new RejectedExecutionHandler(){

            @Override
            public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
                try {
                    executor.getQueue().put(r);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        });
    }

    static class SendLogsRequestListener
    implements WLRequestListener {
        private static final Logger logger = Logger.getInstance(SendLogsRequestListener.class.getName());
        private final File file;

        public SendLogsRequestListener(File _file) {
            this.file = _file;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onSuccess(WLResponse wlResponse) {
            try {
                if (wlResponse.getStatus() == 201) {
                    logger.trace("Successfully POSTed log data from file " + this.file + " to URL " + "apps/services/loguploader" + ".  HTTP response code: " + wlResponse.getStatus());
                } else {
                    logger.error("Failed to POST data from file " + this.file + " due to: HTTP response code: " + wlResponse.getStatus());
                }
                this.file.delete();
                context.getSharedPreferences(SHARED_PREF_KEY, 0).edit().putBoolean(Logger.SHARED_PREF_KEY_CRASH_DETECTED, false).commit();
            }
            finally {
                Object object = WAIT_LOCK;
                synchronized (object) {
                    WAIT_LOCK.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onFailure(WLFailResponse wlFailResponse) {
            Object object = WAIT_LOCK;
            synchronized (object) {
                WAIT_LOCK.notifyAll();
            }
        }
    }

    private static class DoLogRunnable
    implements Runnable {
        private LEVEL calledLevel;
        private String message;
        private long timestamp;
        private JSONObject additionalMetadata;
        private Throwable t;
        private Logger logger;

        public DoLogRunnable(LEVEL _calledLevel, String _message, long _timestamp, JSONObject _additionalMetadata, Throwable _t, Logger _logger) {
            this.calledLevel = _calledLevel;
            this.message = _message;
            this.timestamp = _timestamp;
            this.additionalMetadata = _additionalMetadata;
            this.t = _t;
            this.logger = _logger;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean canLog = true;
            HashMap currentFilters = Logger.getFiltersSync();
            if (currentFilters != null && currentFilters.size() > 0) {
                canLog = currentFilters.containsKey(this.logger.tag) ? this.calledLevel.getLevelValue() <= ((LEVEL)((Object)currentFilters.get(this.logger.tag))).getLevelValue() : false;
            } else {
                boolean bl = canLog = this.calledLevel != null && this.calledLevel.isLoggable();
            }
            if (canLog || this.calledLevel == LEVEL.ANALYTICS) {
                Logger.captureToFile(Logger.createJSONObject(this.calledLevel, this.logger.tag, this.message, this.timestamp, this.additionalMetadata, this.t), this.calledLevel);
                this.message = null == this.message ? "(null)" : this.message;
                this.message = Logger.prependMetadata(this.message, this.additionalMetadata);
                switch (this.calledLevel) {
                    case FATAL: 
                    case ERROR: {
                        if (null == this.t) {
                            Log.e((String)this.logger.tag, (String)this.message);
                            break;
                        }
                        Log.e((String)this.logger.tag, (String)this.message, (Throwable)this.t);
                        break;
                    }
                    case WARN: {
                        if (null == this.t) {
                            Log.w((String)this.logger.tag, (String)this.message);
                            break;
                        }
                        Log.w((String)this.logger.tag, (String)this.message, (Throwable)this.t);
                        break;
                    }
                    case INFO: {
                        if (null == this.t) {
                            Log.i((String)this.logger.tag, (String)this.message);
                            break;
                        }
                        Log.i((String)this.logger.tag, (String)this.message, (Throwable)this.t);
                        break;
                    }
                    case LOG: {
                        if (null == this.t) {
                            Log.v((String)this.logger.tag, (String)this.message);
                            break;
                        }
                        Log.v((String)this.logger.tag, (String)this.message, (Throwable)this.t);
                        break;
                    }
                    case DEBUG: 
                    case TRACE: {
                        if (null == this.t) {
                            Log.d((String)this.logger.tag, (String)this.message);
                            break;
                        }
                        Log.d((String)this.logger.tag, (String)this.message, (Throwable)this.t);
                        break;
                    }
                }
            }
            Logger logger = this.logger;
            synchronized (logger) {
                this.logger.notifyAll();
            }
        }
    }

    private static class UncaughtExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        private final Thread.UncaughtExceptionHandler defaultUEH = Thread.getDefaultUncaughtExceptionHandler();

        private UncaughtExceptionHandler() {
        }

        @Override
        public final void uncaughtException(Thread t, Throwable e) {
            if (null != context) {
                context.getSharedPreferences(SHARED_PREF_KEY, 0).edit().putBoolean(Logger.SHARED_PREF_KEY_CRASH_DETECTED, true).commit();
            }
            Logger logger = Logger.getInstance(this.getClass().getName());
            logger.fatal("Uncaught Exception", new JSONObject(), e);
            this.defaultUEH.uncaughtException(t, e);
        }
    }

    private static class FileLogger
    extends FileLoggerInterface {
        private static FileLogger singleton;
        private static FileLogger noopSingleton;
        private static String filePath;
        private static ClientLogFormatter formatter;

        private FileLogger(String name, String resourceBundleName) {
            super(name, resourceBundleName);
        }

        public static FileLogger getInstance() {
            if (null != singleton || context == null) {
                return noopSingleton;
            }
            singleton = new FileLogger(null, null);
            filePath = context.getFilesDir() + System.getProperty("file.separator") + Logger.FILENAME;
            formatter = new ClientLogFormatter();
            singleton.setLevel(Level.ALL);
            return singleton;
        }

        @Override
        public synchronized void log(JSONObject logData, String fileName) throws SecurityException, IOException {
            if (null != singleton) {
                filePath = context.getFilesDir() + System.getProperty("file.separator") + fileName;
                FileHandler handler = null;
                handler = new FileHandler(filePath, Logger.getMaxFileSize(), 2, true);
                handler.setFormatter(formatter);
                singleton.addHandler(handler);
                singleton.log(Level.FINEST, logData.toString() + ",");
                singleton.getHandlers()[0].close();
                singleton.removeHandler(handler);
            }
        }

        @Override
        public byte[] getFileContentsAsByteArray(File file) throws UnsupportedEncodingException {
            return this.getByteArrayFromFile(file.getName());
        }

        private byte[] getByteArrayFromFile(String file) throws UnsupportedEncodingException {
            String ret = "";
            File fl = new File(context.getFilesDir(), file);
            if (fl.exists()) {
                try {
                    FileInputStream fin = new FileInputStream(fl);
                    ByteArrayOutputStream baos = new ByteArrayOutputStream((int)fl.length());
                    FileLogger.copyStream(fin, baos);
                    return baos.toByteArray();
                }
                catch (IOException e) {
                    Log.e((String)LOG_TAG, (String)("problem reading file " + fl.toString()), (Throwable)e);
                }
            }
            return ret.getBytes("UTF-8");
        }

        private static void copyStream(InputStream is, OutputStream os) throws IOException {
            int count;
            int buffer_size = 1024;
            byte[] bytes = new byte[1024];
            while ((count = is.read(bytes, 0, 1024)) != -1) {
                os.write(bytes, 0, count);
            }
            is.close();
        }

        static {
            noopSingleton = new FileLogger(null, null);
        }

        private static class ClientLogFormatter
        extends Formatter {
            private ClientLogFormatter() {
            }

            @Override
            public String format(LogRecord logRecord) {
                return logRecord.getMessage();
            }
        }
    }

    protected static abstract class FileLoggerInterface
    extends java.util.logging.Logger {
        protected FileLoggerInterface(String name, String resourceBundleName) {
            super(name, resourceBundleName);
        }

        public abstract void log(JSONObject var1, String var2) throws SecurityException, IOException;

        public abstract byte[] getFileContentsAsByteArray(File var1) throws UnsupportedEncodingException;
    }

    public static enum LEVEL {
        ANALYTICS{

            @Override
            protected int getLevelValue() {
                return 25;
            }
        }
        ,
        FATAL{

            @Override
            protected int getLevelValue() {
                return 50;
            }
        }
        ,
        ERROR{

            @Override
            protected int getLevelValue() {
                return 100;
            }
        }
        ,
        WARN{

            @Override
            protected int getLevelValue() {
                return 200;
            }
        }
        ,
        INFO{

            @Override
            protected int getLevelValue() {
                return 300;
            }
        }
        ,
        LOG{

            @Override
            protected int getLevelValue() {
                return 400;
            }
        }
        ,
        DEBUG{

            @Override
            protected int getLevelValue() {
                return 500;
            }
        }
        ,
        TRACE{

            @Override
            protected int getLevelValue() {
                return 600;
            }
        };


        protected abstract int getLevelValue();

        protected boolean isLoggable() {
            LEVEL currentLevel = Logger.getLevelSync();
            return null != currentLevel && currentLevel.getLevelValue() >= this.getLevelValue();
        }

        public static LEVEL fromString(String level) {
            try {
                return LEVEL.valueOf(level.toUpperCase());
            }
            catch (Exception e) {
                return null;
            }
        }
    }
}

