/*
 * Decompiled with CFR 0.152.
 */
package com.worklight.androidgap.jsonstore.security;

import android.os.Build;
import com.worklight.androidgap.jsonstore.security.FipsWrapper;
import com.worklight.nativeandroid.common.WLUtils;
import java.security.SecureRandom;
import javax.crypto.BadPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;

public class SecurityUtils {
    private static final int BYTES_TO_BITS = 8;
    private static final int KEY_SIZE_AES256 = 32;
    protected static final int PBKDF2_ITERATIONS = 10000;

    private SecurityUtils() {
    }

    public static byte[] decode(String key, String value, String iv) throws Exception {
        String decryptedString = FipsWrapper.decryptAES(key, iv, WLUtils.hexStringToByteArray(value));
        if (decryptedString == null || decryptedString.length() == 0) {
            throw new BadPaddingException("Decryption failed");
        }
        return decryptedString.getBytes();
    }

    public static String encodeBytesAsHexString(byte[] bytes) {
        StringBuilder result = new StringBuilder();
        if (bytes != null) {
            for (byte curByte : bytes) {
                result.append(String.format("%02X", curByte));
            }
        }
        return result.toString();
    }

    public static String encodeKeyAsHexString(SecretKey key) {
        return SecurityUtils.encodeBytesAsHexString(key.getEncoded());
    }

    public static byte[] encrypt(String key, String value, String iv) throws Exception {
        byte[] encryptedBytes = FipsWrapper.encryptAES(key, iv, value);
        return encryptedBytes;
    }

    public static byte[] generateIV(int numBytes) {
        byte[] iv = new byte[numBytes];
        new SecureRandom().nextBytes(iv);
        return iv;
    }

    public static SecretKey generateKey(String password, String salt) throws Exception {
        return SecurityUtils.generateKey(password, salt, 10000, 32);
    }

    public static SecretKey generateKey(String password, String salt, int iterations, int keyLength) throws Exception {
        SecretKeyFactory pbkdf2Factory = Build.VERSION.SDK_INT >= 19 ? SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1And8bit") : SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
        PBEKeySpec keySpec = new PBEKeySpec(password.toCharArray(), salt.getBytes("UTF-8"), iterations, keyLength * 8);
        return pbkdf2Factory.generateSecret(keySpec);
    }

    public static byte[] generateLocalKey(int numBytes) {
        byte[] randBytes = new byte[numBytes];
        new SecureRandom().nextBytes(randBytes);
        return randBytes;
    }
}

