/*
 * Decompiled with CFR 0.152.
 */
package com.worklight.androidgap.jsonstore.security;

import android.content.Context;
import android.util.Base64;
import com.worklight.androidgap.jsonstore.security.DPKBean;
import com.worklight.androidgap.jsonstore.security.Keychain;
import com.worklight.androidgap.jsonstore.security.SecurityUtils;

public class SecurityManager {
    private static final int IV_NUM_BYTES = 16;
    private static final int LOCAL_KEY_NUM_BYTES = 32;
    private static SecurityManager instance;
    private Keychain keychain;

    private SecurityManager(Context context) {
        this.keychain = new Keychain(context);
    }

    public static synchronized SecurityManager getInstance(Context context) {
        if (instance == null) {
            instance = new SecurityManager(context);
        }
        return instance;
    }

    public String getDPK(String password, String username) throws Exception {
        DPKBean dpkBean = this.keychain.getDPKBean(username);
        String pwKey = SecurityUtils.encodeKeyAsHexString(SecurityUtils.generateKey(password, dpkBean.getSalt()));
        String decodedDPK = new String(Base64.decode((String)dpkBean.getEncryptedDPK(), (int)0));
        return new String(SecurityUtils.decode(pwKey, decodedDPK, dpkBean.getIV()));
    }

    public String getSalt(String username) throws Exception {
        DPKBean dpkBean = this.keychain.getDPKBean(username);
        if (dpkBean == null) {
            return null;
        }
        return dpkBean.getSalt();
    }

    public boolean isDPKAvailable(String username) {
        return this.keychain.isDPKAvailable(username);
    }

    public void destroyKeychain() {
        this.keychain.destroy();
    }

    public boolean storeDPK(String password, String username, String clearDPK, String salt, boolean isUpdate) throws Exception {
        String dpk = clearDPK;
        if (clearDPK == null || clearDPK.equals("")) {
            dpk = SecurityUtils.encodeBytesAsHexString(SecurityUtils.generateLocalKey(32));
        } else if (!isUpdate) {
            dpk = SecurityUtils.encodeKeyAsHexString(SecurityUtils.generateKey(clearDPK, salt));
        }
        String iv = SecurityUtils.encodeBytesAsHexString(SecurityUtils.generateIV(16));
        String pwKey = SecurityUtils.encodeKeyAsHexString(SecurityUtils.generateKey(password, salt));
        String encryptedDPK = Base64.encodeToString((byte[])SecurityUtils.encodeBytesAsHexString(SecurityUtils.encrypt(pwKey, dpk, iv)).getBytes(), (int)0);
        DPKBean dpkBean = new DPKBean(encryptedDPK, iv, salt, 10000);
        this.keychain.setDPKBean(username, dpkBean);
        return false;
    }
}

