/*
 * Decompiled with CFR 0.152.
 */
package com.worklight.androidgap.jsonstore.security;

import android.content.Context;
import android.content.SharedPreferences;
import com.worklight.androidgap.jsonstore.security.DPKBean;
import org.json.JSONException;

public class Keychain {
    private static final String PREF_NAME_DPK = "dpk";
    private static final String PREFS_NAME_DPK = "dpkPrefs";
    private SharedPreferences prefs;

    protected Keychain(Context context) {
        this.prefs = context.getSharedPreferences(PREFS_NAME_DPK, 0);
    }

    public DPKBean getDPKBean(String username) throws JSONException {
        String dpkJSON = this.prefs.getString(this.buildTag(username), null);
        if (dpkJSON == null) {
            return null;
        }
        return new DPKBean(dpkJSON);
    }

    public boolean isDPKAvailable(String username) {
        return this.prefs.getString(this.buildTag(username), null) != null;
    }

    public void setDPKBean(String username, DPKBean dpkBean) {
        SharedPreferences.Editor editor = this.prefs.edit();
        editor.putString(this.buildTag(username), dpkBean.toString());
        editor.commit();
    }

    public void destroy() {
        SharedPreferences.Editor editor = this.prefs.edit();
        editor.clear();
        editor.commit();
    }

    private String buildTag(String tag) {
        if (tag.equals("jsonstore")) {
            return PREF_NAME_DPK;
        }
        return "dpk-" + tag;
    }
}

