/*
 * Decompiled with CFR 0.152.
 */
package com.worklight.androidgap.jsonstore.security;

import com.worklight.nativeandroid.common.WLUtils;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.Arrays;

public class FipsWrapper {
    private static native int _enableFips();

    private static native int _disableFips();

    private static native int _setFips(int var0);

    private static native int _getFipsMode();

    private static native byte[] _encryptAES(byte[] var0, int var1, byte[] var2, int var3, String var4, int var5);

    private static native byte[] _decryptAES(byte[] var0, int var1, byte[] var2, int var3, byte[] var4, int var5);

    public static int enableFips() {
        return FipsWrapper._enableFips();
    }

    public static int disableFips() {
        return FipsWrapper._disableFips();
    }

    public static int setFips(int mode) {
        return FipsWrapper._setFips(mode);
    }

    public static int getFipsMode() {
        return FipsWrapper._getFipsMode();
    }

    public static byte[] encryptAES(String key, String iv, String clearText) {
        byte[] keyByteArray = WLUtils.hexStringToByteArray(key);
        byte[] ivByteArray = WLUtils.hexStringToByteArray(iv);
        byte[] encBytes = FipsWrapper._encryptAES(keyByteArray, keyByteArray.length, ivByteArray, ivByteArray.length, clearText, clearText.length());
        return encBytes;
    }

    public static String decryptAES(String key, String iv, byte[] encryptedBytes) {
        String decryptedText;
        byte[] keyByteArray = WLUtils.hexStringToByteArray(key);
        byte[] ivByteArray = WLUtils.hexStringToByteArray(iv);
        byte[] decryptedBytes = FipsWrapper._decryptAES(keyByteArray, keyByteArray.length, ivByteArray, ivByteArray.length, encryptedBytes, encryptedBytes.length);
        try {
            CharsetDecoder charsetDecoder = Charset.forName("UTF-8").newDecoder();
            CharBuffer charBuffer = charsetDecoder.decode(ByteBuffer.wrap(decryptedBytes));
            decryptedText = new String(decryptedBytes, "UTF-8");
        }
        catch (Throwable t) {
            decryptedText = null;
        }
        Arrays.fill(decryptedBytes, (byte)0);
        return decryptedText;
    }

    static {
        System.loadLibrary("openssl_fips");
    }
}

