/*
 * Decompiled with CFR 0.152.
 */
package com.worklight.androidgap.jsonstore.security;

import com.worklight.jsonstore.jackson.JacksonSerializedJSONObject;
import com.worklight.jsonstore.jackson.JsonOrgModule;
import org.json.JSONException;
import org.json.JSONObject;

public class DPKBean {
    private static final String KEY_DPK = "dpk";
    private static final String KEY_ITERATIONS = "iterations";
    private static final String KEY_IV = "iv";
    private static final String KEY_SALT = "jsonSalt";
    private static final String KEY_VERSION = "version";
    private static final String VERSION_NUM = "1.0";
    private JSONObject obj;

    protected DPKBean(String json) throws JSONException {
        try {
            this.obj = JsonOrgModule.deserializeJSONObject(json);
        }
        catch (Throwable e) {
            throw new JSONException(e);
        }
    }

    protected DPKBean(String encryptedDPK, String iv, String salt, int iterations) throws JSONException {
        this.obj = new JacksonSerializedJSONObject();
        this.obj.put(KEY_DPK, (Object)encryptedDPK);
        this.obj.put(KEY_ITERATIONS, iterations);
        this.obj.put(KEY_IV, (Object)iv);
        this.obj.put(KEY_SALT, (Object)salt);
        this.obj.put(KEY_VERSION, (Object)VERSION_NUM);
    }

    public String getEncryptedDPK() throws JSONException {
        return this.obj.getString(KEY_DPK);
    }

    public int getIterations() throws JSONException {
        return this.obj.getInt(KEY_ITERATIONS);
    }

    public String getIV() throws JSONException {
        return this.obj.getString(KEY_IV);
    }

    public String getSalt() throws JSONException {
        return this.obj.getString(KEY_SALT);
    }

    public String getVersion() throws JSONException {
        return this.obj.getString(KEY_VERSION);
    }

    public String toString() {
        return this.obj.toString();
    }
}

