/*
 * Decompiled with CFR 0.152.
 */
package com.loopj.android.http;

import android.content.Context;
import android.os.Message;
import com.loopj.android.http.AsyncHttpClient;
import com.loopj.android.http.AsyncHttpRequest;
import com.loopj.android.http.AsyncHttpResponseHandler;
import com.loopj.android.http.RequestParams;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.AbstractHttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.protocol.HttpContext;

public abstract class SyncHttpClient
extends AsyncHttpClient {
    private int responseCode;
    private String result;
    AsyncHttpResponseHandler responseHandler = new AsyncHttpResponseHandler(){

        @Override
        void sendResponseMessage(HttpResponse httpResponse) {
            SyncHttpClient.this.responseCode = httpResponse.getStatusLine().getStatusCode();
            super.sendResponseMessage(httpResponse);
        }

        @Override
        protected void sendMessage(Message message) {
            this.handleMessage(message);
        }

        @Override
        public void onSuccess(String string) {
            SyncHttpClient.this.result = string;
        }

        @Override
        public void onFailure(Throwable throwable, String string) {
            SyncHttpClient.this.result = SyncHttpClient.this.onRequestFailed(throwable, string);
        }
    };

    public int getResponseCode() {
        return this.responseCode;
    }

    @Override
    protected void sendRequest(DefaultHttpClient defaultHttpClient, HttpContext httpContext, HttpUriRequest httpUriRequest, String string, AsyncHttpResponseHandler asyncHttpResponseHandler, Context context) {
        if (string != null) {
            httpUriRequest.addHeader("Content-Type", string);
        }
        new AsyncHttpRequest((AbstractHttpClient)defaultHttpClient, httpContext, httpUriRequest, asyncHttpResponseHandler).run();
    }

    public abstract String onRequestFailed(Throwable var1, String var2);

    public void delete(String string, RequestParams requestParams, AsyncHttpResponseHandler asyncHttpResponseHandler) {
        this.delete(string, asyncHttpResponseHandler);
    }

    public String get(String string, RequestParams requestParams) {
        this.get(string, requestParams, this.responseHandler);
        return this.result;
    }

    public String get(String string) {
        this.get(string, null, this.responseHandler);
        return this.result;
    }

    public String put(String string, RequestParams requestParams) {
        this.put(string, requestParams, this.responseHandler);
        return this.result;
    }

    public String put(String string) {
        this.put(string, null, this.responseHandler);
        return this.result;
    }

    public String post(String string, RequestParams requestParams) {
        this.post(string, requestParams, this.responseHandler);
        return this.result;
    }

    public String post(String string) {
        this.post(string, null, this.responseHandler);
        return this.result;
    }

    public String delete(String string, RequestParams requestParams) {
        this.delete(string, requestParams, this.responseHandler);
        return this.result;
    }

    public String delete(String string) {
        this.delete(string, null, this.responseHandler);
        return this.result;
    }
}

