/*
 * Decompiled with CFR 0.152.
 */
package com.loopj.android.http;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Random;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.message.BasicHeader;

class SimpleMultipartEntity
implements HttpEntity {
    private static final char[] MULTIPART_CHARS = "-_1234567890abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
    private String boundary = null;
    ByteArrayOutputStream out = new ByteArrayOutputStream();
    boolean isSetLast = false;
    boolean isSetFirst = false;

    public SimpleMultipartEntity() {
        StringBuffer stringBuffer = new StringBuffer();
        Random random = new Random();
        for (int i = 0; i < 30; ++i) {
            stringBuffer.append(MULTIPART_CHARS[random.nextInt(MULTIPART_CHARS.length)]);
        }
        this.boundary = stringBuffer.toString();
    }

    public void writeFirstBoundaryIfNeeds() {
        if (!this.isSetFirst) {
            try {
                this.out.write(("--" + this.boundary + "\r\n").getBytes());
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        this.isSetFirst = true;
    }

    public void writeLastBoundaryIfNeeds() {
        if (this.isSetLast) {
            return;
        }
        try {
            this.out.write(("\r\n--" + this.boundary + "--\r\n").getBytes());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.isSetLast = true;
    }

    public void addPart(String string, String string2) {
        this.writeFirstBoundaryIfNeeds();
        try {
            this.out.write(("Content-Disposition: form-data; name=\"" + string + "\"\r\n\r\n").getBytes());
            this.out.write(string2.getBytes());
            this.out.write(("\r\n--" + this.boundary + "\r\n").getBytes());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void addPart(String string, String string2, InputStream inputStream, boolean bl) {
        this.addPart(string, string2, inputStream, "application/octet-stream", bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPart(String string, String string2, InputStream inputStream, String string3, boolean bl) {
        this.writeFirstBoundaryIfNeeds();
        try {
            string3 = "Content-Type: " + string3 + "\r\n";
            this.out.write(("Content-Disposition: form-data; name=\"" + string + "\"; filename=\"" + string2 + "\"\r\n").getBytes());
            this.out.write(string3.getBytes());
            this.out.write("Content-Transfer-Encoding: binary\r\n\r\n".getBytes());
            byte[] byArray = new byte[4096];
            int n = 0;
            while ((n = inputStream.read(byArray)) != -1) {
                this.out.write(byArray, 0, n);
            }
            if (!bl) {
                this.out.write(("\r\n--" + this.boundary + "\r\n").getBytes());
            }
            this.out.flush();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public void addPart(String string, File file, boolean bl) {
        try {
            this.addPart(string, file.getName(), new FileInputStream(file), bl);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
    }

    public long getContentLength() {
        this.writeLastBoundaryIfNeeds();
        return this.out.toByteArray().length;
    }

    public Header getContentType() {
        return new BasicHeader("Content-Type", "multipart/form-data; boundary=" + this.boundary);
    }

    public boolean isChunked() {
        return false;
    }

    public boolean isRepeatable() {
        return false;
    }

    public boolean isStreaming() {
        return false;
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        outputStream.write(this.out.toByteArray());
    }

    public Header getContentEncoding() {
        return null;
    }

    public void consumeContent() throws IOException, UnsupportedOperationException {
        if (this.isStreaming()) {
            throw new UnsupportedOperationException("Streaming entity does not implement #consumeContent()");
        }
    }

    public InputStream getContent() throws IOException, UnsupportedOperationException {
        return new ByteArrayInputStream(this.out.toByteArray());
    }
}

