/*
 * Decompiled with CFR 0.152.
 */
package com.loopj.android.http;

import com.loopj.android.http.SimpleMultipartEntity;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.message.BasicNameValuePair;

public class RequestParams {
    private static String ENCODING = "UTF-8";
    protected ConcurrentHashMap<String, String> urlParams;
    protected ConcurrentHashMap<String, FileWrapper> fileParams;
    protected ConcurrentHashMap<String, ArrayList<String>> urlParamsWithArray;

    public RequestParams() {
        this.init();
    }

    public RequestParams(Map<String, String> map) {
        this.init();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public RequestParams(String string, String string2) {
        this.init();
        this.put(string, string2);
    }

    public RequestParams(Object ... objectArray) {
        this.init();
        int n = objectArray.length;
        if (n % 2 != 0) {
            throw new IllegalArgumentException("Supplied arguments must be even");
        }
        for (int i = 0; i < n; i += 2) {
            String string = String.valueOf(objectArray[i]);
            String string2 = String.valueOf(objectArray[i + 1]);
            this.put(string, string2);
        }
    }

    public void put(String string, String string2) {
        if (string != null && string2 != null) {
            this.urlParams.put(string, string2);
        }
    }

    public void put(String string, File file) throws FileNotFoundException {
        this.put(string, new FileInputStream(file), file.getName());
    }

    public void put(String string, ArrayList<String> arrayList) {
        if (string != null && arrayList != null) {
            this.urlParamsWithArray.put(string, arrayList);
        }
    }

    public void put(String string, InputStream inputStream) {
        this.put(string, inputStream, null);
    }

    public void put(String string, InputStream inputStream, String string2) {
        this.put(string, inputStream, string2, null);
    }

    public void put(String string, InputStream inputStream, String string2, String string3) {
        if (string != null && inputStream != null) {
            this.fileParams.put(string, new FileWrapper(inputStream, string2, string3));
        }
    }

    public void remove(String string) {
        this.urlParams.remove(string);
        this.fileParams.remove(string);
        this.urlParamsWithArray.remove(string);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<String, String> entry : this.urlParams.entrySet()) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append("&");
            }
            stringBuilder.append(entry.getKey());
            stringBuilder.append("=");
            stringBuilder.append(entry.getValue());
        }
        for (Map.Entry<String, Object> entry : this.fileParams.entrySet()) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append("&");
            }
            stringBuilder.append(entry.getKey());
            stringBuilder.append("=");
            stringBuilder.append("FILE");
        }
        for (Map.Entry<String, Object> entry : this.urlParamsWithArray.entrySet()) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append("&");
            }
            ArrayList arrayList = (ArrayList)entry.getValue();
            for (String string : arrayList) {
                if (arrayList.indexOf(string) != 0) {
                    stringBuilder.append("&");
                }
                stringBuilder.append(entry.getKey());
                stringBuilder.append("=");
                stringBuilder.append(string);
            }
        }
        return stringBuilder.toString();
    }

    public HttpEntity getEntity() {
        Object object = null;
        if (!this.fileParams.isEmpty()) {
            Object object2;
            SimpleMultipartEntity simpleMultipartEntity = new SimpleMultipartEntity();
            for (Map.Entry<String, String> entry : this.urlParams.entrySet()) {
                simpleMultipartEntity.addPart(entry.getKey(), entry.getValue());
            }
            int n = 0;
            int n2 = this.fileParams.entrySet().size() - 1;
            for (Map.Entry<String, FileWrapper> entry : this.fileParams.entrySet()) {
                object2 = entry.getValue();
                if (((FileWrapper)object2).inputStream != null) {
                    boolean bl;
                    boolean bl2 = bl = n == n2;
                    if (((FileWrapper)object2).contentType != null) {
                        simpleMultipartEntity.addPart(entry.getKey(), ((FileWrapper)object2).getFileName(), ((FileWrapper)object2).inputStream, ((FileWrapper)object2).contentType, bl);
                    } else {
                        simpleMultipartEntity.addPart(entry.getKey(), ((FileWrapper)object2).getFileName(), ((FileWrapper)object2).inputStream, bl);
                    }
                }
                ++n;
            }
            for (Map.Entry<String, Object> entry : this.urlParamsWithArray.entrySet()) {
                object2 = (ArrayList)entry.getValue();
                Iterator iterator = ((ArrayList)object2).iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    simpleMultipartEntity.addPart(entry.getKey(), string);
                }
            }
            object = simpleMultipartEntity;
        } else {
            try {
                object = new UrlEncodedFormEntity(this.getParamsList(), ENCODING);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
            }
        }
        return object;
    }

    private void init() {
        this.urlParams = new ConcurrentHashMap();
        this.fileParams = new ConcurrentHashMap();
        this.urlParamsWithArray = new ConcurrentHashMap();
    }

    protected List<BasicNameValuePair> getParamsList() {
        LinkedList<BasicNameValuePair> linkedList = new LinkedList<BasicNameValuePair>();
        for (Map.Entry<String, String> entry : this.urlParams.entrySet()) {
            linkedList.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
        }
        for (Map.Entry<String, Object> entry : this.urlParamsWithArray.entrySet()) {
            ArrayList arrayList = (ArrayList)entry.getValue();
            for (String string : arrayList) {
                linkedList.add(new BasicNameValuePair(entry.getKey(), string));
            }
        }
        return linkedList;
    }

    protected String getParamString() {
        return URLEncodedUtils.format(this.getParamsList(), (String)ENCODING);
    }

    private static class FileWrapper {
        public InputStream inputStream;
        public String fileName;
        public String contentType;

        public FileWrapper(InputStream inputStream, String string, String string2) {
            this.inputStream = inputStream;
            this.fileName = string;
            this.contentType = string2;
        }

        public String getFileName() {
            if (this.fileName != null) {
                return this.fileName;
            }
            return "nofilename";
        }
    }
}

