/*
 * Decompiled with CFR 0.152.
 */
package com.loopj.android.http;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import com.loopj.android.http.SerializableCookie;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.http.client.CookieStore;
import org.apache.http.cookie.Cookie;

public class PersistentCookieStore
implements CookieStore {
    private static final String COOKIE_PREFS = "CookiePrefsFile";
    private static final String COOKIE_NAME_STORE = "names";
    private static final String COOKIE_NAME_PREFIX = "cookie_";
    private final ConcurrentHashMap<String, Cookie> cookies;
    private final SharedPreferences cookiePrefs;

    public PersistentCookieStore(Context context) {
        this.cookiePrefs = context.getSharedPreferences(COOKIE_PREFS, 0);
        this.cookies = new ConcurrentHashMap();
        String string = this.cookiePrefs.getString(COOKIE_NAME_STORE, null);
        if (string != null) {
            String[] stringArray;
            for (String string2 : stringArray = TextUtils.split((String)string, (String)",")) {
                Cookie cookie;
                String string3 = this.cookiePrefs.getString(COOKIE_NAME_PREFIX + string2, null);
                if (string3 == null || (cookie = this.decodeCookie(string3)) == null) continue;
                this.cookies.put(string2, cookie);
            }
            this.clearExpired(new Date());
        }
    }

    public void addCookie(Cookie cookie) {
        String string = cookie.getName();
        if (!cookie.isExpired(new Date())) {
            this.cookies.put(string, cookie);
        } else {
            this.cookies.remove(string);
        }
        SharedPreferences.Editor editor = this.cookiePrefs.edit();
        editor.putString(COOKIE_NAME_STORE, TextUtils.join((CharSequence)",", (Iterable)this.cookies.keySet()));
        editor.putString(COOKIE_NAME_PREFIX + string, this.encodeCookie(new SerializableCookie(cookie)));
        editor.commit();
    }

    public void clear() {
        this.cookies.clear();
        SharedPreferences.Editor editor = this.cookiePrefs.edit();
        for (String string : this.cookies.keySet()) {
            editor.remove(COOKIE_NAME_PREFIX + string);
        }
        editor.remove(COOKIE_NAME_STORE);
        editor.commit();
    }

    public boolean clearExpired(Date date) {
        boolean bl = false;
        SharedPreferences.Editor editor = this.cookiePrefs.edit();
        for (Map.Entry<String, Cookie> entry : this.cookies.entrySet()) {
            String string = entry.getKey();
            Cookie cookie = entry.getValue();
            if (!cookie.isExpired(date)) continue;
            this.cookies.remove(string);
            editor.remove(COOKIE_NAME_PREFIX + string);
            bl = true;
        }
        if (bl) {
            editor.putString(COOKIE_NAME_STORE, TextUtils.join((CharSequence)",", (Iterable)this.cookies.keySet()));
        }
        editor.commit();
        return bl;
    }

    public List<Cookie> getCookies() {
        return new ArrayList<Cookie>(this.cookies.values());
    }

    protected String encodeCookie(SerializableCookie serializableCookie) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(serializableCookie);
        }
        catch (Exception exception) {
            return null;
        }
        return this.byteArrayToHexString(byteArrayOutputStream.toByteArray());
    }

    protected Cookie decodeCookie(String string) {
        byte[] byArray = this.hexStringToByteArray(string);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        Cookie cookie = null;
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            cookie = ((SerializableCookie)objectInputStream.readObject()).getCookie();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return cookie;
    }

    protected String byteArrayToHexString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 2);
        for (byte by : byArray) {
            int n = by & 0xFF;
            if (n < 16) {
                stringBuffer.append('0');
            }
            stringBuffer.append(Integer.toHexString(n));
        }
        return stringBuffer.toString().toUpperCase();
    }

    protected byte[] hexStringToByteArray(String string) {
        int n = string.length();
        byte[] byArray = new byte[n / 2];
        for (int i = 0; i < n; i += 2) {
            byArray[i / 2] = (byte)((Character.digit(string.charAt(i), 16) << 4) + Character.digit(string.charAt(i + 1), 16));
        }
        return byArray;
    }
}

