/*
 * Decompiled with CFR 0.152.
 */
package com.loopj.android.http;

import android.os.Message;
import com.loopj.android.http.AsyncHttpResponseHandler;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class JsonHttpResponseHandler
extends AsyncHttpResponseHandler {
    protected static final int SUCCESS_JSON_MESSAGE = 100;

    public void onSuccess(JSONObject jSONObject) {
    }

    public void onSuccess(JSONArray jSONArray) {
    }

    public void onSuccess(int n, JSONObject jSONObject) {
        this.onSuccess(jSONObject);
    }

    public void onSuccess(int n, JSONArray jSONArray) {
        this.onSuccess(jSONArray);
    }

    public void onFailure(Throwable throwable, JSONObject jSONObject) {
    }

    public void onFailure(Throwable throwable, JSONArray jSONArray) {
    }

    @Override
    protected void sendSuccessMessage(int n, String string) {
        if (n != 204) {
            try {
                Object object = this.parseResponse(string);
                this.sendMessage(this.obtainMessage(100, new Object[]{n, object}));
            }
            catch (JSONException jSONException) {
                this.sendFailureMessage((Throwable)jSONException, string);
            }
        } else {
            this.sendMessage(this.obtainMessage(100, new Object[]{n, new JSONObject()}));
        }
    }

    @Override
    protected void handleMessage(Message message) {
        switch (message.what) {
            case 100: {
                Object[] objectArray = (Object[])message.obj;
                this.handleSuccessJsonMessage((Integer)objectArray[0], objectArray[1]);
                break;
            }
            default: {
                super.handleMessage(message);
            }
        }
    }

    protected void handleSuccessJsonMessage(int n, Object object) {
        if (object instanceof JSONObject) {
            this.onSuccess(n, (JSONObject)object);
        } else if (object instanceof JSONArray) {
            this.onSuccess(n, (JSONArray)object);
        } else {
            this.onFailure((Throwable)new JSONException("Unexpected type " + object.getClass().getName()), (JSONObject)null);
        }
    }

    protected Object parseResponse(String string) throws JSONException {
        Object object = null;
        if ((string = string.trim()).startsWith("{") || string.startsWith("[")) {
            object = new JSONTokener(string).nextValue();
        }
        if (object == null) {
            object = string;
        }
        return object;
    }

    @Override
    protected void handleFailureMessage(Throwable throwable, String string) {
        try {
            if (string != null) {
                Object object = this.parseResponse(string);
                if (object instanceof JSONObject) {
                    this.onFailure(throwable, (JSONObject)object);
                } else if (object instanceof JSONArray) {
                    this.onFailure(throwable, (JSONArray)object);
                } else {
                    this.onFailure(throwable, string);
                }
            } else {
                this.onFailure(throwable, "");
            }
        }
        catch (JSONException jSONException) {
            this.onFailure(throwable, string);
        }
    }
}

