/*
 * Decompiled with CFR 0.152.
 */
package com.loopj.android.http;

import android.os.Message;
import com.loopj.android.http.AsyncHttpResponseHandler;
import java.io.IOException;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpResponseException;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.util.EntityUtils;

public class BinaryHttpResponseHandler
extends AsyncHttpResponseHandler {
    private static String[] mAllowedContentTypes = new String[]{"image/jpeg", "image/png"};

    public BinaryHttpResponseHandler() {
    }

    public BinaryHttpResponseHandler(String[] stringArray) {
        this();
        mAllowedContentTypes = stringArray;
    }

    public void onSuccess(byte[] byArray) {
    }

    public void onSuccess(int n, byte[] byArray) {
        this.onSuccess(byArray);
    }

    public void onFailure(Throwable throwable, byte[] byArray) {
        this.onFailure(throwable);
    }

    protected void sendSuccessMessage(int n, byte[] byArray) {
        this.sendMessage(this.obtainMessage(0, new Object[]{n, byArray}));
    }

    @Override
    protected void sendFailureMessage(Throwable throwable, byte[] byArray) {
        this.sendMessage(this.obtainMessage(1, new Object[]{throwable, byArray}));
    }

    protected void handleSuccessMessage(int n, byte[] byArray) {
        this.onSuccess(n, byArray);
    }

    protected void handleFailureMessage(Throwable throwable, byte[] byArray) {
        this.onFailure(throwable, byArray);
    }

    @Override
    protected void handleMessage(Message message) {
        switch (message.what) {
            case 0: {
                Object[] objectArray = (Object[])message.obj;
                this.handleSuccessMessage((int)((Integer)objectArray[0]), (byte[])objectArray[1]);
                break;
            }
            case 1: {
                Object[] objectArray = (Object[])message.obj;
                this.handleFailureMessage((Throwable)objectArray[0], (byte[])objectArray[1]);
                break;
            }
            default: {
                super.handleMessage(message);
            }
        }
    }

    @Override
    void sendResponseMessage(HttpResponse httpResponse) {
        StatusLine statusLine = httpResponse.getStatusLine();
        Header[] headerArray = httpResponse.getHeaders("Content-Type");
        byte[] byArray = null;
        if (headerArray.length != 1) {
            this.sendFailureMessage((Throwable)new HttpResponseException(statusLine.getStatusCode(), "None, or more than one, Content-Type Header found!"), byArray);
            return;
        }
        Header header = headerArray[0];
        boolean bl = false;
        for (String string : mAllowedContentTypes) {
            if (!string.equals(header.getValue())) continue;
            bl = true;
        }
        if (!bl) {
            this.sendFailureMessage((Throwable)new HttpResponseException(statusLine.getStatusCode(), "Content-Type not allowed!"), byArray);
            return;
        }
        try {
            BufferedHttpEntity bufferedHttpEntity = null;
            HttpEntity httpEntity = httpResponse.getEntity();
            if (httpEntity != null) {
                bufferedHttpEntity = new BufferedHttpEntity(httpEntity);
            }
            byArray = EntityUtils.toByteArray((HttpEntity)bufferedHttpEntity);
        }
        catch (IOException iOException) {
            this.sendFailureMessage((Throwable)iOException, (byte[])null);
        }
        if (statusLine.getStatusCode() >= 300) {
            this.sendFailureMessage((Throwable)new HttpResponseException(statusLine.getStatusCode(), statusLine.getReasonPhrase()), byArray);
        } else {
            this.sendSuccessMessage(statusLine.getStatusCode(), byArray);
        }
    }
}

