/*
 * Decompiled with CFR 0.152.
 */
package com.loopj.android.http;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpResponseException;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.util.EntityUtils;

public class AsyncHttpResponseHandler {
    protected static final int SUCCESS_MESSAGE = 0;
    protected static final int FAILURE_MESSAGE = 1;
    protected static final int START_MESSAGE = 2;
    protected static final int FINISH_MESSAGE = 3;
    private Handler handler;

    public AsyncHttpResponseHandler() {
        if (Looper.myLooper() != null) {
            this.handler = new Handler(){

                public void handleMessage(Message message) {
                    AsyncHttpResponseHandler.this.handleMessage(message);
                }
            };
        }
    }

    public void onStart() {
    }

    public void onFinish() {
    }

    public void onSuccess(String string) {
    }

    public void onSuccess(int n, String string) {
        this.onSuccess(string);
    }

    public void onFailure(Throwable throwable) {
    }

    public void onFailure(Throwable throwable, String string) {
        this.onFailure(throwable);
    }

    protected void sendSuccessMessage(int n, String string) {
        this.sendMessage(this.obtainMessage(0, new Object[]{new Integer(n), string}));
    }

    protected void sendFailureMessage(Throwable throwable, String string) {
        this.sendMessage(this.obtainMessage(1, new Object[]{throwable, string}));
    }

    protected void sendFailureMessage(Throwable throwable, byte[] byArray) {
        this.sendMessage(this.obtainMessage(1, new Object[]{throwable, byArray}));
    }

    protected void sendStartMessage() {
        this.sendMessage(this.obtainMessage(2, null));
    }

    protected void sendFinishMessage() {
        this.sendMessage(this.obtainMessage(3, null));
    }

    protected void handleSuccessMessage(int n, String string) {
        this.onSuccess(n, string);
    }

    protected void handleFailureMessage(Throwable throwable, String string) {
        this.onFailure(throwable, string);
    }

    protected void handleMessage(Message message) {
        switch (message.what) {
            case 0: {
                Object[] objectArray = (Object[])message.obj;
                this.handleSuccessMessage((Integer)objectArray[0], (String)objectArray[1]);
                break;
            }
            case 1: {
                Object[] objectArray = (Object[])message.obj;
                this.handleFailureMessage((Throwable)objectArray[0], (String)objectArray[1]);
                break;
            }
            case 2: {
                this.onStart();
                break;
            }
            case 3: {
                this.onFinish();
            }
        }
    }

    protected void sendMessage(Message message) {
        if (this.handler != null) {
            this.handler.sendMessage(message);
        } else {
            this.handleMessage(message);
        }
    }

    protected Message obtainMessage(int n, Object object) {
        Message message = null;
        if (this.handler != null) {
            message = this.handler.obtainMessage(n, object);
        } else {
            message = new Message();
            message.what = n;
            message.obj = object;
        }
        return message;
    }

    void sendResponseMessage(HttpResponse httpResponse) {
        StatusLine statusLine = httpResponse.getStatusLine();
        String string = null;
        try {
            BufferedHttpEntity bufferedHttpEntity = null;
            HttpEntity httpEntity = httpResponse.getEntity();
            if (httpEntity != null) {
                bufferedHttpEntity = new BufferedHttpEntity(httpEntity);
                string = EntityUtils.toString((HttpEntity)bufferedHttpEntity, (String)"UTF-8");
            }
        }
        catch (IOException iOException) {
            this.sendFailureMessage((Throwable)iOException, (String)null);
        }
        if (statusLine.getStatusCode() >= 300) {
            this.sendFailureMessage((Throwable)new HttpResponseException(statusLine.getStatusCode(), statusLine.getReasonPhrase()), string);
        } else {
            this.sendSuccessMessage(statusLine.getStatusCode(), string);
        }
    }
}

