/*
 * Decompiled with CFR 0.152.
 */
package com.loopj.android.http;

import com.loopj.android.http.AsyncHttpResponseHandler;
import com.loopj.android.http.BinaryHttpResponseHandler;
import java.io.IOException;
import java.net.ConnectException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.AbstractHttpClient;
import org.apache.http.protocol.HttpContext;

class AsyncHttpRequest
implements Runnable {
    private final AbstractHttpClient client;
    private final HttpContext context;
    private final HttpUriRequest request;
    private final AsyncHttpResponseHandler responseHandler;
    private boolean isBinaryRequest;
    private int executionCount;

    public AsyncHttpRequest(AbstractHttpClient abstractHttpClient, HttpContext httpContext, HttpUriRequest httpUriRequest, AsyncHttpResponseHandler asyncHttpResponseHandler) {
        this.client = abstractHttpClient;
        this.context = httpContext;
        this.request = httpUriRequest;
        this.responseHandler = asyncHttpResponseHandler;
        if (asyncHttpResponseHandler instanceof BinaryHttpResponseHandler) {
            this.isBinaryRequest = true;
        }
    }

    @Override
    public void run() {
        block5: {
            try {
                if (this.responseHandler != null) {
                    this.responseHandler.sendStartMessage();
                }
                this.makeRequestWithRetries();
                if (this.responseHandler != null) {
                    this.responseHandler.sendFinishMessage();
                }
            }
            catch (IOException iOException) {
                if (this.responseHandler == null) break block5;
                this.responseHandler.sendFinishMessage();
                if (this.isBinaryRequest) {
                    this.responseHandler.sendFailureMessage((Throwable)iOException, (byte[])null);
                }
                this.responseHandler.sendFailureMessage((Throwable)iOException, (String)null);
            }
        }
    }

    private void makeRequest() throws IOException {
        if (!Thread.currentThread().isInterrupted()) {
            HttpResponse httpResponse = this.client.execute(this.request, this.context);
            if (!Thread.currentThread().isInterrupted() && this.responseHandler != null) {
                this.responseHandler.sendResponseMessage(httpResponse);
            }
        }
    }

    private void makeRequestWithRetries() throws ConnectException {
        boolean bl = true;
        IOException iOException = null;
        HttpRequestRetryHandler httpRequestRetryHandler = this.client.getHttpRequestRetryHandler();
        while (bl) {
            try {
                this.makeRequest();
                return;
            }
            catch (UnknownHostException unknownHostException) {
                if (this.responseHandler != null) {
                    this.responseHandler.sendFailureMessage((Throwable)unknownHostException, "can't resolve host");
                }
                return;
            }
            catch (SocketException socketException) {
                if (this.responseHandler != null) {
                    this.responseHandler.sendFailureMessage((Throwable)socketException, "can't resolve host");
                }
                return;
            }
            catch (SocketTimeoutException socketTimeoutException) {
                if (this.responseHandler != null) {
                    this.responseHandler.sendFailureMessage((Throwable)socketTimeoutException, "socket time out");
                }
                return;
            }
            catch (IOException iOException2) {
                iOException = iOException2;
                bl = httpRequestRetryHandler.retryRequest(iOException, ++this.executionCount, this.context);
            }
            catch (NullPointerException nullPointerException) {
                iOException = new IOException("NPE in HttpClient" + nullPointerException.getMessage());
                bl = httpRequestRetryHandler.retryRequest(iOException, ++this.executionCount, this.context);
            }
        }
        ConnectException connectException = new ConnectException();
        connectException.initCause(iOException);
        throw connectException;
    }
}

