/*
 * Decompiled with CFR 0.152.
 */
package com.loopj.android.http;

import android.content.Context;
import com.loopj.android.http.AsyncHttpRequest;
import com.loopj.android.http.AsyncHttpResponseHandler;
import com.loopj.android.http.RequestParams;
import com.loopj.android.http.RetryHandler;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.zip.GZIPInputStream;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CookieStore;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.params.ConnManagerParams;
import org.apache.http.conn.params.ConnPerRoute;
import org.apache.http.conn.params.ConnPerRouteBean;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.entity.HttpEntityWrapper;
import org.apache.http.impl.client.AbstractHttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.SyncBasicHttpContext;

public class AsyncHttpClient {
    private static final String VERSION = "1.4.1";
    private static final int DEFAULT_MAX_CONNECTIONS = 10;
    private static final int DEFAULT_SOCKET_TIMEOUT = 10000;
    private static final int DEFAULT_MAX_RETRIES = 5;
    private static final int DEFAULT_SOCKET_BUFFER_SIZE = 8192;
    private static final String HEADER_ACCEPT_ENCODING = "Accept-Encoding";
    private static final String ENCODING_GZIP = "gzip";
    private static int maxConnections = 10;
    private static int socketTimeout = 10000;
    private final DefaultHttpClient httpClient;
    private final HttpContext httpContext;
    private ThreadPoolExecutor threadPool;
    private final Map<Context, List<WeakReference<Future<?>>>> requestMap;
    private final Map<String, String> clientHeaderMap;

    public AsyncHttpClient() {
        BasicHttpParams basicHttpParams = new BasicHttpParams();
        ConnManagerParams.setTimeout((HttpParams)basicHttpParams, (long)socketTimeout);
        ConnManagerParams.setMaxConnectionsPerRoute((HttpParams)basicHttpParams, (ConnPerRoute)new ConnPerRouteBean(maxConnections));
        ConnManagerParams.setMaxTotalConnections((HttpParams)basicHttpParams, (int)10);
        HttpConnectionParams.setSoTimeout((HttpParams)basicHttpParams, (int)socketTimeout);
        HttpConnectionParams.setConnectionTimeout((HttpParams)basicHttpParams, (int)socketTimeout);
        HttpConnectionParams.setTcpNoDelay((HttpParams)basicHttpParams, (boolean)true);
        HttpConnectionParams.setSocketBufferSize((HttpParams)basicHttpParams, (int)8192);
        HttpProtocolParams.setVersion((HttpParams)basicHttpParams, (ProtocolVersion)HttpVersion.HTTP_1_1);
        HttpProtocolParams.setUserAgent((HttpParams)basicHttpParams, (String)String.format("android-async-http/%s (http://loopj.com/android-async-http)", VERSION));
        SchemeRegistry schemeRegistry = new SchemeRegistry();
        schemeRegistry.register(new Scheme("http", (SocketFactory)PlainSocketFactory.getSocketFactory(), 80));
        schemeRegistry.register(new Scheme("https", (SocketFactory)SSLSocketFactory.getSocketFactory(), 443));
        ThreadSafeClientConnManager threadSafeClientConnManager = new ThreadSafeClientConnManager((HttpParams)basicHttpParams, schemeRegistry);
        this.httpContext = new SyncBasicHttpContext((HttpContext)new BasicHttpContext());
        this.httpClient = new DefaultHttpClient((ClientConnectionManager)threadSafeClientConnManager, (HttpParams)basicHttpParams);
        this.httpClient.addRequestInterceptor(new HttpRequestInterceptor(){

            public void process(HttpRequest httpRequest, HttpContext httpContext) {
                if (!httpRequest.containsHeader(AsyncHttpClient.HEADER_ACCEPT_ENCODING)) {
                    httpRequest.addHeader(AsyncHttpClient.HEADER_ACCEPT_ENCODING, AsyncHttpClient.ENCODING_GZIP);
                }
                for (String string : AsyncHttpClient.this.clientHeaderMap.keySet()) {
                    httpRequest.addHeader(string, (String)AsyncHttpClient.this.clientHeaderMap.get(string));
                }
            }
        });
        this.httpClient.addResponseInterceptor(new HttpResponseInterceptor(){

            public void process(HttpResponse httpResponse, HttpContext httpContext) {
                HttpEntity httpEntity = httpResponse.getEntity();
                if (httpEntity == null) {
                    return;
                }
                Header header = httpEntity.getContentEncoding();
                if (header != null) {
                    for (HeaderElement headerElement : header.getElements()) {
                        if (!headerElement.getName().equalsIgnoreCase(AsyncHttpClient.ENCODING_GZIP)) continue;
                        httpResponse.setEntity((HttpEntity)new InflatingEntity(httpResponse.getEntity()));
                        break;
                    }
                }
            }
        });
        this.httpClient.setHttpRequestRetryHandler((HttpRequestRetryHandler)new RetryHandler(5));
        this.threadPool = (ThreadPoolExecutor)Executors.newCachedThreadPool();
        this.requestMap = new WeakHashMap();
        this.clientHeaderMap = new HashMap<String, String>();
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public HttpContext getHttpContext() {
        return this.httpContext;
    }

    public void setCookieStore(CookieStore cookieStore) {
        this.httpContext.setAttribute("http.cookie-store", (Object)cookieStore);
    }

    public void setThreadPool(ThreadPoolExecutor threadPoolExecutor) {
        this.threadPool = threadPoolExecutor;
    }

    public void setUserAgent(String string) {
        HttpProtocolParams.setUserAgent((HttpParams)this.httpClient.getParams(), (String)string);
    }

    public void setTimeout(int n) {
        HttpParams httpParams = this.httpClient.getParams();
        ConnManagerParams.setTimeout((HttpParams)httpParams, (long)n);
        HttpConnectionParams.setSoTimeout((HttpParams)httpParams, (int)n);
        HttpConnectionParams.setConnectionTimeout((HttpParams)httpParams, (int)n);
    }

    public void setSSLSocketFactory(SSLSocketFactory sSLSocketFactory) {
        this.httpClient.getConnectionManager().getSchemeRegistry().register(new Scheme("https", (SocketFactory)sSLSocketFactory, 443));
    }

    public void addHeader(String string, String string2) {
        this.clientHeaderMap.put(string, string2);
    }

    public void setBasicAuth(String string, String string2) {
        AuthScope authScope = AuthScope.ANY;
        this.setBasicAuth(string, string2, authScope);
    }

    public void setBasicAuth(String string, String string2, AuthScope authScope) {
        UsernamePasswordCredentials usernamePasswordCredentials = new UsernamePasswordCredentials(string, string2);
        this.httpClient.getCredentialsProvider().setCredentials(authScope, (Credentials)usernamePasswordCredentials);
    }

    public void cancelRequests(Context context, boolean bl) {
        List<WeakReference<Future<?>>> list = this.requestMap.get(context);
        if (list != null) {
            for (WeakReference<Future<?>> weakReference : list) {
                Future future = (Future)weakReference.get();
                if (future == null) continue;
                future.cancel(bl);
            }
        }
        this.requestMap.remove(context);
    }

    public void get(String string, AsyncHttpResponseHandler asyncHttpResponseHandler) {
        this.get(null, string, null, asyncHttpResponseHandler);
    }

    public void get(String string, RequestParams requestParams, AsyncHttpResponseHandler asyncHttpResponseHandler) {
        this.get(null, string, requestParams, asyncHttpResponseHandler);
    }

    public void get(Context context, String string, AsyncHttpResponseHandler asyncHttpResponseHandler) {
        this.get(context, string, null, asyncHttpResponseHandler);
    }

    public void get(Context context, String string, RequestParams requestParams, AsyncHttpResponseHandler asyncHttpResponseHandler) {
        this.sendRequest(this.httpClient, this.httpContext, (HttpUriRequest)new HttpGet(AsyncHttpClient.getUrlWithQueryString(string, requestParams)), null, asyncHttpResponseHandler, context);
    }

    public void get(Context context, String string, Header[] headerArray, RequestParams requestParams, AsyncHttpResponseHandler asyncHttpResponseHandler) {
        HttpGet httpGet = new HttpGet(AsyncHttpClient.getUrlWithQueryString(string, requestParams));
        if (headerArray != null) {
            httpGet.setHeaders(headerArray);
        }
        this.sendRequest(this.httpClient, this.httpContext, (HttpUriRequest)httpGet, null, asyncHttpResponseHandler, context);
    }

    public void post(String string, AsyncHttpResponseHandler asyncHttpResponseHandler) {
        this.post(null, string, null, asyncHttpResponseHandler);
    }

    public void post(String string, RequestParams requestParams, AsyncHttpResponseHandler asyncHttpResponseHandler) {
        this.post(null, string, requestParams, asyncHttpResponseHandler);
    }

    public void post(Context context, String string, RequestParams requestParams, AsyncHttpResponseHandler asyncHttpResponseHandler) {
        this.post(context, string, this.paramsToEntity(requestParams), null, asyncHttpResponseHandler);
    }

    public void post(Context context, String string, HttpEntity httpEntity, String string2, AsyncHttpResponseHandler asyncHttpResponseHandler) {
        this.sendRequest(this.httpClient, this.httpContext, (HttpUriRequest)this.addEntityToRequestBase((HttpEntityEnclosingRequestBase)new HttpPost(string), httpEntity), string2, asyncHttpResponseHandler, context);
    }

    public void post(Context context, String string, Header[] headerArray, RequestParams requestParams, String string2, AsyncHttpResponseHandler asyncHttpResponseHandler) {
        HttpPost httpPost = new HttpPost(string);
        if (requestParams != null) {
            httpPost.setEntity(this.paramsToEntity(requestParams));
        }
        if (headerArray != null) {
            httpPost.setHeaders(headerArray);
        }
        this.sendRequest(this.httpClient, this.httpContext, (HttpUriRequest)httpPost, string2, asyncHttpResponseHandler, context);
    }

    public void post(Context context, String string, Header[] headerArray, HttpEntity httpEntity, String string2, AsyncHttpResponseHandler asyncHttpResponseHandler) {
        HttpEntityEnclosingRequestBase httpEntityEnclosingRequestBase = this.addEntityToRequestBase((HttpEntityEnclosingRequestBase)new HttpPost(string), httpEntity);
        if (headerArray != null) {
            httpEntityEnclosingRequestBase.setHeaders(headerArray);
        }
        this.sendRequest(this.httpClient, this.httpContext, (HttpUriRequest)httpEntityEnclosingRequestBase, string2, asyncHttpResponseHandler, context);
    }

    public void put(String string, AsyncHttpResponseHandler asyncHttpResponseHandler) {
        this.put(null, string, null, asyncHttpResponseHandler);
    }

    public void put(String string, RequestParams requestParams, AsyncHttpResponseHandler asyncHttpResponseHandler) {
        this.put(null, string, requestParams, asyncHttpResponseHandler);
    }

    public void put(Context context, String string, RequestParams requestParams, AsyncHttpResponseHandler asyncHttpResponseHandler) {
        this.put(context, string, this.paramsToEntity(requestParams), null, asyncHttpResponseHandler);
    }

    public void put(Context context, String string, HttpEntity httpEntity, String string2, AsyncHttpResponseHandler asyncHttpResponseHandler) {
        this.sendRequest(this.httpClient, this.httpContext, (HttpUriRequest)this.addEntityToRequestBase((HttpEntityEnclosingRequestBase)new HttpPut(string), httpEntity), string2, asyncHttpResponseHandler, context);
    }

    public void put(Context context, String string, Header[] headerArray, HttpEntity httpEntity, String string2, AsyncHttpResponseHandler asyncHttpResponseHandler) {
        HttpEntityEnclosingRequestBase httpEntityEnclosingRequestBase = this.addEntityToRequestBase((HttpEntityEnclosingRequestBase)new HttpPut(string), httpEntity);
        if (headerArray != null) {
            httpEntityEnclosingRequestBase.setHeaders(headerArray);
        }
        this.sendRequest(this.httpClient, this.httpContext, (HttpUriRequest)httpEntityEnclosingRequestBase, string2, asyncHttpResponseHandler, context);
    }

    public void delete(String string, AsyncHttpResponseHandler asyncHttpResponseHandler) {
        this.delete(null, string, asyncHttpResponseHandler);
    }

    public void delete(Context context, String string, AsyncHttpResponseHandler asyncHttpResponseHandler) {
        HttpDelete httpDelete = new HttpDelete(string);
        this.sendRequest(this.httpClient, this.httpContext, (HttpUriRequest)httpDelete, null, asyncHttpResponseHandler, context);
    }

    public void delete(Context context, String string, Header[] headerArray, AsyncHttpResponseHandler asyncHttpResponseHandler) {
        HttpDelete httpDelete = new HttpDelete(string);
        if (headerArray != null) {
            httpDelete.setHeaders(headerArray);
        }
        this.sendRequest(this.httpClient, this.httpContext, (HttpUriRequest)httpDelete, null, asyncHttpResponseHandler, context);
    }

    protected void sendRequest(DefaultHttpClient defaultHttpClient, HttpContext httpContext, HttpUriRequest httpUriRequest, String string, AsyncHttpResponseHandler asyncHttpResponseHandler, Context context) {
        if (string != null) {
            httpUriRequest.addHeader("Content-Type", string);
        }
        Future<?> future = this.threadPool.submit(new AsyncHttpRequest((AbstractHttpClient)defaultHttpClient, httpContext, httpUriRequest, asyncHttpResponseHandler));
        if (context != null) {
            List<WeakReference<Future<?>>> list = this.requestMap.get(context);
            if (list == null) {
                list = new LinkedList();
                this.requestMap.put(context, list);
            }
            list.add(new WeakReference(future));
        }
    }

    public static String getUrlWithQueryString(String string, RequestParams requestParams) {
        if (requestParams != null) {
            String string2 = requestParams.getParamString();
            string = string.indexOf("?") == -1 ? string + "?" + string2 : string + "&" + string2;
        }
        return string;
    }

    private HttpEntity paramsToEntity(RequestParams requestParams) {
        HttpEntity httpEntity = null;
        if (requestParams != null) {
            httpEntity = requestParams.getEntity();
        }
        return httpEntity;
    }

    private HttpEntityEnclosingRequestBase addEntityToRequestBase(HttpEntityEnclosingRequestBase httpEntityEnclosingRequestBase, HttpEntity httpEntity) {
        if (httpEntity != null) {
            httpEntityEnclosingRequestBase.setEntity(httpEntity);
        }
        return httpEntityEnclosingRequestBase;
    }

    private static class InflatingEntity
    extends HttpEntityWrapper {
        public InflatingEntity(HttpEntity httpEntity) {
            super(httpEntity);
        }

        public InputStream getContent() throws IOException {
            return new GZIPInputStream(this.wrappedEntity.getContent());
        }

        public long getContentLength() {
            return -1L;
        }
    }
}

