       /*
        *  Licensed Materials - Property of IBM
        *  5725-G92 (C) Copyright IBM Corp. 2011, 2012. All Rights Reserved.
        *  US Government Users Restricted Rights - Use, duplication or
        *  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
        */


package com.worklight;

import java.io.IOException;
import java.util.Map;
import java.util.logging.Logger;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;


import com.worklight.server.auth.api.AuthenticationResult;
import com.worklight.server.auth.api.AuthenticationStatus;
import com.worklight.server.auth.api.MissingConfigurationOptionException;
import com.worklight.server.auth.api.UserIdentity;
import com.worklight.server.auth.api.UsernamePasswordAuthenticator;

public class UsernamePasswordJSONAuthenticator extends UsernamePasswordAuthenticator {

	private static final Logger logger = Logger.getLogger(UsernamePasswordJSONAuthenticator.class.getName());
	
	private static final String AUTH_REQUEST_URL_COMPONENT = "adauth";
	private static final String AUTH_USERNAME = "username";
	private static final String AUTH_PASSWORD = "password";
	
	@Override
	public void init(Map<String, String> options) throws MissingConfigurationOptionException {
		//logger.info("LDAPAuthenticator :: init");
	}

	@Override
	public AuthenticationResult processRequest(HttpServletRequest request, HttpServletResponse response, boolean isAccessToProtectedResource) throws IOException, ServletException {
		//logger.info("LDAPAuthenticator :: processRequest");
		
		if (request.getRequestURI().contains(AUTH_REQUEST_URL_COMPONENT)){
			userName = request.getParameter(AUTH_USERNAME);
			password = request.getParameter(AUTH_PASSWORD);
			return AuthenticationResult.createFrom(AuthenticationStatus.SUCCESS);
		} else if (isAccessToProtectedResource) {
			response.setContentType("application/json; charset=UTF-8");
			response.setHeader("Cache-Control", "no-cache, must-revalidate");
			response.getWriter().print("{\"authStatus\":\"required\"}");
			return AuthenticationResult.createFrom(AuthenticationStatus.CLIENT_INTERACTION_REQUIRED);
		} else {
			return AuthenticationResult.createFrom(AuthenticationStatus.REQUEST_NOT_RECOGNIZED);
		}
	}

	@Override
	public AuthenticationResult processRequestAlreadyAuthenticated(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
		//logger.info("LDAPAuthenticator :: processRequestAlreadyAuthenticated");
		return AuthenticationResult.createFrom(AuthenticationStatus.REQUEST_NOT_RECOGNIZED);
	}

	@Override
	public AuthenticationResult processAuthenticationFailure(HttpServletRequest request, HttpServletResponse response, String errorMessage) throws IOException, ServletException {
		//logger.info("LDAPAuthenticator :: processAuthenticationFailure");
		response.setContentType("application/json; charset=UTF-8");
		response.setHeader("Cache-Control", "no-cache, must-revalidate");
		response.getWriter().print("{\"authStatus\":\"required\", \"errorMessage\":\"" + errorMessage + "\"}");
		return AuthenticationResult.createFrom(AuthenticationStatus.CLIENT_INTERACTION_REQUIRED);
	}

	@Override
	public HttpServletRequest getRequestToProceed(HttpServletRequest currentRequest, HttpServletResponse currentResponse, UserIdentity user) throws IOException {
		//logger.info("LDAPAuthenticator :: getRequestToProceed");
		return null;
	}

	@Override
	public boolean changeResponseOnSuccess(HttpServletRequest request, HttpServletResponse response) throws IOException {
		//logger.info("LDAPAuthenticator :: changeResponseOnSuccess");
		if (request.getRequestURI().contains(AUTH_REQUEST_URL_COMPONENT)){
			response.setContentType("application/json; charset=UTF-8");
			response.setHeader("Cache-Control", "no-cache, must-revalidate");
			response.getWriter().print("{\"authStatus\":\"complete\"}");
			return true;
		}
		return false;
	}

}
