       /*
        *  Licensed Materials - Property of IBM
        *  5725-G92 (C) Copyright IBM Corp. 2011, 2012. All Rights Reserved.
        *  US Government Users Restricted Rights - Use, duplication or
        *  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
        */

var LDAPRealmChallengeHandler = WL.Client.createChallengeHandler("LDAPRealm");

LDAPRealmChallengeHandler.isCustomResponse = function(response) {
    if (!response || !response.responseJSON) {
        return false;
    }
    
    if (response.responseJSON.authStatus){ 
    	return true;
    }
    else {
    	LDAPRealmChallengeHandler.submitFailure();
    	return false;
    }
};

LDAPRealmChallengeHandler.handleChallenge = function(response){
	var authStatus = response.responseJSON.authStatus;
	
	if (authStatus == "required"){
		$('#AppDiv').hide();
		$('#AuthDiv').show();
		$('#passwordInputField').val('');
        
		if (response.responseJSON.errorMessage){
			$("#resultDiv").html(response.responseJSON.errorMessage);
        }
		
	} else if (authStatus == "complete"){
		$('#AppDiv').show();
		$('#AuthDiv').hide();
		LDAPRealmChallengeHandler.submitSuccess();
	}
};

$('#loginButton').bind('click', function () {
    var reqURL = '/adauth';
    var options = {};
    options.parameters = {
        username : $('#usernameInputField').val(),
        password : $('#passwordInputField').val()
    };
    options.headers = {};
    LDAPRealmChallengeHandler.submitLoginForm(reqURL, options, LDAPRealmChallengeHandler.submitLoginFormCallback);
});

$('#cancelButton').bind('click', function () {
	$('#AppDiv').show();
	$('#AuthDiv').hide();
	LDAPRealmChallengeHandler.submitFailure();
});

LDAPRealmChallengeHandler.submitLoginFormCallback = function(response) {
    var isLoginFormResponse = LDAPRealmChallengeHandler.isCustomResponse(response);
    if (isLoginFormResponse){
    	LDAPRealmChallengeHandler.handleChallenge(response);
    } 
};