/* PRINTPS.CMD - Print an ASCII file on a Postscript printer */
/* Written by Michael Perks (10/31/92) */
/* (c) Copyright IBM Corp. 1992 All Rights Reserved */
output = 'LPT1'
numlines = 80     /* right hand side may get clipped if font is too large */
pagelength = 792  /* points or 11 inches */
topmargin =  36   /* points or 0.5 inch  */
bottommargin = 36 /* points or 0.5 inch  */
leftmargin = 54   /* points or 0.75 inch */
linesize = (pagelength - topmargin - bottommargin) / numlines
parse arg filename rest
call stream filename, C, 'query exists'
if result = "" then
do
    say 'PRINTPS.CMD: Error, cannot find' filename
    exit
end
/* PS file header */
call lineout output, '% PRINTPS.CMD PostScript OUTPUT'
call lineout output, '/cour /Courier findfont 'linesize' scalefont def'
call lineout output, 'cour setfont gsave'
/* read each line, quote characters and then output */
linecount = 0
pagethrow = 0
do until lines(filename)=0
    line = linein(filename)
    if pagethrow then do
        call lineout output, 'showpage grestore gsave'
        pagethrow = 0
    end
    line = quotechar(line, '\', '\')
    line = quotechar(line, '(', '\')
    line = quotechar(line, ')', '\')
    ycoord = pagelength - topmargin - linecount*linesize
    call lineout output, leftmargin ycoord 'moveto ('line') show'
    linecount = linecount + 1
    if linecount = numlines then do
        pagethrow = 1
        linecount = 0
    end
end
if pagethrow | linecount<>0 then call lineout output, 'showpage grestore'
call lineout output /* close output */
exit

/* quotechar - returns string with character "quoted" by another character */
/* the quote character is also known as the escape character */
quotechar:
parse arg newline, char, quote
index = pos(char,newline,1)
do while index<>0
    newline = insert(quote,newline,index-1)
    index = pos(char,newline,index+2)
end
return newline
