//
// CGITEST.C
//
// (c)1996, Lotus Development Corporation, a subsidiary of IBM
//
// CGITEST is a sample program that handles CGI requests.
// It's typically be called in response to a form submittal
// and output is displayed on browser.
//

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>


//
// Defines
//
#define BUFLEN 4096


//
// Global variables
//
char InputBuffer[BUFLEN];




//
// strcvrt()
//
// Convert all cOld characters in cStr into cNew characters
//

void strcvrt(char * cStr,char cOld,char cNew)
{
   int i;

   i = 0;

   while (cStr[i])
   {
      if (cStr[i]==cOld) cStr[i] = cNew;
      i++;
   }

   return;
}



//
// TwoHexToInt()
//
// Return int based on two hex chars.
//

int TwoHexToInt(char *pC)
{
   int High = pC[0];
   int Low = pC[1];

   // High
   if ('0' <= High && High <= '9')
   {  High -= '0';
   }
   else if ('a' <= High && High <= 'f')
   {  High -= ('a'-10);
   }
   else if ('A' <= High && High <= 'F')
   {  High -= ('A'-10);
   }

   // Low
   if ('0' <= Low && Low <= '9')
   {  Low -= '0';
   }
   else if ('a' <= Low && Low <= 'f')
   {  Low -= ('a'-10);
   }
   else if ('A' <= Low && Low <= 'F')
   {  Low -= ('A'-10);
   }

   return(Low + (High*16));
}



//
// DisplayEnvironment()
//
// Display all the environment variables
//

void DisplayEnvironment(void)
{
   int i=0;

   printf("\n\n");
   printf("Environment variables:\n");
   printf("=====================:\n");

   while (_environ[i])
   {
      printf("%s\n", _environ[i++]);
   }

   printf("\n");

   return;
}



//
// urlDecode()
//
// Decode the given string in-place by expanding %XX escapes
//

void urlDecode(char *pch)
{
   char *pDest;

   pDest = pch;

   while (*pch)
   {
      // Is this next character escaped?
      if (*pch=='%')
      {
         // Yes, so next two chars are hex of the actual character
         pch++;

         if (isxdigit(pch[0]) && isxdigit(pch[1]))
         {
            *pDest++ = (char) TwoHexToInt(pch);
            pch += 2;
         }
      }
      else
      {
         // No, just copy it.
         *pDest++ = *pch++;
      }
   }

   *pDest = '\0';

   return;
}



//
// DisplayField()
//
// Parse out and display field=value items.  Don't use strtok!
//

void DisplayField(char *Item)
{
   char *p;

   p = strchr(Item,'=');

   if (p==NULL)
   {
      return;
   }

   *p++='\0';
   urlDecode(Item);
   urlDecode(p);
   strcvrt(p,'\n',' ');
   printf("%s = %s\n",Item,p);

   return;
}


//
// GetCGIVersion()
//

char * GetCGIVersion(void)
{
   return(getenv("GATEWAY_INTERFACE"));
}



//
// GetRequestMethod()
//

char * GetRequestMethod(void)
{
   return(getenv("REQUEST_METHOD"));
}



//
// GetContentLength()
//

char * GetContentLength(void)
{
   return(getenv("CONTENT_LENGTH"));
}



//
// GetContentType()
//

char * GetContentType(void)
{
   return(getenv("CONTENT_TYPE"));
}



//
// GetQueryString()
//

char * GetQueryString(void)
{
   return(getenv("QUERY_STRING"));
}



//
// SendHeaders()
//
// Send HTTP headers
//

void SendHeaders(void)
{
   char * pszCGIVersion;


   // Inform client we're sending text/plain
   printf("Content-type: text/plain\n");

   // If running CGI/1.1, send a Status: header
   if ((pszCGIVersion = GetCGIVersion()) != NULL)
   {
      if (_stricmp(pszCGIVersion, "CGI/1.1"))
      {
         printf("Status: 200 OK\n");
      }
   }

   // Done sending headers
   printf("\n");

   // Send Banner
   printf("Results of CGITEST...\n\n");

   return;
}



//
// DisplayCommandLineArgs();
//

void DisplayCommandLineArgs(int argc, char *argv[])
{
   int i;

   printf("\n\n");
   printf("Command Line Args:\n");
   printf("=================:\n");

   // Print out number of arguments
   printf("Number of arguments (argc) = %d\n", argc);

   // Print out command line variables
   for (i=0;i<argc;i++)
   {
      printf("argv[%d] = %s\n",i,argv[i]);
   }

   printf("\n");

   return;
}



//
// main()
//
// Main entry point
//

int main(int argc, char *argv[])
{
   int ContentLength;
   int x;
   int i;
   char *p;
   char *pszRequestMethod;


   // Turn buffering off for stdin
   setvbuf(stdin, NULL, _IONBF, 0);

   // Send HTTP headers to browser
   SendHeaders();

   // What method were we invoked through?
   if ((pszRequestMethod = GetRequestMethod()) == NULL)
   {
      printf("Unknown request method.\n");

      return(0);
   }

   //
   // Is it a POST?
   //

   if (_stricmp(pszRequestMethod,"POST") == 0)
   {
      // Read in the data from the client
      if ((p = GetContentLength()) != NULL)
      {
         ContentLength = atoi(p);
      }
      else
      {
         ContentLength = 0;
      }

      if (ContentLength > (BUFLEN-1))
      {
         ContentLength = BUFLEN-1;
      }

      i = 0;

      // Read stdin and get contents of the post.

      while (i < ContentLength)
      {
         if ((x = fgetc(stdin)) == EOF)
         {
            break;
         }

         InputBuffer[i++] = x;
      }

      InputBuffer[i] = '\0';
      ContentLength = i;

      if ((p = GetContentType()) == NULL)
      {
         return(0);
      }

      if (_stricmp(p,"application/x-www-form-urlencoded") == 0)
      {
         printf("Display Fields:\n");
         printf("=================:\n");

         // Parse the data
         p = strtok(InputBuffer,"&");

         while (p)
         {
            // Display the field and value.
            DisplayField(p);

            // Advance to next field.
            p = strtok(NULL,"&");
         }
      }
      else
      {
         // Just display the data
         printf("Input = %s\n",InputBuffer);
      }
   }
   else
   {
      // Is it a GET?
      if (_stricmp(pszRequestMethod, "GET") == 0)
      {
         //Parse the data in the search term
         if ((p = GetQueryString()) != NULL)
         {
            strncpy(InputBuffer, p, sizeof(InputBuffer));

            p = strtok(InputBuffer,"&");

            while (p)
            {
               // Display the field and values.
               DisplayField(p);

               // Advance to next field.
               p = strtok(NULL,"&");
            }
         }
      }
   }

   // Display the command line args to the CGI program.
   DisplayCommandLineArgs(argc, argv);

   // Display the environment variables
   DisplayEnvironment();

   return(0);
}
