/****************************************************************************

	Copyright (c) 1996 Lotus Development Corporation

	Program:    RICHTEXT

	File:       RICHTEXT.CPP

	Syntax:     richtext <dbname> [<server>]

	Description:
		This program illustrates how to manipulate and change a rich text
		item within a note in the specified database.  It edits the rich
		text in an item named "rich_text" in all documents in the view named
		"RichTextView" in the specified database.

****************************************************************************/


#include <lncppapi.h>
#include <iostream.h>

#if defined(MAC)
	// These headers are only needed for Macintosh applications
#include <Types.h>
#include <Quickdraw.h>
#define thePort qd.thePort
#include <Dialogs.h>
#include <Menus.h>
#include <Windows.h>
#include <Fonts.h>
#include <Memory.h>
#include <stdio.h>
#endif

#define ERR_BUF_SIZE 512

int main(int argc, char *argv[])
{
	char *				DbFilename;
	char *				DbServer = NULL;
	LNNotesSession		Session;
	LNDatabase			Db;
	LNDocument			Doc; 
	LNRichText			BodyItem; 
	LNRTCursor			Cursor;
	LNINT					i, Count = 0;
	LNDocumentArray 	DocArray;

#if defined MAC
		// On the Macintosh, we need to prompt for parameters
		// since they are not being passed in on the command line

	char 			fileBuffer[MAXPATH];
	char			serverBuffer[MAXPATH];
	
	// Initialize things for the Macintosh
	InitGraf(&thePort); 
	InitFonts();
    InitWindows(); 
    InitDialogs(0);
    SetApplLimit(GetApplLimit()-8192); 
    MaxApplZone();
    MoreMasters(); 
    MoreMasters(); 
    MoreMasters();	
    
   
    DbFilename = fileBuffer;
	DbServer = serverBuffer;
	
	// Prompt for parameters since they are not being passed in on the command line
	cout << endl << "Enter database filename: " << flush;
    gets(DbFilename);
    cout << "Enter server name:  " << flush;
    gets(DbServer);
#else
		// On anything other than the Macintosh, the parameters
		// are entered on the command line

	// Check the command line.
	if (argc < 2 || argc > 3) 
	{
		cout << "\nUsage:\n\t" << argv[0]
			<< " <filename> [<server>] \n"
			<< endl;
		return(1); 
	}

	// Get info from command line.
	DbFilename = argv[1];
	
	if (argc == 3)
		DbServer = argv[2];
#endif

	// Initialize the C++ API.
	if (Session.Init(argc, argv))
	{
		cout << "\nUnable to initialize the API" << endl;
		return(2);
	}
		
	// Make the error handler throw all errors encountered during execution.
	LNSetThrowAllErrors(TRUE);

	try 
	{
		// Get the specified database.
		Session.GetDatabase(DbFilename, &Db, DbServer);

		// Open it.
		Db.Open();

		// Get all the documents in the database.
		Db.GetDocuments(&DocArray);

		// How many documents do we have?
		Count = DocArray.GetCount();

		// Loop through each document in the array...
		for (i=0; i<Count; i++) 
		{
			// Get the current document.
		  	Doc = DocArray[i];

			// Open the document.
			Doc.Open();

			// Get the item named "Body".
			Doc.GetItem("rich_text", &BodyItem);   

			// Get a cursor pointing at the first element in the richtext.
			BodyItem.GetCursor(&Cursor);

			// Find the first stylized text in the richtext.
			Cursor.GotoFirst(LNRTTYPE_STYLIZED_TEXT);

			// Insert some text at the beginning of the stylized text.
			BodyItem.Insert("** Rich text sample insert #1 ** ", &Cursor);

			// The cursor is now pointing at the first character after "Not Categorized data "
			// Increment the cursor one more character.
			Cursor++;

			// Insert some more text.
			BodyItem.Insert(" ** Insert #2 ** ", &Cursor);

			// Append some text to the end of the richtext field.
			BodyItem << " ** Insert #3:  End of RichText data field**";

			// Update the document (and write the BodyItem to the database).
			Doc.Save();				 

			// Close the document, free item memory.
			Doc.Close();					 

		}
	
	}

	// Error handler.  If an error occurred, then get the text of the error
	// message and display it.
	catch (LNSTATUS lnerror)
	{
		char ErrorBuf[ERR_BUF_SIZE];
		ErrorBuf[0] = '\0';
		LNGetErrorMessage(lnerror, ErrorBuf, ERR_BUF_SIZE);
		cout << "Error: " << ErrorBuf << endl;
	}
		
	// Close the database, free document memory.
	Db.Close(); 
		
	// Terminate the API.
	Session.Term();
	
	// All done.
	return(0);
}
