
/* PUBLIC error messages returned by Router library routines,
	which may be returned to programs other than the Router itself. */

#ifndef ROUTER_ERR_DEFS
#define ROUTER_ERR_DEFS

#define	ERR_ROUTER_UNKNOWN			(PKG_ROUTER+1)
	errortext(ERR_ROUTER_UNKNOWN,	"*** UNKNOWN ROUTER ERROR ***")
#define ERR_ROUTER_NOTUNIQUE		(PKG_ROUTER+4)
	errortext(ERR_ROUTER_NOTUNIQUE,	"Recipient user name %a not unique.  Several matches found in Name & Address Book.")
#define ERR_ROUTER_NOSUCHUSER		(PKG_ROUTER+5)
	errortext(ERR_ROUTER_NOSUCHUSER,"User %a not listed in public Name & Address Book")
#define ERR_ROUTER_NOMAILFILE		(PKG_ROUTER+6)
	errortext(ERR_ROUTER_NOMAILFILE, "Recipient's Name & Address Book entry does not specify a mail file")
#define ERR_ROUTER_NEWMAIL			(PKG_ROUTER+7)
	errortext(ERR_ROUTER_NEWMAIL, "New mail has been delivered to you!")
#define ERR_ROUTER_NOROUTETOSERVERFROM (PKG_ROUTER+8)
	errortext(ERR_ROUTER_NOROUTETOSERVERFROM, "No route found to server %a from server %a.  Check Server and Connection documents in Name & Address Book.")
#define ERR_ROUTER_NOROUTETODOMAINFROM (PKG_ROUTER+9)
	errortext(ERR_ROUTER_NOROUTETODOMAINFROM, "No route found to domain %s from server %a.  Check Server, Connection and Domain documents in Name & Address Book.")
#define ERR_ROUTER_NOROUTETODOMAINVIA (PKG_ROUTER+10)
	errortext(ERR_ROUTER_NOROUTETODOMAINVIA, "No route found to domain %s from server %a via server %a.  Check Server, Connection and Domain documents in Name & Address Book.")
#define ERR_ROUTER_DELIVERY_FILE	(PKG_ROUTER+11)
	errortext(ERR_ROUTER_DELIVERY_FILE, "Error delivering to %a %p; %e")
#define ERR_ROUTER_TRANSFER_FILE	(PKG_ROUTER+12)
	errortext(ERR_ROUTER_TRANSFER_FILE, "Error transferring to %p; %e")
#define ERR_ROUTER_NOGROUP			(PKG_ROUTER+13)
	errortext(ERR_ROUTER_NOGROUP, 	"Unsupported use of group name; Cannot send to a Group @ Domain nor auto-forward to a Group")
#define ERR_ROUTER_ROUTING_LOOP		(PKG_ROUTER+14)
	errortext(ERR_ROUTER_ROUTING_LOOP, 	"Maximum hop count exceeded.  Message probably in a routing loop.")
#define ERR_ROUTER_ACCESS_DENIED 	(PKG_ROUTER+15)
	errortext(ERR_ROUTER_ACCESS_DENIED, "Your Domain does not have access to route messages to the specified domain.")
#define ERR_ROUTER_MESSAGE_QUEUE 	(PKG_ROUTER+16)
	errortext(ERR_ROUTER_MESSAGE_QUEUE, "Unable to allocate mail message queue entry.")
#define ERR_ROUTER_MSGQ_POOLFULL 	(PKG_ROUTER+17)
	errortext(ERR_ROUTER_MSGQ_POOLFULL, "Insufficient memory - Router message queue is full.")
#define ERR_ROUTER_TRANSFER_Q_POOLFULL 	(PKG_ROUTER+18)
	errortext(ERR_ROUTER_TRANSFER_Q_POOLFULL, "Insufficient memory - Router transfer queue is full.")
#define ERR_ROUTER_TOO_MANY_RECIPS 	(PKG_ROUTER+19)
	errortext(ERR_ROUTER_TOO_MANY_RECIPS, "Message contains too many recipients (over 4 megabytes).")
#define ERR_ROUTER_LIST_LOOP		(PKG_ROUTER+20)
	errortext(ERR_ROUTER_LIST_LOOP,	"Groups cannot be nested more than 20 levels deep.")
#define ERR_ROUTER_BILLING_NOMEM	(PKG_ROUTER+21)
	errortext(ERR_ROUTER_BILLING_NOMEM, "Billing record not written. Insufficient memory.")  
#define STR_ROUTER_MSGSIZE_FORMULA 		(PKG_ROUTER+22)
	stringtext(STR_ROUTER_MSGSIZE_FORMULA,	"default MAIL_MSGSIZE:=@doclength;@all")
#define ERR_ROUTER_DELIVER_LOOP		(PKG_ROUTER+23)
	errortext(ERR_ROUTER_DELIVER_LOOP, 	"Maximum forwarding loop count exceeded.  Message probably in a forwarding loop. Examine Forwarding Address of intended recipient in Address Book.")
#define ERR_ROUTER_NOROUTETODOMAIN		(PKG_ROUTER+24)
	errortext(ERR_ROUTER_NOROUTETODOMAIN,"No route found to domain %s.  Check Server, Connection and Domain documents in Name & Address Book.")
#define ERR_ROUTER_NOROUTETOSERVER		(PKG_ROUTER+25)
	errortext(ERR_ROUTER_NOROUTETOSERVER,"No route found to server %a.  Check Server and Connection documents in Name & Address Book.")
#define ERR_ROUTER_NOLOCALSERVER		(PKG_ROUTER+26)
	errortext(ERR_ROUTER_NOLOCALSERVER,	"No Server entry in Address Book for local server.")
#define ERR_ROUTER_SYMBOL_TABLE_FULL 	(PKG_ROUTER+27)
	errortext(ERR_ROUTER_SYMBOL_TABLE_FULL, "Insufficient memory - Router unable to allocate a new symbol table.")
#define ERR_ROUTER_SYMBOL_BUCKET_FULL 	(PKG_ROUTER+28)
	errortext(ERR_ROUTER_SYMBOL_BUCKET_FULL, "Insufficient memory - Router unable to allocate a new symbol table bucket.")
#define ERR_ROUTER_TOOMANYCONN			(PKG_ROUTER+29)
	errortext(ERR_ROUTER_TOOMANYCONN,	"Too many Connections")
#define ERR_ROUTER_TOOMANYSERVERS		(PKG_ROUTER+30)
	errortext(ERR_ROUTER_TOOMANYSERVERS,"Too many Servers")
#define ERR_ROUTER_TOOMANYDOMAINS		(PKG_ROUTER+31)
	errortext(ERR_ROUTER_TOOMANYDOMAINS,"Too many Domains")
#define ERR_ROUTER_SYMBOL_TASKS_FULL	(PKG_ROUTER+32)
	errortext(ERR_ROUTER_SYMBOL_TASKS_FULL,"Insufficient memory - Router unable to allocate a new symbol for mailbox task.")
#define ERR_ROUTER_TABLE_MEM_ERROR	 	(PKG_ROUTER+33)
	errortext(ERR_ROUTER_TABLE_MEM_ERROR, "Insufficient memory - Router unable to allocate routing tables.")
#define ERR_ROUTER_DOMAIN_NAMESPACE	 	(PKG_ROUTER+34)
	errortext(ERR_ROUTER_DOMAIN_NAMESPACE, "Unable to add namespace $Domains to Indexer's queue.")
#define ERR_ROUTER_CONNECTION_NAMESPACE	 	(PKG_ROUTER+35)
	errortext(ERR_ROUTER_CONNECTION_NAMESPACE, "Unable to add namespace $Connections to Indexer's queue.")
#define ERR_ROUTER_SERVER_NAMESPACE	 	(PKG_ROUTER+36)
	errortext(ERR_ROUTER_SERVER_NAMESPACE, "Unable to add namespace $Servers to Indexer's queue.")
#define ERR_ROUTER_TOOMANYADJDOMAINS		(PKG_ROUTER+37)
	errortext(ERR_ROUTER_TOOMANYADJDOMAINS,	"Router: Too many Adjacent Domains")
#define ERR_ROUTER_FIND_VIEW_ERR			(PKG_ROUTER+38)
	errortext(ERR_ROUTER_FIND_VIEW_ERR,	"Router: Unable to find view in Address Book")
#define ERR_ROUTER_OPEN_VIEW_ERR			(PKG_ROUTER+39)
	errortext(ERR_ROUTER_OPEN_VIEW_ERR,	"Router: Unable to open view in Address Book")

/* NOTE:	PKG_ROUTER+175 is the LAST code available for this file.  See */
/* globerr.h for dependency which restricts this string ID space. */

#endif


