#ifdef __cplusplus
extern "C" {
#endif


/* Network Package Public Definitions */

#ifndef NET_DEFS
#define NET_DEFS


/*  Option flags for Network Routines  */

/* Options for NetSend:  */

#define NETOPT_SEND_NOW				0x0001	/*  Send now (do not buffer) */
#define NETOPT_FLUSH				0x0008	/*  Flush remaining receive data */

/* Options for NetReceive: */

#define NETOPT_WAIT_FOR_SOME_DATA	0x0001	/*  Wait for some data */
#define NETOPT_WAIT_FOR_ALL_DATA	0x0002	/*  Wait for all data */
#define NETOPT_PEEK_AT_DATA			0x0004	/*  Peek at data */

/*  Options for NetSetSessionMode: */

#define NETOPT_STREAM_MODE			0x0001	/*  Stream mode */


/*  Session Id  */

typedef struct
	{
	WORD Index;						/* Index */
	WORD SeqNo;						/* Sequence number */
	}
SESSIONID;


/*	Function prototypes */

STATUS LNPUBLIC NetLink (char far *pRemoteSystem, char far *pPortName, 
						   char far *pConnectInfo, void far *ReservedMustBeNull, 
						   SESSIONID far *pRetSessionId);
STATUS LNPUBLIC NetSend (SESSIONID SessionID, void far *Buffer, WORD Length, WORD Options);
STATUS LNPUBLIC NetReceive (SESSIONID SessionID, void far *retBuffer, WORD Length, WORD Options, WORD far *retSize);
STATUS LNPUBLIC NetSetSessionMode (SESSIONID SessionID, WORD Options,
							DWORD SendTimeout, DWORD ReceiveTimeout,
							WORD NumBuffers, WORD BufferSize);
void LNPUBLIC NetCloseSession (SESSIONID SessionID);

#endif
#ifdef __cplusplus
}
#endif
