//===========================================================================
//
// Module:		LNVIEW.HPP
//
// Description:
//
//		Class definitions and data for the view and folder classes.
//
//===========================================================================
//
// Copyright (c) 1996 Lotus Development Corporation. All rights reserved.
// This software is subject to the Lotus Software Agreement, Restricted
// Rights for U.S. government users, and applicable export regulations.
//
//===========================================================================

#ifndef LNVIEW_HPP
#define LNVIEW_HPP


// LNNAVIGATION: navigation targets for the LNVFNavigator::Goto function.

enum LNNAVIGATION
{
	LNNAVIGATION_CHILD = 0,
	LNNAVIGATION_FIRST,
	LNNAVIGATION_FIRST_SIBLING,
	LNNAVIGATION_LAST,
	LNNAVIGATION_LAST_SIBLING,
	LNNAVIGATION_MAIN,
	LNNAVIGATION_NEXT,
	LNNAVIGATION_NEXT_CATEGORY,
	LNNAVIGATION_NEXT_MAIN,
	LNNAVIGATION_NEXT_NON_CATEGORY,
	LNNAVIGATION_NEXT_PARENT,
	LNNAVIGATION_NEXT_SIBLING,
	LNNAVIGATION_NEXT_UNREAD,
	LNNAVIGATION_NEXT_UNREAD_OR_MAIN,
	LNNAVIGATION_PARENT,
	LNNAVIGATION_PREV,
	LNNAVIGATION_PREV_CATEGORY,
	LNNAVIGATION_PREV_MAIN,
	LNNAVIGATION_PREV_NON_CATEGORY,
	LNNAVIGATION_PREV_PARENT,
	LNNAVIGATION_PREV_SIBLING,
	LNNAVIGATION_PREV_UNREAD,
	LNNAVIGATION_PREV_UNREAD_OR_MAIN,
	LNNAVIGATION_COUNT
};

// LNVFCOMPARISON: comparison for LNViewFolder and LNVFNavigator Find function

enum LNVFCOMPARISON
{
	LNVFCOMPARISON_EQ		= FIND_FIRST_EQUAL,
	LNVFCOMPARISON_LAST_EQ	= FIND_LAST_EQUAL,
	LNVFCOMPARISON_LT		= FIND_LESS_THAN,
	LNVFCOMPARISON_GT		= FIND_GREATER_THAN
};

// LNVFNTRYTYPE: view/folder entry type

enum LNVFENTRYTYPE
{
	LNVFENTRYTYPE_CATEGORY,
	LNVFENTRYTYPE_MAIN,
	LNVFENTRYTYPE_RESPONSE,
	LNVFENTRYTYPE_TOTAL
};

// LNVFOPENFLAGS: flags used to open a view/folder (collection)

typedef WORD LNVFOPENFLAGS;

#define LNVFOPENFLAGS_DEFAULT			0
#define LNVFOPENFLAGS_REBUILD_INDEX		OPEN_REBUILD_INDEX
#define LNVFOPENFLAGS_NO_UPDATE			OPEN_NOUPDATE
#define LNVFOPENFLAGS_NO_CREATE			OPEN_DO_NOT_CREATE

//---------------------------------------------------------------------------
// 	Class name:	LNViewFolder
//
//	Description:
//
//	LNViewFolder represents a Notes database view or folder, and is the base
//	class for the LNView and LNFolder classes.
//---------------------------------------------------------------------------

class LNViewFolder : public LNNote
{
friend class LNDatabase;
friend class LNViewFolderArray;

public:
	LNViewFolder() {}
	LNViewFolder( const LNViewFolder &viewfolder ) : LNNote(viewfolder) {}
	LNViewFolder( const LNNote &other );
	~LNViewFolder() {}
	LNViewFolder & operator=( const LNViewFolder &viewfolder )
		{ LNNote::operator=(viewfolder); return *this; }
	LNViewFolder & operator=( const LNNote &other );

	LNCLASSID GetClassID() const { return LNCLASS_LNVIEWFOLDER; }

	LNSTATUS Close() const;
	LNSTATUS FTSearch( const LNString &query, LNVFNavigator *results ) const;
	LNSTATUS FTSearch
		( const LNString &query, LNVFNavigator *results,
		  const LNFTSearchOptions &options ) const;
	LNSTATUS FTSearch
		( const LNString &query, LNVFNavigator *results,
		  const LNFTSearchOptions &options, const LNVFNavigator &input ) const;
	LNString GetAlias() const;
	LNSTATUS GetChildren( LNVFNavigator *navigator ) const
		{ return GetDescendants(navigator, 1); }
	LNINT GetColumnCount() const;
	LNString GetColumnTitle( LNINT col ) const;
	LNSTATUS GetDescendants( LNVFNavigator *navigator ) const;
	LNSTATUS GetDescendants( LNVFNavigator *navigator, LNINT levels ) const;
	LNSTATUS GetEntries( LNVFNavigator *navigator ) const;
	LNDatabase GetEntryDatabase() const;
	LNString GetName() const;
	LNSTATUS Open( LNVFOPENFLAGS flags = LNVFOPENFLAGS_DEFAULT );
	LNSTATUS Open( LNVFOPENFLAGS flags, const LNDatabase &db );
	LNSTATUS Open
		( LNVFOPENFLAGS flags, const LNString &pathname,
		  const LNString &server = "" );
	LNSTATUS Save( LNNOTESAVEFLAGS options = LNNOTESAVEFLAGS_DEFAULT ) const;

	// LNVFNavigator functions:

	LNVFEntry operator[]( LNINT n ) const;
	LNSTATUS DeleteEntries( LNVFEntry *entry, LNBOOL deletetree = FALSE ) const;
	LNSTATUS DeleteEntries
		( const LNVFPosition &position, LNBOOL deletetree = FALSE ) const;
	LNSTATUS Find
		( const LNString &key, LNVFEntry *entry = 0, LNINT *count = 0 ) const;
	LNSTATUS Find
		( const LNString &key, const LNVFFindOptions &options,
		  LNVFEntry *entry = 0, LNINT *count = 0 ) const;
	LNSTATUS Find
		( const LNDatetime &key, LNVFEntry *entry = 0, LNINT *count = 0 ) const;
	LNSTATUS Find
		( const LNDatetime &key, const LNVFFindOptions &options,
		  LNVFEntry *entry = 0, LNINT *count = 0 ) const;
	LNSTATUS Find
		( const LNNUMBER &key, LNVFEntry *entry = 0, LNINT *count = 0 ) const;
	LNSTATUS Find
		( const LNNUMBER &key, const LNVFFindOptions &options,
		  LNVFEntry *entry = 0, LNINT *count = 0 ) const;
	LNSTATUS Find
		( const LNVFFindKeys &keys, LNVFEntry *entry = 0, LNINT *count = 0 ) const;
	LNSTATUS Find
		( const LNVFFindKeys &keys, const LNVFFindOptions &options,
		  LNVFEntry *entry = 0, LNINT *count = 0 ) const;
	LNSTATUS GetEntry( LNVFEntry *entry ) const;
	LNSTATUS GetEntry( LNVFEntry *entry, const LNVFPosition &position ) const;
	LNINT GetEntryCount() const;
	LNSTATUS GetPosition( LNVFPosition *position ) const;
	LNSTATUS GotoChild( LNVFEntry *entry = 0 ) const
		{ return Goto(LNNAVIGATION_CHILD, entry); }
	LNSTATUS GotoFirst( LNVFEntry *entry = 0 ) const
		{ return Goto(LNNAVIGATION_FIRST, entry); }
	LNSTATUS GotoFirstSibling( LNVFEntry *entry = 0 ) const
		{ return Goto(LNNAVIGATION_FIRST_SIBLING, entry); }
	LNSTATUS GotoLast( LNVFEntry *entry = 0 ) const
		{ return Goto(LNNAVIGATION_LAST, entry); }
	LNSTATUS GotoLastSibling( LNVFEntry *entry = 0 ) const
		{ return Goto(LNNAVIGATION_LAST_SIBLING, entry); }
	LNSTATUS GotoMain( LNVFEntry *entry = 0 ) const
		{ return Goto(LNNAVIGATION_MAIN, entry); }
	LNSTATUS GotoNext( LNVFEntry *entry = 0 ) const
		{ return Goto(LNNAVIGATION_NEXT, entry); }
	LNSTATUS GotoNextCategory( LNVFEntry *entry = 0 ) const
		{ return Goto(LNNAVIGATION_NEXT_CATEGORY, entry); }
	LNSTATUS GotoNextMain( LNVFEntry *entry = 0 ) const
		{ return Goto(LNNAVIGATION_NEXT_MAIN, entry); }
	LNSTATUS GotoNextNonCategory( LNVFEntry *entry = 0 ) const
		{ return Goto(LNNAVIGATION_NEXT_NON_CATEGORY, entry); }
	LNSTATUS GotoNextParent( LNVFEntry *entry = 0 ) const
		{ return Goto(LNNAVIGATION_NEXT_PARENT, entry); }
	LNSTATUS GotoNextSibling( LNVFEntry *entry = 0 ) const
		{ return Goto(LNNAVIGATION_NEXT_SIBLING, entry); }
	LNSTATUS GotoParent( LNVFEntry *entry = 0 ) const
		{ return Goto(LNNAVIGATION_PARENT, entry); }
	LNSTATUS GotoPrevious( LNVFEntry *entry = 0 ) const
		{ return Goto(LNNAVIGATION_PREV, entry); }
	LNSTATUS GotoPreviousCategory( LNVFEntry *entry = 0 ) const
		{ return Goto(LNNAVIGATION_PREV_CATEGORY, entry); }
	LNSTATUS GotoPreviousMain( LNVFEntry *entry = 0 ) const
		{ return Goto(LNNAVIGATION_PREV_MAIN, entry); }
	LNSTATUS GotoPreviousNonCategory( LNVFEntry *entry = 0 ) const
		{ return Goto(LNNAVIGATION_PREV_NON_CATEGORY, entry); }
	LNSTATUS GotoPreviousParent( LNVFEntry *entry = 0 ) const
		{ return Goto(LNNAVIGATION_PREV_PARENT, entry); }
	LNSTATUS GotoPreviousSibling( LNVFEntry *entry = 0 ) const
		{ return Goto(LNNAVIGATION_PREV_SIBLING, entry); }
	LNBOOL IsCategorized() const;
	LNSTATUS Refresh() const;
	LNSTATUS ResetPosition() const;
	LNSTATUS SetPosition( const LNVFPosition &position ) const;
	   
private:
	LNViewFolder( LNDatabaseBody *db, NOTEID id ) : LNNote(db, id) {}
	LNViewFolder & operator=( LNViewFolderBody *viewfolder )
		{ LNNote::operator=((LNNoteBody *) viewfolder); return *this; }
	LNSTATUS CreateViewFolderBody();
	LNViewFolderBody * GetViewFolderBody() const
		{ return (LNViewFolderBody *) Body; }
	LNSTATUS Goto( LNNAVIGATION where, LNVFEntry *entry ) const;
};

//---------------------------------------------------------------------------
// 	Class name:	LNVFEntry
//
//	Description:
//	
//	LNVFEntry represents an entry (row) in a database view or folder, and
//	provides access to both the corresponding document and the data items
//	displayed in the view or folder columns.
//---------------------------------------------------------------------------

class LNVFEntry : public LNSmartPtr
{

public:
	LNVFEntry() {}
	LNVFEntry( const LNVFEntry &entry ) : LNSmartPtr(entry) {}
	~LNVFEntry() {}
	LNVFEntry & operator=( const LNVFEntry &entry )
		{ return (LNVFEntry &) LNSmartPtr::operator=(entry); }
	LNCLASSID GetClassID() const { return LNCLASS_LNVFENTRY; }
	
	LNItem operator[]( LNINT n ) const;
	LNItem operator[]( const LNString &colname ) const;
	LNINT GetChildCount() const;
	LNINT GetDescendantCount() const;
	LNSTATUS GetDocument( LNDocument *document ) const;
	LNINT GetFTSearchScore() const;
	LNINT GetIndentLevels() const;
	NOTEID GetNoteID() const;
	LNSTATUS GetPosition( LNVFPosition *position ) const;
	LNINT GetSiblingCount() const;
	LNVFENTRYTYPE GetType() const;
	LNSTATUS GetViewFolder( LNViewFolder *viewfolder ) const;
	LNBOOL IsCategory() const;
	LNBOOL IsMainTopic() const;
	LNBOOL IsResponse() const;
	LNBOOL IsTotal() const;

private:
	LNVFEntry( LNVFEntryBody *entry ) : LNSmartPtr((LNBody *) entry) {}
	LNVFEntry & operator=( LNVFEntryBody *entry )
		{ return (LNVFEntry &) LNSmartPtr::operator=((LNBody *) entry); }
	LNVFEntryBody * GetVFEntryBody() const
		{ return (LNVFEntryBody *) Body; }
};

//---------------------------------------------------------------------------
// 	Class name:	LNVFFindKey
//
//	Description:
//	
//	LNVFFindKey represents one of the search keys stored in an LNVFFindKeys
//	object.
//---------------------------------------------------------------------------

class LNVFFindKey : public LNNotesClass
{

public:
	~LNVFFindKey();
	operator LNString() const;
	operator LNDatetime() const;
	operator LNNUMBER() const;
	LNCLASSID GetClassID() const { return LNCLASS_LNVFFINDKEY; }

private:
	LNVFFindKey( const LNVFFindKey &key );
	LNVFFindKey( const LNString &key, LNSTATUS *error );
	LNVFFindKey( const LNDatetime &key, LNSTATUS *error );
	LNVFFindKey( const LNNUMBER &key, LNSTATUS *error );
	LNSTATUS Assign( const void *value, WORD size, WORD type );
	const void * GetValue() const { return Value; }
	WORD GetValueSize() const { return ValueSize; }

	// the following 2 functions are disabled

	LNVFFindKey();
	LNVFFindKey & operator=( const LNVFFindKey &key );

	// data

	char *Value;
	WORD ValueSize;
};

//---------------------------------------------------------------------------
// 	Class name:	LNVFFindKeys
//
//	Description:
//	
//	LNVFFindKeys represents search keys used by the LNViewFolder and
//	LNVFNavigator Find functions.
//---------------------------------------------------------------------------

class LNVFFindKeys : public LNNotesClass
{

public:
	LNVFFindKeys() { ItemTable = 0; }
	LNVFFindKeys( const LNVFFindKeys &keys ) : LNNotesClass(keys)
		{ Copy(keys); }
	~LNVFFindKeys() { Free(); }
	LNVFFindKeys & operator=( const LNVFFindKeys &keys );
	LNVFFindKey & operator[]( LNINT n );
	LNSTATUS Append( const LNString &key );
	LNSTATUS Append( const LNDatetime &key );
	LNSTATUS Append( const LNNUMBER &key );
	void DeleteAllKeys() { Keys.DeleteAllObjects(); }
	LNCLASSID GetClassID() const { return LNCLASS_LNVFFINDKEYS; }
	LNINT GetCount() const { return Keys.GetCount(); }

private:
	LNSTATUS Append( LNVFFindKey *key );
	void Copy( const LNVFFindKeys &keys );
	void Free();
	const ITEM_TABLE * GetItemTable() const;

	char *ItemTable;
	LNObjectList Keys;
};

//---------------------------------------------------------------------------
// 	Class name:	LNVFFindOptions
//
//	Description:
//	
//	LNVFFindOptions represents search options used by the LNViewFolder and
//	LNVFNavigator Find functions.
//---------------------------------------------------------------------------

// default NIFFind... search flags (for internal use only)

const WORD LNVFFINDFLAGS = FIND_PARTIAL | FIND_CASE_INSENSITIVE |
						   FIND_ACCENT_INSENSITIVE | FIND_FIRST_EQUAL;

class LNVFFindOptions : public LNNotesClass
{

public:
	LNVFFindOptions() { Flags = LNVFFINDFLAGS; }
	LNVFFindOptions( const LNVFFindOptions &options )
		: LNNotesClass(options) { Flags = options.Flags; }
	~LNVFFindOptions() {}
	LNVFFindOptions & operator=( const LNVFFindOptions &options );
	LNCLASSID GetClassID() const { return LNCLASS_LNVFFINDOPTIONS; }
	LNVFCOMPARISON GetComparison() const
		{ return (LNVFCOMPARISON) (Flags & FIND_COMPARE_MASK); }
	LNBOOL GetMatchAccent() const
		{ return !(Flags & FIND_ACCENT_INSENSITIVE); }
	LNBOOL GetMatchCase() const
		{ return !(Flags & FIND_CASE_INSENSITIVE); }
	LNBOOL GetMatchWholeWord() const
		{ return !(Flags & FIND_PARTIAL); }
	LNBOOL GetUpdateIfNotFound() const
		{ return (Flags & FIND_UPDATE_IF_NOT_FOUND) != 0; }
	LNSTATUS SetComparison( LNVFCOMPARISON comparison );
	void SetMatchAccent( LNBOOL flag );
	void SetMatchCase( LNBOOL flag );
	void SetMatchWholeWord( LNBOOL flag );
	void SetUpdateIfNotFound( LNBOOL flag );

private:
	WORD GetFlags() const { return Flags; }

	WORD Flags;
};

//---------------------------------------------------------------------------
// 	Class name:	LNVFPosition
//
//	Description:
//	
//	LNVFPosition identifies the position of an entry in a view or folder.
//---------------------------------------------------------------------------

class LNVFPosition : public LNNotesClass
{

public:
	LNVFPosition();
	LNVFPosition( const LNVFPosition &position );
	~LNVFPosition();
	LNVFPosition & operator=( const LNVFPosition &position );
	LNBOOL operator==( const LNVFPosition &position ) const;
	LNBOOL operator<( const LNVFPosition &position ) const;
	LNBOOL operator>( const LNVFPosition &position ) const;
	LNBOOL operator!=( const LNVFPosition &position ) const
		{ return !operator==(position); }
	LNBOOL operator<=( const LNVFPosition &position ) const
		{ return !operator>(position); }
	LNBOOL operator>=( const LNVFPosition &position ) const
		{ return !operator<(position); }
	LNCLASSID GetClassID() const { return LNCLASS_LNVFPOSITION; }
	LNString GetDocNumber( char separator = '.' ) const;
	LNString GetDocNumber( const LNString &separator ) const;
	void Reset();

private:
	LNVFPosition & operator=( const COLLECTIONPOSITION *collpos );
	COLLECTIONPOSITION * GetCollectionPosition() const { return Position; }

	COLLECTIONPOSITION *Position;
};

//---------------------------------------------------------------------------
// 	Class name:	LNVFNavigator
//
//	Description:
//	
//	LNVFNavigator provides functions to navigate through a view or folder.
//---------------------------------------------------------------------------

class LNVFNavigator : public LNSmartPtr
{

public:
	LNVFNavigator();
	LNVFNavigator( const LNVFNavigator &navigator );
	~LNVFNavigator() {}
	LNVFNavigator & operator=( const LNVFNavigator &navigator );
	LNCLASSID GetClassID() const { return LNCLASS_LNVFNAVIGATOR; }
	LNSTATUS GetPosition( LNVFPosition *position ) const;
	LNSTATUS ResetPosition();
	LNSTATUS SetPosition( const LNVFPosition &position );

	LNVFEntry operator[]( LNINT n );
	LNSTATUS DeleteEntries( LNVFEntry *entry, LNBOOL deletetree = FALSE ) const;
	LNSTATUS DeleteEntries
		( const LNVFPosition &position, LNBOOL deletetree = FALSE ) const;
	LNSTATUS Find( const LNString &key, LNVFEntry *entry = 0, LNINT *count = 0 );
	LNSTATUS Find
		( const LNString &key, const LNVFFindOptions &options,
		  LNVFEntry *entry = 0, LNINT *count = 0 );
	LNSTATUS Find
		( const LNDatetime &key, LNVFEntry *entry = 0, LNINT *count = 0 );
	LNSTATUS Find
		( const LNDatetime &key, const LNVFFindOptions &options,
		  LNVFEntry *entry = 0, LNINT *count = 0 );
	LNSTATUS Find( const LNNUMBER &key, LNVFEntry *entry = 0, LNINT *count = 0 );
	LNSTATUS Find
		( const LNNUMBER &key, const LNVFFindOptions &options,
		  LNVFEntry *entry = 0, LNINT *count = 0 );
	LNSTATUS Find
		( const LNVFFindKeys &keys, LNVFEntry *entry = 0, LNINT *count = 0 );
	LNSTATUS Find
		( const LNVFFindKeys &keys, const LNVFFindOptions &options,
		  LNVFEntry *entry = 0, LNINT *count = 0 );
	LNDatabase GetEntryDatabase() const;
	LNSTATUS GetEntry( LNVFEntry *entry );
	LNSTATUS GetEntry( LNVFEntry *entry, const LNVFPosition &position );
	LNINT GetEntryCount() const;
	LNSTATUS GetViewFolder( LNViewFolder *viewfolder ) const;
	LNSTATUS GotoChild( LNVFEntry *entry = 0 )
		{ return Goto(LNNAVIGATION_CHILD, entry); }
	LNSTATUS GotoFirst( LNVFEntry *entry = 0 )
		{ return Goto(LNNAVIGATION_FIRST, entry); }
	LNSTATUS GotoFirstSibling( LNVFEntry *entry = 0 )
		{ return Goto(LNNAVIGATION_FIRST_SIBLING, entry); }
	LNSTATUS GotoLast( LNVFEntry *entry = 0 )
		{ return Goto(LNNAVIGATION_LAST, entry); }
	LNSTATUS GotoLastSibling( LNVFEntry *entry = 0 )
		{ return Goto(LNNAVIGATION_LAST_SIBLING, entry); }
	LNSTATUS GotoMain( LNVFEntry *entry = 0 )
		{ return Goto(LNNAVIGATION_MAIN, entry); }
	LNSTATUS GotoNext( LNVFEntry *entry = 0 )
		{ return Goto(LNNAVIGATION_NEXT, entry); }
	LNSTATUS GotoNextCategory( LNVFEntry *entry = 0 )
		{ return Goto(LNNAVIGATION_NEXT_CATEGORY, entry); }
	LNSTATUS GotoNextMain( LNVFEntry *entry = 0 )
		{ return Goto(LNNAVIGATION_NEXT_MAIN, entry); }
	LNSTATUS GotoNextNonCategory( LNVFEntry *entry = 0 )
		{ return Goto(LNNAVIGATION_NEXT_NON_CATEGORY, entry); }
	LNSTATUS GotoNextParent( LNVFEntry *entry = 0 )
		{ return Goto(LNNAVIGATION_NEXT_PARENT, entry); }
	LNSTATUS GotoNextSibling( LNVFEntry *entry = 0 )
		{ return Goto(LNNAVIGATION_NEXT_SIBLING, entry); }
	LNSTATUS GotoParent( LNVFEntry *entry = 0 )
		{ return Goto(LNNAVIGATION_PARENT, entry); }
	LNSTATUS GotoPrevious( LNVFEntry *entry = 0 )
		{ return Goto(LNNAVIGATION_PREV, entry); }
	LNSTATUS GotoPreviousCategory( LNVFEntry *entry = 0 )
		{ return Goto(LNNAVIGATION_PREV_CATEGORY, entry); }
	LNSTATUS GotoPreviousMain( LNVFEntry *entry = 0 )
		{ return Goto(LNNAVIGATION_PREV_MAIN, entry); }
	LNSTATUS GotoPreviousNonCategory( LNVFEntry *entry = 0 )
		{ return Goto(LNNAVIGATION_PREV_NON_CATEGORY, entry); }
	LNSTATUS GotoPreviousParent( LNVFEntry *entry = 0 )
		{ return Goto(LNNAVIGATION_PREV_PARENT, entry); }
	LNSTATUS GotoPreviousSibling( LNVFEntry *entry = 0 )
		{ return Goto(LNNAVIGATION_PREV_SIBLING, entry); }
	LNBOOL IsCategorized() const;
	LNBOOL IsFTSearch() const;
	LNSTATUS Refresh();

private:
	LNVFNavigator & operator=( LNVFNavigatorBody *navigatorbody );
	LNSTATUS Close();
	LNSTATUS Find
		( const LNVFFindKeys *keys, const LNVFFindOptions *options,
		  LNVFEntry *entry, LNINT *count );
	LNSTATUS GetIDTable( HANDLE *idtable ) const;
	LNVFNavigatorBody * GetVFNavigatorBody() const
		{ return (LNVFNavigatorBody *) Body; }
	LNSTATUS Goto( LNNAVIGATION where, LNVFEntry *entry );
	void SetNullBodyError( LNSTATUS error )
		{ NullBodyError = error; }

	LNSTATUS NullBodyError;
	LNVFPosition Position;
};


#endif	//LNVIEW_HPP

