//===========================================================================
//
// Module:		LNVFDES.HPP
//
// Description:
//
//		Class definitions and data for the view and folder design classes.
//
//===========================================================================
//
// Copyright (c) 1996 Lotus Development Corporation. All rights reserved.
// This software is subject to the Lotus Software Agreement, Restricted
// Rights for U.S. government users, and applicable export regulations.
//
//===========================================================================

#ifndef LNVFDES_HPP
#define LNVFDES_HPP

#ifndef LNVIEW_HPP
#include "lnview.hpp"
#endif

#ifndef LNFONT_HPP
#include "lnfont.hpp"
#endif

//-----	Temporary fixes:

typedef LNText LNReaders;

// LNAUTOREFRESH: specifies automatic view refresh options

enum LNAUTOREFRESH
{
	LNAUTOREFRESH_OFF		= 0,
	LNAUTOREFRESH_TOP		= VIEW_TABLE_GOTO_TOP_ON_REFRESH,
	LNAUTOREFRESH_BOTTOM	= VIEW_TABLE_GOTO_BOTTOM_ON_REFRESH,
	LNAUTOREFRESH_CURRENT	= VIEW_TABLE_GOTO_TOP_ON_REFRESH |
							  VIEW_TABLE_GOTO_BOTTOM_ON_REFRESH
};

// LNINDEXDISCARD: specifies when Notes should discard the view/folder index

enum LNINDEXDISCARD
{
	LNINDEXDISC_UNKNOWN,
	LNINDEXDISC_NEVER,
	LNINDEXDISC_EACHUSE,
	LNINDEXDISC_INACTIVEDAYS
};

// LNINDEXUPDATE: specifies when Notes should update the view/folder index

enum LNINDEXUPDATE
{
	LNINDEXUPDATE_MANUAL,
	LNINDEXUPDATE_ONOPEN,
	LNINDEXUPDATE_PERIODIC
};

// LNROWSPACING: spacing between view/folder rows

enum LNROWSPACING
{
	LNROWSPACING_SINGLE	= VIEW_TABLE_SINGLE_SPACE,
	LNROWSPACING_1_25	= VIEW_TABLE_ONE_POINT_25_SPACE,
	LNROWSPACING_1_5	= VIEW_TABLE_ONE_POINT_50_SPACE,
	LNROWSPACING_1_75	= VIEW_TABLE_ONE_POINT_75_SPACE,
	LNROWSPACING_DOUBLE	= VIEW_TABLE_DOUBLE_SPACE
};

// LNUNREADMARKS: specifies how unread marks should be displayed

enum LNUNREADMARKS
{
	LNUNREAD_NONE	= 0,
	LNUNREAD_DOCS	= VIEW_TABLE_FLAG_DISP_UNREADDOCS,
	LNUNREAD_ALL	= VIEW_TABLE_FLAG_DISP_ALLUNREAD
};

// LNVIEWOPENPOSITION: where to position cursor when opening view/folder

enum LNVIEWOPENPOSITION
{
	LNVIEWOPENPOS_LASTOPEN	= 0,
	LNVIEWOPENPOS_TOP		= VIEW_TABLE_GOTO_TOP_ON_OPEN,
	LNVIEWOPENPOS_BOTTOM	= VIEW_TABLE_GOTO_BOTTOM_ON_OPEN
};

// LNVIEWSHARING: view/folder sharing type

enum LNVIEWSHARING
{
	LNVIEWSHARE_UNKNOWN,
	LNVIEWSHARE_SHARED,
	LNVIEWSHARE_PRIVATE,
	LNVIEWSHARE_PRIVFIRST
};

// classes not yet defined

class LNFormACL {};

//---------------------------------------------------------------------------
// 	Class name:	LNVFColumn
//
//	Description:
//	
//	LNVFColumn provides access to column-specific view and folder design
//	attributes. LNVFColumn is a "smart pointer" for LNVFColumnBody, which
//	contains the actual implementation.
//---------------------------------------------------------------------------

class LNVFColumn
{

public:
	LNVFColumn() {}
	~LNVFColumn() {}

private:
	LNVFColumn( LNVFColumnBody *col ) {}
};

//---------------------------------------------------------------------------
// 	Class name:	LNVFDesign
//
//	Description:
//
//	LNVFDesign provides access to general view and folder design attributes,
//	and is the base class for the LNViewDesign and LNFolderDesign classes.
//---------------------------------------------------------------------------

class LNVFDesign : public LNNotesClass
{

public:
	LNVFDesign();
	~LNVFDesign();
	LNVFColumn operator[]( LNINT n );
	LNSTATUS AppendColumns( LNINT count = 1 );
	LNSTATUS DeleteColumns( LNINT n, LNINT count = 1 );
	LNString GetAlias();
	LNCOLOR GetAlternateRowColor();
	LNAUTOREFRESH GetAutoRefreshOption();
	LNCOLOR GetBackgroundColor();
	LNCLASSID GetClassID() const { return LNCLASS_LNVFDESIGN; }
	LNBOOL GetCollapseCategories();
	LNINT GetColumnCount();
	LNINT GetColumnHeadingLineCount();
	LNSTATUS GetColumnHeadingStyle( LNFontStyle *style );
	LNSTATUS GetColumnTotalsStyle( LNFontStyle *style );
	LNString GetComment();
	LNSTATUS GetFormFormula( LNFormula *formula );
	LNBOOL GetHideColumnHeadings();
	LNBOOL GetHideLeftMargin();
	LNINT GetIndexDiscardDays();
	LNINDEXDISCARD GetIndexDiscardSetting();
	LNINT GetIndexUpdateSeconds();
	LNINDEXUPDATE GetIndexUpdateSetting();
	LNBOOL GetIsDefaultView();
	LNString GetName();
	LNSTATUS GetReaders( LNReaders *readers );
	LNINT GetRowLineCount();
	LNROWSPACING GetRowSpacing();
	LNSTATUS GetSelectionFormula( LNFormula *formula );
	LNVIEWSHARING GetSharingType();
	LNBOOL GetShowInViewMenu();
	LNBOOL GetShowReplicationConflicts();
	LNBOOL GetShowResponseHierarchy();
	LNSTATUS GetUnreadStyle( LNFontStyle *style );
	LNUNREADMARKS GetUnreadMarkDisplay();
	LNBOOL GetUseAlternateRowColor();
	LNBOOL GetUseSimpleColumnHeadings();
	LNBOOL GetUseUniqueKeys();
	LNBOOL GetUseVariableLineCount();
	LNINT GetVersion();
	LNVIEWOPENPOSITION GetViewOpenPosition();
	LNSTATUS InsertColumns( LNINT n, LNINT count = 1 );
	LNSTATUS SetAlias( LNString alias );
	LNSTATUS SetAlternateRowColor( LNCOLOR color );
	LNSTATUS SetAutoRefreshOption( LNAUTOREFRESH option );
	LNSTATUS SetBackgroundColor( LNCOLOR color );
	void SetCollapseCategories( LNBOOL flag );
	LNSTATUS SetColumnHeadingLineCount( LNINT count );
	LNSTATUS SetColumnHeadingStyle( LNFontStyle style );
	LNSTATUS SetColumnTotalsStyle( LNFontStyle style );
	LNSTATUS SetComment( LNString comment );
	LNSTATUS SetFormFormula( LNString text );
	LNSTATUS SetFormFormula( LNFormula formula );
	void SetHideColumnHeadings( LNBOOL flag );
	void SetHideLeftMargin( LNBOOL flag );
	LNSTATUS SetIndexDiscardDays( LNINT days );
	LNSTATUS SetIndexDiscardSetting( LNINDEXDISCARD discard );
	LNSTATUS SetIndexUpdateSeconds( LNINT seconds );
	LNSTATUS SetIndexUpdateSetting( LNINDEXUPDATE update );
	void SetIsDefaultView( LNBOOL flag );
	LNSTATUS SetName( LNString name );
	LNSTATUS SetReaders( LNReaders readers );
	LNSTATUS SetRowLineCount( LNINT lines );
	LNSTATUS SetRowSpacing( LNROWSPACING spacing );
	LNSTATUS SetSelectionFormula( LNString text );
	LNSTATUS SetSelectionFormula( LNFormula formula );
	LNSTATUS SetSharingType( LNVIEWSHARING type );
	void SetShowInViewMenu( LNBOOL flag );
	void SetShowReplicationConflicts( LNBOOL flag );
	void SetShowResponseHierarchy( LNBOOL flag );
	LNSTATUS SetUnreadMarkDisplay( LNUNREADMARKS unread );
	LNSTATUS SetUnreadStyle( LNFontStyle style );
	void SetUseAlternateRowColor( LNBOOL flag );
	void SetUseSimpleColumnHeadings( LNBOOL flag );
	void SetUseUniqueKeys( LNBOOL flag );
	void SetUseVariableLineCount( LNBOOL flag );
	LNSTATUS SetViewOpenPosition( LNVIEWOPENPOSITION position );

private:
	LNSTATUS Assign( LNViewFolderBody *view );
	LNSTATUS Assign( LNViewFolderBody *view, LNString *name, LNINT cols =  1 );
	LNSTATUS Close();
	void Defaults();
	void Free();	
	LNSTATUS GetStyle( LNFontStyle *style, FONTID font );
	LNSTATUS InitTableFormat2();
	LNSTATUS InitViewFormat();
	LNSTATUS InitViewFormatColumns( char **bufp, LNINT *bytecount );
	LNBOOL IsDirty();
	void MarkDirty();
	LNSTATUS Save();
	void UnlinkView();

	// the following 2 functions are disabled

	LNVFDesign( const LNVFDesign &design );
	LNVFDesign & operator=( const LNVFDesign &design );

	// data

	LNSortedObjectList Columns;
	WORD Flags;
	LNFormula FormFormula;
	LNFormula FormulaItem;
	LNText Name;
	LNObjectList ObjectList;
	LNReaders Readers;
	LNFormula SelectionFormula;
	LNVIEWSHARING SharingType;
	VIEW_TABLE_FORMAT TableFormat;
	VIEW_TABLE_FORMAT2 TableFormat2;	
	LNViewFolder View;
	LNItem ViewFormat;
};

#endif	//LNVFDES_HPP

