//===========================================================================
//
// Module:		LNTEXT.HPP
//
// Description:	Class library definitions for LNText related classes.
//
//===========================================================================
//
// Copyright (c) 1995 Lotus Development Corporation. All rights reserved.
// This software is subject to the Lotus Software Agreement, Restricted
// Rights for U.S. government users, and applicable export regulations.
//
//===========================================================================
#ifndef LNTEXT_HPP
#define LNTEXT_HPP

//
//	Class definition for LNTextElement.
//
class LNTextElement : public LNNotesClass
{
public:
	LNTextElement( const LNTextElement &other );
	LNTextElement( LNTextBody *textb, LNINT index );

	~LNTextElement();

	LNTextElement& operator=( const LNString &string );
	LNTextElement& operator=( const LNTextElement &textelem );

	operator LNString() const;

	LNCLASSID GetClassID() const {return LNCLASSID_LNTEXTELEMENT;}

private:
	LNTextElement();	// Disabled.

	LNTextBody *Body;
	LNINT Index;	
};

//
//	Class definition for LNText.
//
class LNText : public LNItem
{
public:
	LNText();
	LNText( const LNText &other );
	LNText( const LNItem &other );

	~LNText();

	LNText& operator=( const LNText &other );
	LNText& operator=( const LNItem &other );

	LNText& operator<<( const LNText &text );
	LNText& operator<<( const LNString &string );
	LNText& operator<<( const LNTextElement &textelem );

	LNTextElement operator[]( LNINT n ) const;

	LNSTATUS Append( const LNText &text );
	LNSTATUS Append( const LNString &string );
	LNSTATUS Append( const LNTextElement &textelem );

	LNSTATUS Delete( LNINT n, LNINT count=1 );

	LNSTATUS DeleteAll();

	LNCLASSID GetClassID() const {return LNCLASSID_LNTEXT;}

	LNINT GetCount() const;

	LNSTATUS Insert( LNINT pos, const LNText &text );
	LNSTATUS Insert( LNINT pos, const LNString &string );
	LNSTATUS Insert( LNINT pos, const LNTextElement &textelem );

	LNSTATUS SetValue( const LNText &text );
	LNSTATUS SetValue( const LNString &string );
	LNSTATUS SetValue( const LNTextElement &textelem );

protected:
	void Assign( LNNoteBody *noteb, LNTextBody *textb );

	LNTextBody * GetTextBody() const {return (LNTextBody *)GetItemBody();}

private:
};


#endif

