//===========================================================================
//
// Module:	LNSESSIO.HPP
//
// Description:
//
//		Class library definition for the LNNotesSession and
//		LNCreateDatabaseOptions classes.
//
//===========================================================================
//
// Copyright (c) 1996 Lotus Development Corporation. All rights reserved.
// This software is subject to the Lotus Software Agreement, Restricted
// Rights for U.S. government users, and applicable export regulations.
//
//===========================================================================

#ifndef LNSESSIO_HPP
#define LNSESSIO_HPP

#ifndef LNSERVERADDIN_HPP
#include "lnsaddin.hpp"
#endif

#ifndef LNLOGENTRY_HPP
#include "lnlogent.hpp"
#endif

#ifndef LNDB_HPP
#include "lndb.hpp"
#endif

#ifndef LNMAIL_HPP
#include "lnmail.hpp"
#endif

#ifndef NSF_DB_DEFS
#include <nsfdb.h>
#endif

#ifndef NSF_SEARCH_DEFS
#include <nsfsearc.h>
#endif

#ifndef STD_NAME_DEFS
#include <stdnames.h>
#endif

//-----	Forward declarations and as-of-yet-undefined data types.

class LNReplicationOptions {};

//-----	Flags for LNNotesSession::GetDatabases.

typedef WORD LNGETDBFLAGS;

#define LNGETDBFLAGS_DATABASES	0x0001	// get databases
#define LNGETDBFLAGS_TEMPLATES	0x0002	// get database templates
#define LNGETDBFLAGS_RECURSE	0x0004	// recurse into subdirectories


//-----	Options for LNCreateDatabaseOptions::Get/SetLocalEncryption.

enum LNLOCALENCRYPTION
{
	LNLOCALENCRYPTION_NONE		=	DBCREATE_ENCRYPT_NONE,
	LNLOCALENCRYPTION_SIMPLE	=	DBCREATE_ENCRYPT_SIMPLE,
	LNLOCALENCRYPTION_MEDIUM	=	DBCREATE_ENCRYPT_MEDIUM,
	LNLOCALENCRYPTION_STRONG	=	DBCREATE_ENCRYPT_STRONG
};

//-----	Mail program used by Notes.

enum LNMAILPROGRAM
{
	LNMAILPROGRAM_NOTES = MAILSYSTEM_NOTES,
	LNMAILPROGRAM_CCMAIL = MAILSYSTEM_CCMAIL,
	LNMAILPROGRAM_VIM = MAILSYSTEM_VIMMAIL,
	LNMAILPROGRAM_NONE = MAILSYSTEM_NONE,
	LNMAILPROGRAM_UNKNOWN = 9999
};

//-----	Other data.

typedef WORD LNNOTESVERSION;

//---------------------------------------------------------------------------
// 	Class name:	LNCreateDatabaseOptions
//
//	Description:
//
//	Options used by the LNNotesSession CreateDatabase functions.
//
//---------------------------------------------------------------------------

//-----	Values of Flags member. For internal use only.

#define	LNCREATEDBFLAG_OVERWRITE		0x0001
#define	LNCREATEDBFLAG_DESIGN_ONLY		0x0002
#define	LNCREATEDBFLAG_INHERIT_DESIGN	0x0004

class LNCreateDatabaseOptions : public LNNotesClass
{
public:
	LNCreateDatabaseOptions();
	LNCreateDatabaseOptions( const LNCreateDatabaseOptions &options )
		: LNNotesClass(options) { Copy(options); }
	~LNCreateDatabaseOptions() {}
	LNCreateDatabaseOptions & operator=( const LNCreateDatabaseOptions &options );
	virtual LNCLASSID GetClassID() const
		{ return LNCLASSID_LNCREATEDATABASEOPTIONS; }
	LNBOOL GetCopyACL() const
		{ return (CopyFlags & DBCOPY_NO_ACL) == 0; }
	LNBOOL GetCopyDesignOnly() const
		{ return (Flags & LNCREATEDBFLAG_DESIGN_ONLY) != 0; }
	LNBOOL GetCreateFTIndex() const
		{ return (CopyFlags & DBCOPY_NO_FULLTEXT) == 0; }
	LNBOOL GetInheritDesign() const
		{ return (Flags & LNCREATEDBFLAG_INHERIT_DESIGN) != 0; }
	LNLOCALENCRYPTION GetLocalEncryption() const
		{ return (LNLOCALENCRYPTION) Encryption; }
	LNBOOL GetPreserveNoteModifiedTime() const
		{ return (CopyFlags & DBCOPY_KEEP_NOTE_MODTIME) != 0; }
	LNINT GetSizeLimitInMB() const { return SizeLimit; }
	LNBOOL GetOverwriteExistingFile() const
		{ return (Flags & LNCREATEDBFLAG_OVERWRITE) != 0; }
	void SetCopyACL( LNBOOL flag );
	void SetCopyDesignOnly( LNBOOL flag );
	void SetCreateFTIndex( LNBOOL flag );
	void SetInheritDesign( LNBOOL flag );
	LNSTATUS SetLocalEncryption( LNLOCALENCRYPTION option );
	void SetPreserveNoteModifiedTime( LNBOOL flag );
	LNSTATUS SetSizeLimitInMB( LNINT size );
	void SetOverwriteExistingFile( LNBOOL flag );

private:
	DWORD CopyFlags;
	WORD CreateFlags;
	WORD Flags;
	BYTE Encryption;
	LNINT SizeLimit;

	void Copy( const LNCreateDatabaseOptions &options );
	DWORD GetCopyFlags() const { return CopyFlags; }
	WORD GetCreateFlags() const { return CreateFlags; }
	BYTE GetEncryptionByte() const { return Encryption; }
	LNINT GetSizeLimitInBytes() const { return SizeLimit * 1024 * 1024; }
};

//---------------------------------------------------------------------------
// 	Class name:	LNDatabaseArray
//
//	Description:
//
//	Array of all or some Notes databases on the local or a remote machine.
//
//---------------------------------------------------------------------------

class LNDatabaseArray : public LNSmartPtr
{
public:
	LNDatabaseArray() {}
	LNDatabaseArray( const LNDatabaseArray &dbarray ) : LNSmartPtr(dbarray) {}
	~LNDatabaseArray() {}
	LNDatabaseArray & operator=( const LNDatabaseArray &dbarray )
		{ LNSmartPtr::operator=(dbarray); return *this; }
	LNDatabase operator[]( LNINT n );
	virtual LNCLASSID GetClassID() const { return LNCLASSID_LNDATABASEARRAY; }
	LNINT GetCount() const;

private:
	LNDatabaseArray & operator=( LNDatabaseArrayBody *dbarray )
		{ LNSmartPtr::operator=((LNBody *)dbarray); return *this; }
	LNDatabaseArrayBody * GetDatabaseArrayBody() const
		{ return (LNDatabaseArrayBody *) Body; }
};

//---------------------------------------------------------------------------
// 	Class name:	LNNotesSession
//
//	Description:
//
//	Container of data and objects pertaining to a Notes session.
//
//---------------------------------------------------------------------------

class LNNotesSession : public LNNotesClass
{
public:
	LNNotesSession();
	~LNNotesSession();

	static void operator delete( void *object );
	static void * operator new( size_t size );
	LNSTATUS CompactDatabase
		( const LNString &path, LNINT *newsize = 0, LNINT *oldsize = 0 ) const;
	LNSTATUS CompactDatabase
		( const LNDatabase &db, LNINT *newsize = 0, LNINT *oldsize = 0 ) const;
	LNSTATUS CompleteLogEntry( LNLogEntry *logentry ) const;
	LNSTATUS CreateDatabase
		( const LNString &path, const LNString &server = "", LNDatabase *db = 0 )
		{ return CreateDatabase(path, server, LNCreateDatabaseOptions(), db); }
	LNSTATUS CreateDatabase
		( const LNString &path, const LNString &server,
		  const LNCreateDatabaseOptions &options, LNDatabase *db = 0 );
	LNSTATUS CreateDatabaseCopy
		( const LNDatabase &srcdb, const LNString &newdb_path,
		  const LNString &newdb_server = "", LNDatabase *newdb = 0 )
		{
			return CreateDatabaseCopyOrReplica
				(srcdb, newdb_path, newdb_server, LNCreateDatabaseOptions(),
				 newdb, FALSE);
		}
	LNSTATUS CreateDatabaseCopy
		( const LNDatabase &srcdb, const LNString &newdb_path,
		  const LNString &newdb_server, const LNCreateDatabaseOptions &options,
		  LNDatabase *newdb = 0 )
		{
			return CreateDatabaseCopyOrReplica
				(srcdb, newdb_path, newdb_server, options, newdb, FALSE);
		}
	LNSTATUS CreateDatabaseCopy
		( const LNString &srcdb_path, const LNString &srcdb_server,
		  const LNString &newdb_path, const LNString &newdb_server = "",
		  LNDatabase *newdb = 0 )
		{
			return CreateDatabaseCopyOrReplica
				(srcdb_path, srcdb_server, newdb_path, newdb_server,
				 LNCreateDatabaseOptions(), newdb, FALSE);
		}
	LNSTATUS CreateDatabaseCopy
		( const LNString &srcdb_path, const LNString &srcdb_server,
		  const LNString &newdb_path, const LNString &newdb_server,
		  const LNCreateDatabaseOptions &options, LNDatabase *newdb = 0 )
		{
			return CreateDatabaseCopyOrReplica
				(srcdb_path, srcdb_server, newdb_path, newdb_server, options,
				 newdb, FALSE);
		}
	LNSTATUS CreateDatabaseFromTemplate
		( const LNDatabase &templatedb, const LNString &newdb_path,
		  const LNString &newdb_server = "", LNDatabase *newdb = 0 )
		{
			return CreateDatabaseFromTemplate
				(templatedb, newdb_path, newdb_server, LNCreateDatabaseOptions(),
				 newdb);
		}
	LNSTATUS CreateDatabaseFromTemplate
		( const LNDatabase &templatedb, const LNString &newdb_path,
		  const LNString &newdb_server, const LNCreateDatabaseOptions &options,
		  LNDatabase *newdb = 0 );
	LNSTATUS CreateDatabaseFromTemplate
		( const LNString &templatedb_path, const LNString &templatedb_server,
		  const LNString &newdb_path, const LNString &newdb_server = "",
		  LNDatabase *newdb = 0 )
		{
			return CreateDatabaseFromTemplate
				(templatedb_path, templatedb_server, newdb_path, newdb_server,
				 LNCreateDatabaseOptions(), newdb);
		}
	LNSTATUS CreateDatabaseFromTemplate
		( const LNString &templatedb_path, const LNString &templatedb_server,
		  const LNString &newdb_path, const LNString &newdb_server,
		  const LNCreateDatabaseOptions &options, LNDatabase *newdb = 0 );
	LNSTATUS CreateDatabaseReplica
		( const LNDatabase &srcdb, const LNString &newdb_path,
		  const LNString &newdb_server = "", LNDatabase *newdb = 0 )
		{
			return CreateDatabaseCopyOrReplica
				(srcdb, newdb_path, newdb_server, LNCreateDatabaseOptions(),
				 newdb, TRUE);
		}
	LNSTATUS CreateDatabaseReplica
		( const LNDatabase &srcdb, const LNString &newdb_path,
		  const LNString &newdb_server, const LNCreateDatabaseOptions &options,
		  LNDatabase *newdb = 0 )
		{
			return CreateDatabaseCopyOrReplica
				(srcdb, newdb_path, newdb_server, options, newdb, TRUE);
		}
	LNSTATUS CreateDatabaseReplica
		( const LNString &srcdb_path, const LNString &srcdb_server,
		  const LNString &newdb_path, const LNString &newdb_server = "",
		  LNDatabase *newdb = 0 )
		{
			return CreateDatabaseCopyOrReplica
				(srcdb_path, srcdb_server, newdb_path, newdb_server,
				 LNCreateDatabaseOptions(), newdb, TRUE);
		}
	LNSTATUS CreateDatabaseReplica
		( const LNString &srcdb_path, const LNString &srcdb_server,
		  const LNString &newdb_path, const LNString &newdb_server,
		  const LNCreateDatabaseOptions &options, LNDatabase *newdb = 0 )
		{
			return CreateDatabaseCopyOrReplica
				(srcdb_path, srcdb_server, newdb_path, newdb_server, options,
				 newdb, TRUE);
		}
	LNSTATUS CreateLogEntry( LNLogEntry *logentry, 
							const LNString &formname = LOG_EVENT_FORM ) const;
	LNSTATUS DeleteDatabase( const LNString &path, const LNString &server = "" );
	LNSTATUS DeleteDatabase( LNDatabase *db );
	LNSTATUS DiscardLogEntry( LNLogEntry *logentry ) const;
	virtual LNCLASSID GetClassID() const
		{ return LNCLASSID_LNNOTESSESSION; }
	LNDatetime GetCurrentDatetime() const;
	LNSTATUS GetDatabase
		( const LNString &path, LNDatabase *db, const LNString &server = "" );
	LNSTATUS GetDatabase
		( const DBID &replicaid, LNDatabase *db, const LNString &server = "" );
	LNDBOPENFLAGS GetDatabaseOpenFlags() const;
	LNSTATUS GetDatabases
		( LNDatabaseArray *dbarray, const LNString &server = "",
		  const LNString &dir = "",
		  LNGETDBFLAGS flags = LNGETDBFLAGS_DATABASES | LNGETDBFLAGS_RECURSE );
	LNString GetDataDirectory();
	LNString GetEnvironmentString( const LNString &variable ) const;
	LNSINT GetEnvironmentValue( const LNString &variable ) const;
	LNInternational GetInternational() const;
	LNSTATUS GetMailDatabase( LNDatabase *db );
	LNMAILPROGRAM GetMailProgram();
	LNSTATUS GetNotesVersion
		( LNNOTESVERSION *version, const LNString &server = "" );
	LNString GetPort() const { return Port; }
	LNSTATUS GetServerAddin
		( const LNString &task, const LNString &text, LNServerAddin *AddinPtr);
	LNSTATUS GetServerNames( LNText *names ) const;
	LNString GetUserName()
		{ return GetUserNameText(); }
	LNSTATUS Init()
		{ return Initialize(LNGetAPIProgramVersion(), 0, 0); }
	LNSTATUS Init( int argc, char *argv[] )
		{ return Initialize(LNGetAPIProgramVersion(), argc, argv); }
	LNSTATUS InitThread();
	LNSTATUS SetDatabaseOpenFlags( LNDBOPENFLAGS flags );
	LNSTATUS SetEnvironmentString
		( const LNString &variable, const LNString &string ) const;
	LNSTATUS SetEnvironmentValue( const LNString &variable, LNSINT value ) const;
	LNSTATUS SetPort( const LNString &port );
	LNSTATUS Term();
	LNSTATUS TermThread();

private:
	LNDBOPENFLAGS DatabaseOpenFlags;
	char *DataDirectory;
	WORD Flags;
	LNMAILPROGRAM MailProgram;
	LNNOTESVERSION NotesVersion;
	LNString Port;
	LNObjectList Objects;
	LNServerAddin *ServerAddinPtr;
	char *UserName;

	// copy constructor and assignment operator are private (and undefined) to
	// prevent anyone from using them

	LNNotesSession( const LNNotesSession &session );
	LNNotesSession & operator=( const LNNotesSession &session );

	// other private functions

	LNSTATUS AddObjectToList( LNNotesClass *object )
		{ return Objects.AddObject(object); }
	LNString GetUserNameText();
	LNSTATUS Initialize( LNVERSION version, int argc, char *argv[] );
	LNSTATUS ConstructNetPathname
		( const LNString &path, const LNString &server, char *buffer ) const;
	LNSTATUS CreateDatabaseCopyOrReplica
		( const LNDatabase &srcdb, const LNString &newdb_path,
		  const LNString &newdb_server, const LNCreateDatabaseOptions &options,
		  LNDatabase *newdb, LNBOOL replica );
	LNSTATUS CreateDatabaseCopyOrReplica
		( const LNString &srcdb_path, const LNString &srcdb_server,
		  const LNString &newdb_path, const LNString &newdb_server,
		  const LNCreateDatabaseOptions &options, LNDatabase *newdb,
		  LNBOOL replica );
};

#endif	//LNSESSIO_HPP

