//===========================================================================
//
// Module:	LNADDIN.HPP
//
// Description: Class library definition for LNServerAddin
//
//===========================================================================
//
// Copyright (c) 1995 Lotus Development Corporation. All rights reserved.
// This software is subject to the Lotus Software Agreement, Restricted
// Rights for U.S. government users, and applicable export regulations.
//
//===========================================================================

#ifndef LNSERVERADDIN_HPP
#define LNSERVERADDIN_HPP

#ifndef LNGLOBAL_H
#include "lnglobal.h"
#endif

typedef LNINT LNSTATUSLINEID;
#define INVALID_STATUS_LINEID 0xffef


class LNServerAddin : public LNNotesClass
{
	friend class LNNotesSession;
	friend class LNAddinStatusLine;		// for access to pNotesSession

public:
	LNServerAddin();
	~LNServerAddin();

	void AppendLogMessage( const LNString &message );

	LNSTATUS CreateStatusLine(const LNString &task,
								const LNString &text, 
								LNSTATUSLINEID *nStatusLineID);
	LNSTATUS DeleteStatusLine(LNSTATUSLINEID nStatusLineID);

	// Pure virtual method in the base class LNNotesClass
	virtual LNCLASSID GetClassID() const {return LNCLASS_LNSERVERADDIN;}

	LNString GetDefaultStatusLineTaskName();
	LNString GetDefaultStatusLineText();

	LNSTATUS GetStatusLineTaskName(LNSTATUSLINEID StatusLineID, 
													LNString *TaskNamePtr);
	LNSTATUS GetStatusLineText(LNSTATUSLINEID StatusLineID, 
													LNString *TextDescPtr);

	LNBOOL HaveMinutesElapsed(LNINT min);
	LNBOOL HaveSecondsElapsed(LNINT sec);
	LNBOOL Idle();
	LNBOOL Idle(LNINT mSecs);
	LNBOOL IsNewDay();

	LNSTATUS SetDefaultStatusLine(LNSTATUSLINEID *StatusLineID);
	void SetDefaultStatusLineTaskName(const LNString &NewString);
	void SetDefaultStatusLineText(const LNString &NewString);

	LNSTATUS SetStatusLineTaskName(LNSTATUSLINEID nStatusLineID,
											const LNString &NewString);
	LNSTATUS SetStatusLineText(LNSTATUSLINEID StatusLineID,
											const LNString &NewString);

	LNBOOL ShouldAddinTerminate();

private:
	LNAddinStatusLine *DefaultStatusLinePtr;
	LNObjectList LNOStatusLines;
	LNNotesSession *NotesSessionPtr;
	
	// Virtual method in the base class LNNotesClass
	virtual LNSTATUS Close();

	void CreateDefaultStatusLine(const LNString &task, const LNString &text);
	LNSTATUS CreateStatusLine(const LNString &task,
								const LNString &text,
								LNSTATUSLINEID StatusLineID);

	LNBOOL FindStatusLine(const LNObjectList &List,
								LNSTATUSLINEID StatusLineID, 
								LNAddinStatusLine **CurrLinePtrPtr);

	void ServerAddinInit(const LNString &task, const LNString &text);

	LNServerAddin(const LNServerAddin &addin);
	LNServerAddin & operator=(const LNServerAddin &addin);

};


class LNAddinStatusLine : public LNNotesClass
{
	friend class LNServerAddin;

public:
	~LNAddinStatusLine();

	// Pure virtual method in the base class LNNotesClass
	virtual LNCLASSID GetClassID() const {return LNCLASS_LNADDINSTATUSLINE;}

private:
	HANDLE DescHandle;
	LNString TaskName;
	LNString StatusText;
	LNServerAddin *ServerAddinPtr;
	LNSTATUSLINEID LineID;
	static LNSTATUSLINEID LastID;

	LNAddinStatusLine();
	LNAddinStatusLine(const LNString &TaskName, const LNString &StatusText);
	LNAddinStatusLine(HANDLE NewDescHandle);
	LNAddinStatusLine(const LNAddinStatusLine &statusline);
	LNAddinStatusLine & operator=(const LNAddinStatusLine &statusline);
};


#endif	//LNSERVERADDIN_HPP



//===========================================================================
//                             REVISION HISTORY
//===========================================================================
//
//   Date	Who	Description
// --------	---	-----------
// 08/23/96	SJB	Added #define for invalid LineID.  SetDefaultStatusLine now
//				passes it's param by pointer, for it will be changed inside.
//
// 08/08/96	SJB	Changed 1st param in SetDefaultStatusLine to LNSTATUSLINEID.
//
// 07/22/96	SJB	Removed all hungarian notation. Added AppendLogMessage.
//
// 07/11/96	SJB	Added typedef LNINT LNSTATUSLINEID and changed all LNINT's
//				for status line to reflect this change. GetDefaultStatusLine
//				routines now return an LNString instead of passing one in.
//
// 06/25/96	SJB	Changed method IdleYield to Idle.
//
// 06/19/96	SJB	Get[Default]StatusLineTaskName/LineText now pass back a ptr
//				to an LNString.
//
// 06/13/96	SJB	ServerAddinInit now returns a void.
//				Added SetDefaultStatusLineTaskName and SetStatusLineTaskName.
//				Added GetDefaultStatusLineTaskName, GetStatusLineTaskName
//				GetDefaultStatusLineText and GetStatusLineText.
//				Added a private overloaded method CreateStatusLine.
//
// 06/12/96	SJB	LNAddinStatusLine class is now private.  StatusLine methods
//				now take a LineID to refer to the current statuslines.
//
// 06/10/96	SJB	Made LNAddinStatusLine a friend to class LNServerAddin.
//				Added CreateDefaultStatusLine and removed last parameter to
//				CreateStatusLine.  To LNServerAddin, added pNotesSession
//				instance data and methods Close() and ServerAddinInit().
//				Added pServerAddin instance data to class LNAddinStatusLine.
//				Added method AddObjectToList to LNServerAddin.
//
// 05/31/96	SJB	Initial version.
//
//===========================================================================

