//===========================================================================
//
// Module:  LNRTELEM.HPP
//
// Description:
//
//  Class library definition for LNRTElement and related classes.
//
//===========================================================================
//
// Copyright (c) 1996 Lotus Development Corporation. All rights reserved.
// This software is subject to the Lotus Software Agreement, Restricted
// Rights for U.S. government users, and applicable export regulations.
//
//===========================================================================

#ifndef LNRTELEM_HPP
#define LNRTELEM_HPP


typedef DWORD LNFieldType;


class LNRTElement : public LNRTObject
{

	friend class LNRTCursor;
	friend class LNRTElementBody;

public:
	
	LNRTElement();
	LNRTElement(const LNRTObject &object);
	LNRTElement(const LNRTElement &element);

	~LNRTElement();
	
	LNRTElement& operator=(const LNRTObject &object);
	LNRTElement& operator=(const LNRTElement &element);
	
	virtual LNCLASSID GetClassID() const { return LNCLASS_LNRTELEMENT; }

	LNSTATUS GetCursor(LNRTCursor *cursor) const;					 
	
protected:

	LNRTElement(LNStylizedTextBody *stylizedTextBody, LNINT offset);

	LNRTElement(LNRTElementBody *body);
	
	LNRTElement& operator=(LNRTElementBody *body);

	virtual LNSTATUS CopyRTObject(const LNRTObject &object, LNBOOL copychildren);
};






// Not implemented yet.
class LNHotSpot : public LNRTElement
{
public:
	
	LNHotSpot();
	
	LNHotSpot(const LNHotSpot &hotSpot);
	
	~LNHotSpot();
	
	virtual LNCLASSID GetClassID() const { return LNCLASS_LNHOTSPOT; }

protected:

	// TBD virtual LNSTATUS CopyRTObject(const LNRTObject &object, LNBOOL copychildren);
};




// Not implemented yet.
class LNDocLink : public LNRTElement
{
public:
	
	LNDocLink();
	LNDocLink(const LNDocLink &docLink);

	~LNDocLink();
	
	virtual LNCLASSID GetClassID() const { return LNCLASS_LNDOCLINK; }

protected:
	
	virtual LNSTATUS CopyRTObject(const LNRTObject &object, LNBOOL copychildren);	
};


class LNTableCell : public LNRTElement
{
public:
	
	LNTableCell();
	LNTableCell(const LNTableCell &tableCell);

	~LNTableCell();
	
	LNTableCell& operator=(const LNTableCell &tablecell);
	LNTableCell& operator=(const LNRTObject & object);
	
	virtual LNCLASSID GetClassID() const { return LNCLASS_LNTABLECELL; }

protected:
	
	virtual LNSTATUS CopyRTObject(const LNRTObject &object, LNBOOL copychildren);	
};



// Default class for CDRecords we don't understand or haven't implemented yet.
class LNCompositeData : public LNRTElement
{
public:
	
	LNCompositeData();
	LNCompositeData( const LNRTObject &object );
	LNCompositeData( const LNCompositeData &compositeData );
	
	~LNCompositeData();
	
	LNCompositeData& operator=( const LNRTObject &object );
	LNCompositeData& operator=( const LNCompositeData &compositeData );

	virtual LNCLASSID GetClassID() const { return LNCLASS_LNCOMPOSITEDATA; }

	WORD GetCDSignature() const;
	
 	virtual LNINT GetSize() const;

	LNSTATUS Read( LNINT bufsize, void *buf, LNINT offset = 0 ) const;

	LNSTATUS ReadODS( WORD odstype, void *buf ) const;

	LNSTATUS Write( LNINT bufsize, void *buf, LNINT offset = 0 );

	LNSTATUS WriteODS( WORD odstype, void *buf );	

protected:

	virtual LNSTATUS CopyRTObject(const LNRTObject &object, LNBOOL copychildren);

private:
	virtual LNSTATUS GetText(LNString *buf) const;
};


#endif

