//===========================================================================
//
// Module:  LNRTCRSR.HPP
//
// Description:
//
//  Class library definition for LNRTCursor and related classes.
//
//===========================================================================
//
// Copyright (c) 1996 Lotus Development Corporation. All rights reserved.
// This software is subject to the Lotus Software Agreement, Restricted
// Rights for U.S. government users, and applicable export regulations.
//
//===========================================================================

#ifndef LNRTCRSR_HPP
#define LNRTCRSR_HPP


class LNRTCursor : public LNSmartPtr
{
	friend class LNRTContainerBody;
	friend class LNRTCursorBody;
	friend class LNRTElement;
	friend class LNRTElementBody;
	friend class LNRTObjectBody;
	friend class LNStylizedTextBody;


public:

	LNRTCursor();
	LNRTCursor(const LNRTCursor &cursor);

	~LNRTCursor();
	
	LNRTCursor& operator=(const LNRTCursor &cursor);

	LNRTCursor operator+(LNINT n) const;

	LNRTCursor& operator++();    // prefix
	LNRTCursor& operator++(int); // postfix

	LNRTCursor& operator+=(LNINT n);
	
	LNRTCursor operator-(LNINT n) const;
	
	LNRTCursor& operator--();    // prefix
	LNRTCursor& operator--(int); // postfix
	
	LNRTCursor& operator-=(LNINT n);
	
	LNSINT operator-(const LNRTCursor &cursor) const;
	
	LNBOOL operator<(const LNRTCursor &cursor) const;
	
	LNBOOL operator<=(const LNRTCursor &cursor) const;
	
	LNBOOL operator>(const LNRTCursor &cursor) const;
	
	LNBOOL operator>=(const LNRTCursor &cursor) const;
	
	LNBOOL operator==(const LNRTCursor &cursor) const;
	
	LNBOOL operator!=(const LNRTCursor &cursor) const;

	LNSTATUS Copy(const LNRTCursor &cursor);

	virtual LNCLASSID GetClassID() const { return LNCLASS_LNRTCURSOR; }
	
	LNSTATUS GetFontStyle(LNFontStyle *style) const;

	LNSTATUS GetObject(LNRTObject *object) const
		{ return GetRTObject(object); }


	LNSTATUS GotoEnd(LNRTTYPE type);
	LNSTATUS GotoEnd(const LNRTContainer &container);

	LNSTATUS GotoFirst(LNRTTYPE type, LNRTObject *object = 0);
	LNSTATUS GotoFirst(const LNString &searchstring);

	LNSTATUS GotoLast(LNRTTYPE type, LNRTObject *object = 0);
	LNSTATUS GotoLast(const LNString &searchstring);
	
	LNSTATUS GotoNext(LNRTTYPE type, LNRTObject *object = 0);
	LNSTATUS GotoNext(const LNString &searchstring);
	
	LNSTATUS GotoObject(const LNRTObject &object);

	LNSTATUS GotoPrevious(LNRTTYPE type, LNRTObject *object = 0);
	LNSTATUS GotoPrevious(const LNString &searchstring);

	LNSTATUS GotoStart(LNRTTYPE type);
	LNSTATUS GotoStart(const LNRTContainer &container);

	LNBOOL IsAtEnd() const;
	
	LNBOOL IsAtStart() const;

	LNSTATUS RemoveScope();

	LNSTATUS SetScope(const LNRTContainer &container);

	LNSTATUS SetSearchOptions(LNRTSEARCHFLAGS options);
	
protected:

	LNRTCursor(const LNRTElement &element, LNBOOL after = FALSE);
	LNRTCursor(LNStylizedTextBody *stylizedTextBody, LNINT offset, LNBOOL after = FALSE);

	LNRTCursor& operator=(LNRTCursorBody *body);


	LNINT GetOffset() const;

	LNSTATUS GetParentContainer(LNRTContainer *container) const;
	LNSTATUS GetParentContainer(LNRTTYPE type, LNRTContainer *container) const;

	LNRTCursorBody* GetRTCursorBody() const { return (LNRTCursorBody *) Body; }

	LNBOOL  IsContainedBy(const LNRTContainer &container) const;

	LNBOOL IsInsertablePosition(LNRTTYPE type) const;

	LNBOOL IsValid() const;
	LNBOOL IsValid(const LNRTContainer &container) const;
	LNBOOL IsValid(const LNRTContainerBody *containerBody) const;

private:

	LNSTATUS GetRTObject(LNRTObject *object) const;
};




#endif

