//===========================================================================
//
// Module:  LNRTCONT.HPP
//
// Description:
//
//  Class library definition for LNRTContainerBody and related classes.
//	(LNRTContainer is in LNRTOBJ.HPP because it must be defined after
//	LNRTObject, and before LNRTObjectBody).
//
//===========================================================================
//
// Copyright (c) 1996 Lotus Development Corporation. All rights reserved.
// This software is subject to the Lotus Software Agreement, Restricted
// Rights for U.S. government users, and applicable export regulations.
//
//===========================================================================

#ifndef LNRTCONT_HPP
#define LNRTCONT_HPP




class LNStylizedText : public LNRTContainer
{
	friend class LNRTCharBody;
	friend class LNRTContainerBody;
	friend class LNRTCursorBody;
	friend class LNRTObjectBody;
	friend class LNStylizedTextBody;

public:
	
	LNStylizedText();
	LNStylizedText(const LNString &text);
	LNStylizedText(const LNRTObject &object);
	LNStylizedText(const LNStylizedText &stylizedText);

	LNStylizedText& operator=(const LNRTObject &object);
	LNStylizedText& operator=(const LNStylizedText &stylizedText);
	
	~LNStylizedText();
	
	virtual LNCLASSID GetClassID() const { return LNCLASS_LNSTYLIZEDTEXT; }

	virtual LNSTATUS GetFontStyle(LNFontStyle *style) const;

	virtual LNSTATUS GetText(LNString *buf) const;

protected:

	virtual LNSTATUS CopyRTObject(const LNRTObject &other, LNBOOL copychildren);

	LNINT GetByteCount() const;

	LNINT GetCharacterCount() const;

	LNStylizedTextBody* GetStylizedTextBody() const { return (LNStylizedTextBody *) Body; }

	LNSTATUS SplitText(LNINT splitpos);

};



// Not yet implemented.
class LNTable : public LNRTContainer
{
public:
	
	LNTable();
	LNTable(const LNTable &table);
	
	~LNTable();
	
	virtual LNCLASSID GetClassID() const { return LNCLASS_LNTABLE; }

protected:

	virtual LNSTATUS CopyRTObject(const LNRTObject &object, LNBOOL copychildren);
};


#endif

