//===========================================================================
//
// Module:	LNRT.HPP
//
// Description:
//
//	Class declarations of the LNRichText item classes, and the CDRecord parsers.
//
//===========================================================================
//
// Copyright (c) 1996 Lotus Development Corporation. All rights reserved.
// This software is subject to the Lotus Software Agreement, Restricted
// Rights for U.S. government users, and applicable export regulations.
//
//===========================================================================

#ifndef LNRT_HPP
#define LNRT_HPP



#ifndef LNGLOBAL_H
#include "lnglobal.h"
#endif

#ifndef LNMBLOCK_HPP
#include "lnmblock.hpp"
#endif

#ifndef LNFONT_HPP
#include "lnfont.hpp"
#endif

#ifndef LNRTOBJ_HPP
#include "lnrtobj.hpp"
#endif


#include "lndb.hpp"




class LNRichText : public LNItem
{
	friend class LNNoteBody;
	friend class LNRichTextBody;
	friend class LNRTContainerBody;
	friend class LNRTObjectBody;
	friend class LNRTOutputStream;
	friend class LNStylizedTextBody;


public:

	LNRichText();
	LNRichText(const LNString &text);
	LNRichText(const LNItem &item);
	LNRichText(const LNRichText &richtext);
	
	~LNRichText();
	
	LNRichText& operator=(const LNItem &item);
	LNRichText& operator=(const LNRichText &richtext);

	LNRichText& operator<<(const LNString &text);
	LNRichText& operator<<(const LNRichText &richtext);
	LNRichText& operator<<(const LNRTObject &object);

	LNSTATUS Append(const LNString &text);
	LNSTATUS Append(const LNRichText &richtext);
	LNSTATUS Append(const LNRTObject &object);

	LNSTATUS Delete(LNRTCursor *start, LNRTCursor *end);
	LNSTATUS Delete(LNRTCursor *start, LNINT poscount);

	virtual LNCLASSID GetClassID() const { return LNCLASS_LNRICHTEXT; }
	
	LNSTATUS GetCursor(LNRTCursor *cursor) const;					 

	LNSTATUS GetEndCursor(LNRTCursor *cursor) const;					 

	LNSTATUS GetRichText(const LNRTCursor &start, const LNRTCursor &end,
		LNRichText *richtext) const;
	LNSTATUS GetRichText(const LNRTObject &object,
		LNRichText *richtext) const;

	virtual LNSTATUS GetText(LNString *buf) const;

	LNRTTYPE GetType() const;
	
	virtual LNINT GetValueSize() const;

	LNSTATUS Insert(const LNString &text, LNRTCursor *cursor);

	virtual LNSTATUS SetFontStyle(const LNRTCursor &begin, const LNRTCursor &end,
		const LNFontStyle &style, LNSETFONTSTYLEFLAGS mask=LNSETFONTSTYLEFLAGS_ALL);
	LNSTATUS SetFontStyle(const LNRTCursor &cursor, const LNFontStyle &style);

protected:

	LNRichText(LNRichTextBody *body);

	LNRichText& operator=(LNRichTextBody *body);

	virtual LNSTATUS Copy( const LNItem &item );

	LNSTATUS Delete(LNRTObject *object);

	LNSTATUS GetCurrentMemoryBlock(LNINT size, LNINT *offset,
										LNMemoryBlock **memoryBlock);

	LNSTATUS GetFirstChild(LNRTObject *object) const;

	LNSTATUS GetNextSibling(LNRTObject *object) const;

	LNSTATUS GetParentContainer(LNRTContainer *container) const;

	LNSTATUS GetPreviousSibling(LNRTObject *object) const;

	LNSTATUS GetRichText(const LNRTCursor &start, LNINT poscount,
		LNRichText *richtext) const;
	LNSTATUS GetRichText(const LNRTCursor &cursor, LNRTTYPE type,
		LNRichText *richtext) const;

	LNRichTextBody* GetRichTextBody() const { return (LNRichTextBody *) Body; }

	LNRTContainer& GetRTContainer() const;
	
	LNSTATUS Insert(const LNRichText &richtext, LNRTCursor *cursor);
	LNSTATUS Insert(const LNRTObject &object, LNRTCursor *cursor);

	LNBOOL IsValid() const;

	virtual LNSTATUS Save(const char *newname = 0);

};

#ifndef LNRTCONT_HPP
#include "lnrtcont.hpp"
#endif




#ifndef LNRTELEM_HPP
#include "lnrtelem.hpp"
#endif

#ifndef LNGRPHIC_HPP
#include "lngrphic.hpp"
#endif

#ifndef LNRTCRSR_HPP
#include "lnrtcrsr.hpp"
#endif

#ifndef LNPARAGR_HPP
#include "lnparagr.hpp"
#endif



#endif
	
