//===========================================================================
//
// Module:  LNPARAGR.HPP
//
// Description:
//
//  Class library definition for LNParagraph and related classes.
//
//===========================================================================
//
// Copyright (c) 1996 Lotus Development Corporation. All rights reserved.
// This software is subject to the Lotus Software Agreement, Restricted
// Rights for U.S. government users, and applicable export regulations.
//
//===========================================================================

#ifndef LNPARAGR_HPP
#define LNPARAGR_HPP


class LNParagraphStyle : public LNRTElement
{
	friend class LNParagraphBody;

public:
	
	LNParagraphStyle();
	LNParagraphStyle(const LNParagraphStyle &paragraphStyle);

	~LNParagraphStyle();
	
	LNParagraphStyle& operator=(const LNParagraphStyle &paragraphStyle);
	
	virtual LNCLASSID GetClassID() const { return LNCLASS_LNPARAGRAPHSTYLE; }

protected:
	
	virtual LNSTATUS CopyRTObject(const LNRTObject &object, LNBOOL copychildren);
	
	WORD GetPABID() const;
};


class LNParagraph : public LNRTContainer
{
	friend class LNParagraphBody;
	friend class LNRTInputParser;

public:
	
	LNParagraph();
	LNParagraph(const LNParagraph &paragraph);

	~LNParagraph();

	LNParagraph& operator=(const LNParagraph &paragraph);
	LNParagraph& operator=(const LNRTObject &object);

	virtual LNCLASSID GetClassID() const { return LNCLASS_LNPARAGRAPH; }

protected:

	LNSTATUS AddPABREF(LNRTObject *pabref);			

	virtual LNSTATUS CopyRTObject(const LNRTObject &object, LNBOOL copychildren);

	LNParagraphBody* GetParagraphBody() const { return (LNParagraphBody *) Body; }

};



#endif

