//===========================================================================
//
// Module:		LNNUM.HPP
//
// Description:	Class library definition for LNNumbers and related classes.
//
//===========================================================================
//
// Copyright (c) 1995 Lotus Development Corporation. All rights reserved.
// This software is subject to the Lotus Software Agreement, Restricted
// Rights for U.S. government users, and applicable export regulations.
//
//===========================================================================
#ifndef LNNUM_HPP
#define LNNUM_HPP

STATUS NumListDuplicate( void *pnumlist, BOOL tprefix, HANDLE *reth );
WORD NumListGetNumEntries( void *pnumlist, BOOL tprefix );

//
//	Class definition for LNNumbersElement.
//
class LNNumbersElement : public LNNotesClass
{
friend class LNNumbers;

public:
	LNNumbersElement( const LNNumbersElement &other );
	LNNumbersElement( LNNumbersBody *numbody, LNINT index );

	~LNNumbersElement();

	LNNumbersElement& operator=( const LNNUMBER &number );
	LNNumbersElement& operator=( const LNNumbersElement &numberselem );

	operator LNNUMBER() const;

	LNCLASSID GetClassID() const {return LNCLASSID_LNNUMBERSELEMENT;}

private:
	LNNumbersElement();	// Disabled.

	LNNumbersBody *Body;
	LNINT Index;	
};

//
//	Class definition for LNNumbers.
//
class LNNumbers : public LNItem
{

public:
	LNNumbers();
	LNNumbers( const LNNumbers &other );
	LNNumbers( const LNItem &other );

	~LNNumbers();

	LNNumbers& operator=( const LNNumbers &other );
	LNNumbers& operator=( const LNItem &other );

	LNNumbers& operator<<( const LNNumbers &numbers );
	LNNumbers& operator<<( const LNNUMBER &number );
	LNNumbers& operator<<( const LNNumbersElement &numberselem );

	LNNumbersElement operator[]( LNINT n ) const;

	LNSTATUS Append( const LNNumbers &numbers );
	LNSTATUS Append( const LNNUMBER &number );
	LNSTATUS Append( const LNNumbersElement &numberselem );

	LNSTATUS Delete( LNINT n, LNINT count=1 );

	LNSTATUS DeleteAll();

	LNCLASSID GetClassID() const {return LNCLASSID_LNNUMBERS;}

	LNINT GetCount() const;

	LNSTATUS Insert( LNINT pos, const LNNumbers &numbers );
	LNSTATUS Insert( LNINT pos, const LNNUMBER &number );
	LNSTATUS Insert( LNINT pos, const LNNumbersElement &numberselem );

	LNSTATUS SetValue( const LNNumbers &numbers );
	LNSTATUS SetValue( const LNNUMBER &number );
	LNSTATUS SetValue( const LNNumbersElement &numberelem );

protected:
	void Assign( LNNoteBody *noteb, LNNumbersBody *numbersb );

	LNNumbersBody * GetNumbersBody() const
		{return (LNNumbersBody *)GetItemBody();}

private:
};


#endif

