//===========================================================================
//
// Module:		LNNOTE.HPP
//
// Description:	Class library definition for the LNNote and related classes.
//
//===========================================================================
//
// Copyright (c) 1996 Lotus Development Corporation. All rights reserved.
// This software is subject to the Lotus Software Agreement, Restricted
// Rights for U.S. government users, and applicable export regulations.
//
//===========================================================================

#ifndef LNNOTE_HPP
#define LNNOTE_HPP

#ifdef MAC
#include <Menus.h>
#undef GetItem
#endif

//
//	Class definition for LNNote.
//
class LNNote : public LNSmartPtr
{
friend class LNAgent;
friend class LNDatabase;
friend class LNDocument;
friend class LNForm;
friend class LNItem;
friend class LNItemArray;
friend class LNMailMessage;
friend class LNNoteArray;
friend class LNViewFolder;

public:
	LNNote();
	LNNote( const LNNote &other );

	~LNNote();
	
	LNNote & operator=( const LNNote &other );

	LNSTATUS Close();
	
	LNSTATUS CreateItem( const LNString &name, LNItem *newitem,
		LNITEMFLAGS flags=0, LNITEMOPTION options=LNITEMOPTION_APPEND_ONLY );
	LNSTATUS CreateItem( const LNString &name, LNITEMTYPE type, void *data, LNINT datalen,
		LNITEMFLAGS flags=0, LNITEMOPTION options=LNITEMOPTION_APPEND_ONLY, LNItem *newitem=0 );
	LNSTATUS CreateItem( const LNItem &item, LNITEMOPTION options=LNITEMOPTION_APPEND_ONLY,
		LNItem *newitem=0 );
	LNSTATUS CreateItem( const LNString &name, const LNItem &item,
		LNITEMFLAGS flags=0, LNITEMOPTION options=LNITEMOPTION_APPEND_ONLY,
		LNItem *newitem=0 );

	LNSTATUS DeleteAllItems();
	
	LNSTATUS DeleteItem( const LNString &name );
	LNSTATUS DeleteItem( LNItem *item );
	
	LNSTATUS Decrypt();
	
	LNSTATUS Encrypt( LNNote *encryptednote );
	
	LNDatetime GetAddedToFile();
	
	LNString GetAuthor();
	
	virtual LNCLASSID GetClassID() const {return LNCLASSID_LNNOTE;}
	
	LNDatetime GetCreated();

	LNDatabase GetDatabase() const {return Db;}
	
	LNSTATUS GetItem( const LNString &name, LNItem *item );

	LNINT GetItemCount();
	
	LNSTATUS GetItems( LNItemArray *items, LNITEMTYPE type=LNITEMTYPE_ANY );
	
	LNDatetime GetLastAccessed();
	
	LNDatetime GetLastModified();

	OID * GetOriginatorID();

	NOTEID GetNoteID() const;
	
	LNNOTETYPE GetNoteType() const;
	
	LNString GetSigner();
	
	LNINT GetSize();
	
	UNID * GetUniversalID();
	
	LNString GetVerifier();
	
	LNBOOL HasItem( const LNString &itemname );
	
	LNBOOL IsEncrypted();

	LNBOOL IsModified();
		
	LNBOOL IsOpen() const;
	
	LNBOOL IsSigned();
	
	LNSTATUS Open( LNNOTEOPENFLAGS options=LNNOTEOPENFLAGS_DEFAULT );
	
	LNSTATUS RenameItem( const LNString &oldname, const LNString &newname );
	LNSTATUS RenameItem( LNItem &item, const LNString &newname );
	
	LNSTATUS Save( LNNOTESAVEFLAGS options=LNNOTESAVEFLAGS_DEFAULT );
	
	LNSTATUS Sign();
	
	LNSTATUS Unsign();

protected:
	LNNote( LNDatabaseBody *db, NOTEID idnote );

	LNNote & operator=( LNNoteBody *note );

	LNDatabaseBody * GetDatabaseBody() const {return Db.GetDatabaseBody();}

	LNNoteBody * GetNoteBody() const {return (LNNoteBody *)Body;}

private:
	void Assign( LNDatabaseBody *db, NOTEID id );

	WORD FindType() const;

	LNDatabase Db;	
	NOTEID Id;
};


#ifndef LNITEM_HPP
#include "lnitem.hpp"
#endif

#ifndef LNAGENT_HPP
#include "lnagent.hpp"
#endif

#ifndef LNDOC_HPP
#include "lndoc.hpp"
#endif

#ifndef LNFORM_HPP
#include "lnform.hpp"
#endif

#ifndef LNVIEW_HPP
#include "lnview.hpp"
#endif


//
//	Class definition for LNNoteArray.
//
class LNNoteArray : public LNSmartPtr
{

public:
	LNNoteArray();
	LNNoteArray( const LNNoteArray &other );

	virtual ~LNNoteArray();
	
	LNNoteArray & operator=( const LNNoteArray &other );

	LNNote operator[]( LNINT n ) const
		{return LNNote(GetDatabaseBody(),GetNoteID(n));}

	virtual LNCLASSID GetClassID() const {return LNCLASSID_LNNOTEARRAY;}
	
	LNINT GetCount() const;

	LNDatabase GetDatabase() const {return Db;}

	virtual LNNotesSession * GetSession() const
		{ return Db.GetSession(); }

protected:
	HANDLE GetIDTable() const;

	NOTEID GetNoteID( LNINT n ) const;

	LNDatabaseBody * GetDatabaseBody() const {return Db.GetDatabaseBody();}

private:
	void Assign( LNDatabaseBody *db, LNIDTable *ids, LNNOTETYPE type );

	LNDatabase Db;
	LNNOTETYPE NoteType;
};

//
//	Class definition for LNAgentArray.
//
class LNAgentArray : public LNNoteArray
{

public:
	LNAgentArray() : LNNoteArray() {}
	LNAgentArray( const LNAgentArray &other ) : LNNoteArray(other) {}

	virtual ~LNAgentArray() {}

	LNAgentArray & operator=( const LNAgentArray &other )
		{LNNoteArray::operator=(other); return *this;}

	LNAgent operator[]( LNINT n ) const
		{return LNAgent(GetDatabaseBody(),GetNoteID(n));}
	
	virtual LNCLASSID GetClassID() const {return LNCLASSID_LNAGENTARRAY;}

private:
};

//
//	Class definition for LNDocumentArray.
//
class LNDocumentArray : public LNNoteArray
{

public:
	LNDocumentArray() : LNNoteArray() {}
	LNDocumentArray( const LNDocumentArray &other ) : LNNoteArray(other) {}

	virtual ~LNDocumentArray() {}

	LNDocumentArray & operator=( const LNDocumentArray &other )
		{LNNoteArray::operator=(other); return *this;}
	
	LNDocument operator[]( LNINT n ) const
		{return LNDocument(GetDatabaseBody(),GetNoteID(n),GetFTSearchScore(n));}
	
	virtual LNCLASSID GetClassID() const {return LNCLASSID_LNDOCUMENTARRAY;}

	LNBOOL IsFTSearch() const;

private:
	LNINT GetFTSearchScore( LNINT n ) const;
};

//
//	Class definition for LNFormArray.
//
class LNFormArray : public LNNoteArray
{

public:
	LNFormArray() : LNNoteArray() {}
	LNFormArray( const LNFormArray &other ) : LNNoteArray(other) {}

	virtual ~LNFormArray() {}
	
	LNFormArray & operator=( const LNFormArray &other )
		{LNNoteArray::operator=(other); return *this;}

	LNForm operator[]( LNINT n ) const
		{return LNForm(GetDatabaseBody(),GetNoteID(n));}
	
	virtual LNCLASSID GetClassID() const {return LNCLASSID_LNFORMARRAY;}

private:
};

//
//	Class definition for LNViewFolderArray.
//
class LNViewFolderArray : public LNNoteArray
{

public:
	LNViewFolderArray() : LNNoteArray() {}
	LNViewFolderArray( const LNViewFolderArray &other ) : LNNoteArray(other) {}

	virtual ~LNViewFolderArray() {}

	LNViewFolderArray & operator=( const LNViewFolderArray &other )
		{LNNoteArray::operator=(other); return *this;}
	
	LNViewFolder operator[]( LNINT n ) const
		{return LNViewFolder(GetDatabaseBody(),GetNoteID(n));}
	
	virtual LNCLASSID GetClassID() const {return LNCLASSID_LNVIEWFOLDERARRAY;}

private:
};

#endif	//LNNOTE_HPP

