//===========================================================================
//
// Module:		LNITEM.HPP
//
// Description:	Class library definitions for LNItem related classes.
//
//===========================================================================
//
// Copyright (c) 1996 Lotus Development Corporation. All rights reserved.
// This software is subject to the Lotus Software Agreement, Restricted
// Rights for U.S. government users, and applicable export regulations.
//
//===========================================================================

#ifndef LNITEM_HPP
#define LNITEM_HPP

LNITEMTYPE LNMapItemType( WORD nsfitem_type, WORD item_flags, LNCLASSID classid );
void LNUnmapItemType( LNITEMTYPE item_type, WORD *nsf_itemtype,	WORD *nsf_itemflags );

//
//	Class definition for LNItem.
//
class LNItem : public LNSmartPtr
{
friend class LNDatetimeRanges;
friend class LNDatetimes;
friend class LNFontTable;
friend class LNNumbers;
friend class LNRichText;
friend class LNText;

public:
	LNItem();
	LNItem( const LNItem &other );

	~LNItem();

	LNItem & operator=( const LNItem &other );

	LNCLASSID GetClassID() const {return LNCLASSID_LNITEM;}

	LNITEMFLAGS GetFlags() const;

	LNString GetName() const;

	LNNote GetNote() const {return Note;}

	LNITEMTYPE GetType() const;

	LNINT GetValueSize() const;

	LNBOOL IsDeleted() const;

	LNBOOL IsModified() const {return IsDirty();}

	LNBOOL IsNoteItem() const {return Note.IsNull() ? FALSE : TRUE;}

	LNBOOL IsType( LNITEMTYPE type ) const;

	LNSTATUS Read( LNINT offset, LNINT num, void *buf );

	LNSTATUS ReadODS( LNINT offset, WORD ods_type, void *buf );

	LNSTATUS Write( LNINT offset, LNINT num, void *buf );

	LNSTATUS WriteODS( LNINT offset, WORD ods_type, void *buf );

protected:
	LNItem( LNNoteBody *noteb, LNItemBody *itemb );

	LNSTATUS Alloc( LNINT size, LNITEMTYPE type );

	void Assign( LNNoteBody *noteb, LNItemBody *itemb );

	LNSTATUS Expand( LNINT offset, LNINT num );

	LNItemBody * GetItemBody() const {return (LNItemBody *)Body;}

	LNBOOL IsDirty() const;

	LNSTATUS Shorten( LNINT offset, LNINT num );

private:
	LNNote Note;
};


//
//	Class definition for LNItemArray.
//
class LNItemArray : public LNSmartPtr
{

public:
	LNItemArray();
	LNItemArray( const LNItemArray &other );

	~LNItemArray();

	LNItemArray & operator=( const LNItemArray &other );

	LNItem operator[]( LNINT n ) const;

	LNCLASSID GetClassID() const {return LNCLASSID_LNITEMARRAY;}

	LNINT GetCount() const;

	LNNote GetNote() const {return Note;}

private:
	void Assign( LNNoteBody *noteb, LNItemArrayBody *itemab );

	LNNote Note;
};


#ifndef LNRT_HPP
#include "lnrt.hpp"
#endif

#ifndef LNDTS_HPP
#include "lndts.hpp"
#endif

#ifndef LNDTRS_HPP
#include "lndtrs.hpp"
#endif

#ifndef LNNUM_HPP
#include "lnnum.hpp"
#endif

#ifndef LNTEXT_HPP
#include "lntext.hpp"
#endif

#ifndef LNFORMUL_HPP
#include "lnformul.hpp"
#endif

#endif

