//===========================================================================
//
// Module:  LNGRPHIC.HPP
//
// Description:
//
//  Class library definition for the rich text LNGraphic and related classes.
//
//===========================================================================
//
// Copyright (c) 1996 Lotus Development Corporation. All rights reserved.
// This software is subject to the Lotus Software Agreement, Restricted
// Rights for U.S. government users, and applicable export regulations.
//
//===========================================================================

#ifndef LNGRPHIC_HPP
#define LNGRPHIC_HPP



// Not yet implemented
class LNMetafile : public LNRTElement
{
public:
	
	LNMetafile();
	LNMetafile(const LNMetafile &metafile);
	
	~LNMetafile();
	
	virtual LNCLASSID GetClassID() const { return LNCLASS_LNMETAFILE; }

protected:
	
	virtual LNSTATUS CopyRTObject(const LNRTObject &object, LNBOOL copychildren);
};






class LNGraphic : public LNRTContainer
{
public:
	
	LNGraphic();
	LNGraphic(const LNGraphic &graphic);
	
	~LNGraphic() {};
	
	virtual LNCLASSID GetClassID() const { return LNCLASS_LNGRAPHIC; }

protected:
	
	virtual LNSTATUS CopyRTObject(const LNRTObject &object, LNBOOL copychildren);
};






// Not yet implemented.
class LNBitmap : public LNGraphic
{
public:
	
	LNBitmap();
	LNBitmap(const LNBitmap &bitmap);
	
	~LNBitmap();
	
	virtual LNCLASSID GetClassID() const { return LNCLASS_LNBITMAP; }

protected:
	
	virtual LNSTATUS CopyRTObject(const LNRTObject &object, LNBOOL copychildren);
};	






#endif

