//===========================================================================
//
// Module:	LNGLOSYM.H
//
// Description:
//
//		C++ API global typedefs and constant symbols (included by LNGLOBAL.H).
//
//===========================================================================
//
// Copyright (c) 1996 Lotus Development Corporation. All rights reserved.
// This software is subject to the Lotus Software Agreement, Restricted
// Rights for U.S. government users, and applicable export regulations.
//
//===========================================================================

#ifndef LNGLOSYM_H
#define LNGLOSYM_H


//-----	Define IOSTREAM_INIT_NOT_NEEDED for HPUX. This must be defined before
//		<iostream.h> is included.

#if defined HPUX && !defined _IOSTREAM_INIT_NOT_NEEDED
	#define _IOSTREAM_INIT_NOT_NEEDED
#endif

//===========================================================================
//                       EXTERNAL HEADER FILES
//===========================================================================

//-----	Include Windows API header file (WINDOWS.H) if needed to support
//		exception handling on Windows 3.x. This file must be included before
//		GLOBAL.H in order to avoid symbol redefinition warnings.

#ifdef DOS
	#include <windows.h>
#endif

//-----	Other system header files.

#include <stddef.h>			// needed to define size_t for operator new
#include <string.h>			// needed for strlen etc.
#ifdef AIX
	#include <strings.h>	// AIX needs both STRING.H and STRINGS.H
#endif


//-----	C API header files.

#ifndef GLOBAL_DEFS
	#include <global.h>		// required for all C API programs
#endif

#ifndef NAME_DEFS
	#include <names.h>		// defines MAXPATH, needed below
#endif


//===========================================================================
//                       PLATFORM-DEPENDENT SYMBOLS
//===========================================================================

//-----	Generate an error if not compiling on a supported platform. Currently,
//		the supported platforms are:
//
//		Borland C++ 4.5 on Windows 3.x
//		Microsoft Visual C++ 4.x on Windows NT 3.51
//		IBM VisualAge C++ 3.5 on NT 3.51
//		IBM VisualAge C++ 3.0 on OS/2 Warp
//		Solaris Sparc
//		AIX
//		HP-UX
//		Metrowerks on Mac PPC

#if defined DOSW16 && !defined MSC
	#define BCC
#endif

#if !(defined DOSW16 && defined BCC) && \
	!(defined NT && (defined MSC || defined IBM_C)) && \
	!(defined OS2_2x && defined IBM_C) && \
	!defined SOLARIS && !defined AIX && !defined HPUX && \
	!(defined MAC && defined MWERKS_C)
	#error ERROR: Unsupported platform.
#endif


//-----	Define LNGLOBALS_SUPPORTED if the platform allows each instance of
//		a shared library to have its own copy of global data, and define the
//		global data access macro accordingly. All globals are maintained in
//		a single structure to make it possible to support globals on all
//		platforms.

#if defined DOSW16 || defined NT || defined OS2_2x || defined SOLARIS || \
	defined MAC || defined AIX || defined HPUX
	#define LNGLOBALS_SUPPORTED
#else
	#error ERROR: Unsupported platform for global data.
#endif


//===========================================================================
//                       CONSTANTS AND TYPEDEFS
//===========================================================================

//-----	Fundamental numeric types.

typedef DWORD LNINT;			// unsigned 32-bit integer
typedef LONG LNSINT;			// signed 32-bit integer
typedef int LNBOOL;				// boolean, platform-dependent size
typedef NUMBER LNNUMBER;		// IEEE 64-bit real number


//-----	C++ API error/status code, similar to the C API STATUS code. LNSTATUS
//		is a 32-bit value. where the low word contains the status code and the
//		high word contains flags; if the status code is zero, the high word is
//		zero also. If the status code is non-zero, the most significant 4 bits
//		of the high word are one following:
//
//			MSBs	                     Meaning
//			----	---------------------------------------------------------
//			0000	low word of LNSTATUS contains a Notes C API STATUS code
//			1100	low word of LNSTATUS contains a C++ API error code
//			1101	low word of LNSTATUS contains a C++ API warning code
//
//		Note that the other bits in the high word are reserved.

typedef DWORD LNSTATUS;

const LNSTATUS LNNOERROR = 0;
const WORD LNSTATUS_CSTATUS = 0;
const WORD LNSTATUS_ERROR = 0xC000;
const WORD LNSTATUS_WARNING = 0xD000;
const WORD LNSTATUS_FLAGS = 0xF000;


//-----	API version number and string.

typedef LNINT LNVERSION;

const LNVERSION LNAPIVERSION = 400;

#define LNAPIVERSIONSTRING "Lotus Notes C++ API Release 4.0"


//-----	LNCHAR is used to identify character data that has already been
//		translated into LMBCS, and is meant to be used as a pointer type (i.e.,
//		LNCHAR *). LNCHAR is defined as int to distinguish LNCHAR * from char *
//		and LNString *; int is used rather than void to make sure the
//		compiler will never implicitly convert LNCHAR * to char *.

typedef int LNCHAR;


//-----	LNCOLOR is the representation of a color value. LNCOLOR_xxx values map
//		the first 0-15 Notes color values. Notes allows 240 total color values.

typedef WORD LNCOLOR;

#define LNCOLOR_BLACK 			NOTES_COLOR_BLACK
#define LNCOLOR_WHITE			NOTES_COLOR_WHITE
#define LNCOLOR_RED				NOTES_COLOR_RED
#define LNCOLOR_GREEN			NOTES_COLOR_GREEN
#define LNCOLOR_BLUE			NOTES_COLOR_BLUE
#define LNCOLOR_MAGENTA			NOTES_COLOR_MAGENTA
#define LNCOLOR_YELLOW			NOTES_COLOR_YELLOW
#define LNCOLOR_CYAN			NOTES_COLOR_CYAN
#define LNCOLOR_DARK_RED		NOTES_COLOR_DKRED
#define LNCOLOR_DARK_GREEN		NOTES_COLOR_DKGREEN
#define LNCOLOR_DARK_BLUE		NOTES_COLOR_DKBLUE
#define LNCOLOR_DARK_MAGENTA	NOTES_COLOR_DKMAGENTA
#define LNCOLOR_DARK_YELLOW		NOTES_COLOR_DKYELLOW
#define LNCOLOR_DARK_CYAN		NOTES_COLOR_DKCYAN
#define LNCOLOR_GRAY			NOTES_COLOR_GRAY
#define LNCOLOR_LIGHT_GRAY		NOTES_COLOR_LTGRAY


//-----	LNERROR_MESSAGE_LENGTH is a reasonable default (not maximum) length
//		for Notes error messages, and can be used to declare an error message
//		text buffer for the LNGetErrorMessage function.

const int LNERROR_MESSAGE_LENGTH = 512;


//-----	LNMAXPATH is the same as the Notes MAXPATH value, which is 100 on 16-bit
//		Windows and 256 everywhere else. Unfotunately, a Borland C++ header file
//		redefines MAXPATH to 80, so we use LNMAXPATH instead.

#ifdef BCC
	const int LNMAXPATH = 100;
#else
	#if MAXPATH != 256
		#error Error: Notes MAXPATH has been redefined.
	#endif
	const int LNMAXPATH = MAXPATH;
#endif

#endif	// LNGLOSYM_H

