//===========================================================================
//
// Module:	LNGLOFUN.H
//
// Description:
//
//		C++ API global function declarations (included by LNGLOBAL.H).
//
//===========================================================================
//
// Copyright (c) 1996 Lotus Development Corporation. All rights reserved.
// This software is subject to the Lotus Software Agreement, Restricted
// Rights for U.S. government users, and applicable export regulations.
//
//===========================================================================

#ifndef LNGLOFUN_H
#define LNGLOFUN_H

class LNNotesSession;						// forward declaration needed


extern void LNDelete( void *object );

extern LNVERSION LNGetAPILibraryVersion();

extern const char * LNGetAPILibraryVersionString();

extern LNINT LNGetErrorMessage
	( LNSTATUS error, char *buffer, LNINT buflen = LNERROR_MESSAGE_LENGTH);

extern const char * LNGetPlatform();

extern LNBOOL LNGetThrowAllErrors();

extern LNBOOL LNIsNotesInitialized();

extern void * LNNew( size_t size );

extern void LNSetThrowAllErrors( LNBOOL flag );

extern LNSINT LNStringCompare
	( char c1, char c2,
	  LNSTRINGCOMPAREFLAGS flags = LNSTRINGCOMPAREFLAGS_DEFAULT );

extern LNSINT LNStringCompare
	( const LNChar &c1, char c2,
	  LNSTRINGCOMPAREFLAGS flags = LNSTRINGCOMPAREFLAGS_DEFAULT );

inline LNSINT LNStringCompare
	( char c1, const LNChar &c2,
	  LNSTRINGCOMPAREFLAGS flags = LNSTRINGCOMPAREFLAGS_DEFAULT )
	{ return -LNStringCompare(c2, c1, flags); }

extern LNSINT LNStringCompare
	( const LNChar &c1, const LNChar &c2,
	  LNSTRINGCOMPAREFLAGS flags = LNSTRINGCOMPAREFLAGS_DEFAULT );

extern LNSINT LNStringCompare
	( const LNCHAR *string1, const LNCHAR *string2,
	  LNSTRINGCOMPAREFLAGS flags = LNSTRINGCOMPAREFLAGS_DEFAULT );

extern LNSINT LNStringCompare
	( const LNString &string1, const LNString &string2, 
	  LNSTRINGCOMPAREFLAGS flags = LNSTRINGCOMPAREFLAGS_DEFAULT );

#endif	// LNGLOFUN_H

