//===========================================================================
//
// Module:	LNFONT.HPP
//
// Description:
//
//		Class library definition for LNFontStyle, LNFontTable, and related
//		classes (including LNCompositeItemBody).
//
//===========================================================================
//
// Copyright (c) 1996 Lotus Development Corporation. All rights reserved.
// This software is subject to the Lotus Software Agreement, Restricted
// Rights for U.S. government users, and applicable export regulations.
//
//===========================================================================

#ifndef LNFONT_HPP
#define LNFONT_HPP

#ifndef EDITODS_DEFS
#include <editods.h>
#endif

/* Give users access to the default Notes FontIDs. */
/* Note that there numerous other valid FontIDs, these are just some common defaults. */

#define LNFONTID_PLAIN			DEFAULT_FONT_ID
#define LNFONTID_BOLD 			DEFAULT_BOLD_FONT_ID
#define LNFONTID_SMALL			DEFAULT_SMALL_FONT_ID	
#define LNFONTID_PERMANENT_PEN	DEFAULT_PPEN_FONT_ID
#define LNFONTID_FOREIGN		FOREIGN_FONT_ID


/*	Font Style Bit Fields */

// Attributes
typedef BYTE LNFONTATTRIBUTEFLAGS;
#define LNFONTATTRIBUTEFLAGS_PLAIN			0x00
#define LNFONTATTRIBUTEFLAGS_BOLD 			ISBOLD
#define LNFONTATTRIBUTEFLAGS_ITALIC 		ISITALIC	
#define LNFONTATTRIBUTEFLAGS_UNDERLINE 		ISUNDERLINE
#define LNFONTATTRIBUTEFLAGS_STRIKETHROUGH 	ISSTRIKEOUT
#define LNFONTATTRIBUTEFLAGS_SUPERSCRIPT 	ISSUPER	
#define LNFONTATTRIBUTEFLAGS_SUBSCRIPT 		ISSUB


/* Font Style Masks */


typedef DWORD LNSETFONTSTYLEFLAGS;
const DWORD LNSETFONTSTYLEFLAGS_ALL = 0xFFFFFFFF;
const DWORD LNSETFONTSTYLEFLAGS_COLOR =	(0xff << FONT_COLOR_SHIFT);
const DWORD LNSETFONTSTYLEFLAGS_FACE = (0xff << FONT_FACE_SHIFT);
const DWORD LNSETFONTSTYLEFLAGS_SIZE = 0xff; // FONT_SIZE_SHIFT is 0
const DWORD LNSETFONTSTYLEFLAGS_ALL_ATTRIBUTES = (0xff << FONT_STYLE_SHIFT); // Including the following
const DWORD LNSETFONTSTYLEFLAGS_BOLD = (ISBOLD << FONT_STYLE_SHIFT);
const DWORD LNSETFONTSTYLEFLAGS_ITALIC = (ISITALIC << FONT_STYLE_SHIFT);
const DWORD LNSETFONTSTYLEFLAGS_UNDERLINE = (ISUNDERLINE << FONT_STYLE_SHIFT);
const DWORD LNSETFONTSTYLEFLAGS_STRIKETHROUGH = (ISSTRIKEOUT << FONT_STYLE_SHIFT);
const DWORD LNSETFONTSTYLEFLAGS_SUPERSCRIPT = (ISSUPER << FONT_STYLE_SHIFT);
const DWORD LNSETFONTSTYLEFLAGS_SUBSCRIPT = (ISSUB << FONT_STYLE_SHIFT);



// Faces

// Non-standard faces (and font tables) are not yet exposed, but they will be.


typedef BYTE LNFACEID;
#define LNFACEID_ROMAN		FONT_FACE_ROMAN
#define LNFACEID_HELVETICA  FONT_FACE_SWISS
#define LNFACEID_COURIER 	FONT_FACE_TYPEWRITER

// For user convenience we have included the same names that Notes uses
#define LNFACEID_SWISS		FONT_FACE_SWISS
#define	LNFACEID_TYPEWRITER	FONT_FACE_TYPEWRITER




class LNFontTable : public LNItem
{
	friend class LNFontStyleBody;
 	friend class LNNoteBody;
	friend class LNRichTextBody;

public:

	LNFontTable();
	LNFontTable(const LNFontTable &other);

	~LNFontTable();
	
	LNFontTable& operator=(const LNFontTable &fontTable);
	
	LNBOOL operator==(const LNFontTable &fontTable) const;
	
	virtual LNCLASSID GetClassID() const { return LNCLASS_LNFONTTABLE; }

protected:

	LNFontTable(LNFontTableBody *body);
	
	LNFontTable& operator=(const LNItem &other);
	LNFontTable& operator=(LNFontTableBody *body);

	LNSTATUS AddCDFace(const CDFACE &fontface);

 	LNSTATUS AddFace(BYTE family, const char *name, LNFACEID *faceid);
	
	LNSTATUS FindFace(const CDFACE &fontface, LNFACEID *faceid) const;
	LNSTATUS FindFace(const LNString &name, LNFACEID *faceid) const;

	LNSTATUS GetCDFace(LNFACEID faceid, CDFACE *fontface) const;

	LNFontTableBody* GetFontTableBody() const { return (LNFontTableBody *) Body; }

	// Must step through text objects and reset font styles in conjunction with this.
	LNSTATUS Merge(const LNFontTable &other);

	virtual LNSTATUS Update();
};





class LNFontStyle : public LNSmartPtr
{
	friend class LNFontStyleBody;
	friend class LNRichTextBody;
	friend class LNStylizedTextBody;
	friend class LNViewDesign;

public:

	LNFontStyle();
	LNFontStyle(FONTID fontid, const LNFontTable *fontTable = 0);
	LNFontStyle(const LNFontStyle &other);
	
	~LNFontStyle();
	
	LNFontStyle& operator=(const LNFontStyle &other);

	LNSTATUS Copy(const LNFontStyle &other);

	LNFONTATTRIBUTEFLAGS GetAttributes() const;

	// Get standard and special faces
	// If the face is > STATIC_FONT_FACES, then it is a special face, kept in the
	// notes font table. faceids with the same value can have different faces
	// if they are associated with different font tables.

	// CDFACE is a notes data structure (see the C API as well as LNFontTable)
	// The faceid LNFACEID is the same as the Face field in the CDFACE data structure.
																				
	LNSTATUS GetCDFace(CDFACE *fontface) const;

	LNCOLOR GetColor() const;

	virtual LNCLASSID GetClassID() const { return LNCLASS_LNFONTSTYLE; }

	LNFACEID GetFaceID() const; 

	FONTID GetFontID() const;
	
	LNSTATUS GetFontTable(LNFontTable *fontTable) const;

	LNINT GetPointSize() const;

	
	LNSTATUS SetAttributes(LNFONTATTRIBUTEFLAGS attribs);

	LNSTATUS SetCDFace(CDFACE fontface);

	LNSTATUS SetColor(LNCOLOR color);

	LNSTATUS SetFaceID(LNFACEID faceid);

	LNSTATUS SetFontID(FONTID fontid, LNSETFONTSTYLEFLAGS mask=LNSETFONTSTYLEFLAGS_ALL);

	LNSTATUS SetPointSize(LNINT fontsize);

protected:

   	LNFontStyle(LNFontStyleBody *body);
	LNFontStyle(FONTID fontid, LNNoteBody *noteBody);

	LNFontStyle& operator=(LNFontStyleBody *body);

	LNSTATUS Assign(FONTID fontid, const LNFontTable *fontTable = 0);

	LNSTATUS Assign(FONTID fontid, LNNoteBody *noteBody);

	LNFontStyleBody* GetFontStyleBody() const { return (LNFontStyleBody *) Body; }

	LNString GetName() const;

	LNSTATUS SetFontStyle(const LNFontStyle &style, LNSETFONTSTYLEFLAGS mask=LNSETFONTSTYLEFLAGS_ALL);

	LNSTATUS SetName(const LNString &fontname); // Notes limits this to MAXFACENAME-1 characters (31) 
};



#endif

