//===========================================================================
//
// Module:	LNERRORS.H
//
// Description:
//
//		C++ API error and warning codes.
//
//===========================================================================
//
// Copyright (c) 1996 Lotus Development Corporation. All rights reserved.
// This software is subject to the Lotus Software Agreement, Restricted
// Rights for U.S. government users, and applicable export regulations.
//
//===========================================================================

#ifndef LNGLOBAL_H
#include "lnglobal.h"
#endif


//-----	Error codes:

LNERRDEF( WRONG_VERSION, \
	"API program is incompatible with this version of the API library" )
LNERRDEF( NO_MEMORY, "Insufficient memory" )
LNERRDEF( SESSION_NOT_INITIALIZED, "Notes session has not been initialized" )
LNERRDEF( NULL_POINTER_PARAMETER, \
	"Null pointer or invalid object passed to function" )
LNERRDEF( ASSERT_FAILED, "Assertion failed" )
LNERRDEF( UNEXPECTED_CALLED, "unexpected() function called" )
LNERRDEF( TERMINATE_CALLED, "terminate() function called" )
LNERRDEF( OBJECT_NOT_IN_LIST, "Object not in object list" )
LNERRDEF( NO_SORT_KEY, "LNSortedObjectList::AddObject requires sort key" )
LNERRDEF( OBJECT_ALREADY_IN_LIST, "Object already in object list" )
LNERRDEF( NOT_LNNEW_BLOCK, "LNDelete: memory block not allocated by LNNew" )
LNERRDEF( OBJECT_NOT_ON_HEAP, \
	"Object must be on heap to be added to object list" )
LNERRDEF( NULL_STRING_PARAMETER, "Null string passed to function" )
LNERRDEF( OBJECT_NOT_INITIALIZED, "Object has not been initialized" )
LNERRDEF( SESSION_ALREADY_INITIALIZED, \
	"Notes session has already been initialized" )
LNERRDEF( UNINITIALIZED_OBJECT_PARAMETER, \
	"Uninitialized object passed to function" )
LNERRDEF( NO_NAME, "Object must have a name" )
LNERRDEF( PARAMETER_OUT_OF_RANGE, "Function parameter is out of range" )
LNERRDEF( SUBSCRIPT_OUT_OF_RANGE, "Array subscript is out of range" )
LNERRDEF( TOO_MANY_COLUMNS, "Cannot add the requested number of columns" )
LNERRDEF( INVALID_VIEW_FOLDER, "Invalid view or folder" )
LNERRDEF( CANNOT_INITIALIZE_VIEW_FOLDER, \
	"Error initializing view or folder data" )
LNERRDEF( CANNOT_CREATE_FONT_STYLE, "Error creating LNFontStyle object" )
LNERRDEF( INVALID_DATABASE_NAME, "Invalid or missing database pathname" )
LNERRDEF( INVALID_VIEW_FOLDER_VERSION, \
	"Unsupported view or folder version" )
LNERRDEF( DESIGN_ALREADY_EXISTS, \
	"Design object already exists for this view or folder" )
LNERRDEF( VIEW_FOLDER_NOT_SAVED, \
	"New view or folder must be saved before accessing entries" )
LNERRDEF( VIEW_FOLDER_CLOSED, \
	"View or folder must be open in order to use this function" )
LNERRDEF( NO_COLLECTION, \
	"No collection open for this view, folder, or navigator" )
LNERRDEF( NOT_FOUND, "No match found" )
LNERRDEF( NIFREADENTRIES, "Unexpected NIFReadEntries failure" )
LNERRDEF( WRONG_VIEW_FOLDER, \
	"Object is not associated with this view or folder" )
LNERRDEF( TOO_MANY_KEYS, \
	"LNVFFindKeys object already has maximum number of keys" )
LNERRDEF( ITEM_TABLE_TOO_BIG, \
	"LNVFFindKeys ITEM_TABLE exceeds maximum size" )
LNERRDEF( STRING_TOO_LONG, \
	"String length exceeds maximum allowed for this function" )
LNERRDEF( NO_ERROR_MESSAGE, "(no error message available)" )
LNERRDEF( CANNOT_CREATE_ACL, "Cannot create ACL in new database" )
LNERRDEF( CANNOT_DELETE_CATEGORY, "Cannot delete category or total entry" )
LNERRDEF( NO_ENTRIES, "No entries in this view, folder, or navigator" )
LNERRDEF( ADDIN_ALREADY_INITIALIZED, \
	"Notes Addin has already been initialized" )
LNERRDEF( CANNOT_DELETE_DEFAULT_STATUS_LINE, \
	"Cannot delete the default status line for this Addin" )
LNERRDEF( ADDIN_INVALID_LINEID, \
	"An invalid Addin Status Line ID has been passed in" )
LNERRDEF( INVALID_PARAMETER, "Invalid parameter passed to function" )
LNERRDEF( NOTE_ITEM, "Function invalid for items in a note" )
LNERRDEF( CANNOT_CREATE_NOTE, "Unable to create new note" )
LNERRDEF( NOTE_CLOSED, "Unable to perform operation due to unopened note" )
LNERRDEF( CANNOT_GET_NOTE_SIZE, "Unable to calculate note size" )
LNERRDEF( DATABASE_CLOSED, \
	"Unable to perform operation due to unopened database" )
LNERRDEF( CANNOT_CONVERT_DATE, "Couldn't convert date" )
LNERRDEF( CANNOT_ADJUST_DATE, "Couldn't adjust date" )
LNERRDEF( INVALID_CONVERSION, "Couldn't perform conversion" )
LNERRDEF( CANNOT_GET_STRING_SIZE, \
	"Error encountered while using LNL to determine string size" )
LNERRDEF( ITEM_ALREADY_EXISTS, "Item already exists in the note" )
LNERRDEF( ITEM_MISMATCH, "" )
LNERRDEF( OFFSET_OUT_OF_RANGE, "Offset is beyond the range of the item" )
LNERRDEF( UNDEFINED_ITEM, "The item has not been defined" )
LNERRDEF( ACL_OBJECT_ALREADY_EXISTS, "Can only get one LNACL object" )
LNERRDEF( ACL_CLOSED, "ACL must be open in order to use this function" )
LNERRDEF( INVALID_ROLE_NAME_CHARACTER, "Invalid role character" )
LNERRDEF( INVALID_MAIL_MESSAGE, "Invalid mail message" )
LNERRDEF( SERVER_MAIL_NOTSUPPORTED, "Server mail function not supported" )
LNERRDEF( CANNOT_COPY_MAIL_MESSAGE, \
	"Prevent copying function enabled, can't copy message" )
LNERRDEF( INVALID_MAIL_DATABASE, \
	"Document's database is not the user's mail file" )
LNERRDEF( OBSOLETE, "Function or type no longer supported" )
LNERRDEF( ILLEGAL_OPERATION, "This function is inappropriate for this object" )
LNERRDEF( TOO_MANY_FONTS, "Too many fonts in rich text font table" )
LNERRDEF( NEED_MORE_MEMORY, \
	"The memory allocated for the output parameter is too small" )
LNERRDEF( COLOR_NOT_FOUND, "Colors are not in index" )
LNERRDEF( OBJECT_CORRUPTED, "Object or data is corrupted" )
LNERRDEF( NOT_INSERTABLE_TYPE, "Cannot insert this type into this object" )
LNERRDEF( RTOBJECT_NOT_IN_CONTAINER, \
	"Rich text object is not member of container" )
LNERRDEF( RTOBJECT_ALREADY_IN_CONTAINER, \
	"Rich text object is already a member of container" )
LNERRDEF( UNEXPECTED_RICHTEXT_TYPE, \
	"A different rich text type is expected" )
LNERRDEF( INVALID_RICHTEXT, "Rich text object is invalid" )
LNERRDEF( INVALID_LOGENTRY, "LogEntry object is invalid" )
LNERRDEF( INVALID_SELECTION, "Selection of rich text is invalid" )
LNERRDEF( INVALID_GRAPHIC, "Graphic rich text object is invalid" )
LNERRDEF( NOT_IMPLEMENTED, "Function has not been implemented" )
LNERRDEF( RTPARSER_STACK_OVERFLOW, "Rich text parser stack overflow" )
LNERRDEF( RICHTEXT_NOT_EMPTY, "An empty richtext object is expected" )
LNERRDEF( CANNOT_ADD_CHILD_TO_ELEMENT, \
	"Cannot add a child to a richtext element" )
LNERRDEF( ALREADY_ALLOCATED, \
	"Memory for this object has already been allocated" )
LNERRDEF( CANNOT_ACCESS_RTCHAR, \
	"Users cannot access rich text characters directly" )
LNERRDEF( OBJECT_CLOSED, "Object has already been closed" )
LNERRDEF( CANNOT_CREATE_VFENTRY, "Cannot create view or folder entry" )
LNERRDEF( CANNOT_TRANSLATE_SPECIAL_VALUE, \
	"LNVFEntry::operator[]: cannot translate special @function value" )
LNERRDEF( CANNOT_EVALUATE_COLUMN_FORMULA, \
	"LNVFEntry::operator[]: cannot evaluate column formula" )
LNERRDEF( NO_MAIL_DATABASE, "Cannot locate mail database" )
LNERRDEF( PARENTDB_DOESNT_MATCH, \
	"Can't make response document, parent's database doesn't match the doc's" )
LNERRDEF( CANNOT_GET_CATEGORY, "Cannot get document for category or total entry" )
LNERRDEF( CANNOT_ALLOC_WHILE_DELETING, \
	"Cannot allocate memory while LNDeleteAllObjects executes" )
LNERRDEF( NOT_TEMPLATE_DATABASE, "Database is not a design template" )
LNERRDEF( CANNOT_DELETE_ENTRIES, \
	"Cannot delete entries that do not belong to this navigator" )
LNERRDEF( CLOSED_OBJECT_PARAMETER, "Object passed to function must be open" )
LNERRDEF( NOT_SUPPORTED_FOR_FT_NAVIGATOR, \
	"This operation cannot be performed on a navigator for full-text search results" )
LNERRDEF( INVALID_CURSOR, "Rich text cursor is invalid" )

//-----	Warning codes:

LNWARNDEF( NOT_FOUND, "No match found" )
LNWARNDEF( MEMORY_LEAK, "Undeleted objects found; possible memory leak" )
LNWARNDEF( NOT_OPEN, "Object is not open" )
LNWARNDEF( ALREADY_OPEN, "Object is already open" )
LNWARNDEF( CANNOT_DELETE_DEFAULT_ENTRY, "Can not delete -Default- entry" )
LNWARNDEF( TOO_MANY_ROLES, "No more slot available to create role specified" )
LNWARNDEF( MAIL_FORM_NOT_FOUND, "There is no form to render the body item" )
LNWARNDEF( MAILER_NOSUCHUSER, "No such group" )
LNWARNDEF( MAILER_NOTUNIQUE, "Group Name not unique" )
LNWARNDEF( UNKNOWN_NAME, "Group Name unknown" )
LNWARNDEF( NO_PARENT_NOTE, "There is no parent note for this document" )
LNWARNDEF( USE_FORWARD_FUNCTION_INSTEAD, "Use Forward function instead of Send." )

