//===========================================================================
//
// Module:	LNENUMS.H
//
// Description:
//
//		C++ API enumerations and bit masks.
//
//===========================================================================
//
// Copyright (c) 1996 Lotus Development Corporation. All rights reserved.
// This software is subject to the Lotus Software Agreement, Restricted
// Rights for U.S. government users, and applicable export regulations.
//
//===========================================================================

#ifndef LNENUMS_H
#define LNENUMS_H


enum LNDBTYPE
{
	LNDBTYPE_CLIPBOARD = DBCLASS_NOTECLIPBOARD,
	LNDBTYPE_DESKTOP = DBCLASS_DESKTOP,
	LNDBTYPE_ENCAPS_MAIL_FILE = DBCLASS_ENCAPSMAILFILE,
	LNDBTYPE_GIANT_NOTEFILE = DBCLASS_GIANTNOTEFILE,
	LNDBTYPE_HUGE_NOTEFILE = DBCLASS_HUGENOTEFILE,
	LNDBTYPE_LARGE_ENCAPS_MAIL_FILE = DBCLASS_LRGENCAPSMAILFILE,
	LNDBTYPE_NOTEFILE = DBCLASS_NOTEFILE,
	LNDBTYPE_OBJECT_STORE = DBCLASS_OBJSTORE,
	LNDBTYPE_ONE_DOC_FILE = DBCLASS_ONEDOCFILE,
	LNDBTYPE_TEMPLATEFILE = DBCLASS_TEMPLATEFILE,
	LNDBTYPE_TESTFILE = DBCLASS_NSFTESTFILE,
	LNDBTYPE_V2_NOTEFILE = DBCLASS_V2NOTEFILE,
	LNDBTYPE_V3_NOTEFILE = DBCLASS_V3NOTEFILE,
	LNDBTYPE_V3_ONE_DOC_FILE = DBCLASS_V3ONEDOCFILE
};

typedef DWORD LNDBOPENFLAGS;
#define LNDBOPENFLAGS_DEFAULT		0
#define LNDBOPENFLAGS_DELAY_COMMIT	0x00010000

typedef WORD LNFTINDEXFLAGS;
#define LNFTINDEXFLAGS_CASE_SENSITIVE			FT_INDEX_CASE_SENS
#define LNFTINDEXFLAGS_DEFAULT					FT_INDEX_AUTOOPTIONS
#define LNFTINDEXFLAGS_INDEX_ALL_BREAKS			FT_INDEX_PSW
#define LNFTINDEXFLAGS_INDEX_ATTACHMENTS		FT_INDEX_ATT
#define LNFTINDEXFLAGS_INDEX_ENCRYPTED_FIELDS	FT_INDEX_ENCRYPTED_FIELDS
#define LNFTINDEXFLAGS_INDEX_STEMS				FT_INDEX_STEM_INDEX
#define LNFTINDEXFLAGS_OPTIMIZE					FT_INDEX_OPTIMIZE

enum LNREPLICATIONPRIORITY
{
	LNREPLICATIONPRIORITY_HIGH = REPLFLG_PRIORITY_HI,
	LNREPLICATIONPRIORITY_LOW = REPLFLG_PRIORITY_LOW,
	LNREPLICATIONPRIORITY_MEDIUM = REPLFLG_PRIORITY_MED
};

typedef WORD LNNOTETYPE;
#define LNNOTETYPE_ACL						NOTE_CLASS_ACL
#define LNNOTETYPE_AGENT					NOTE_CLASS_FILTER
#define LNNOTETYPE_ALL						NOTE_CLASS_ALL
#define LNNOTETYPE_ALL_NON_DATA				NOTE_CLASS_ALLNONDATA
#define LNNOTETYPE_ALL_UNIQUE				NOTE_CLASS_SINGLE_INSTANCE
#define LNNOTETYPE_DEFAULT_FORM				(NOTE_CLASS_FORM | NOTE_CLASS_DEFAULT)
#define LNNOTETYPE_DEFAULT_VIEW_FOLDER		(NOTE_CLASS_VIEW | NOTE_CLASS_DEFAULT)
#define LNNOTETYPE_DESIGN					NOTE_CLASS_DESIGN
#define LNNOTETYPE_DOCUMENT					NOTE_CLASS_DOCUMENT
#define LNNOTETYPE_FIELD					NOTE_CLASS_FIELD
#define LNNOTETYPE_FORM						NOTE_CLASS_FORM
#define LNNOTETYPE_HELP_ABOUT				NOTE_CLASS_INFO
#define LNNOTETYPE_HELP_INDEX				NOTE_CLASS_HELP_INDEX
#define LNNOTETYPE_HELP_USING				NOTE_CLASS_HELP
#define LNNOTETYPE_ICON						NOTE_CLASS_ICON
#define LNNOTETYPE_NOTIFY_DELETEION			NOTE_CLASS_NOTIFYDELETION
#define LNNOTETYPE_REPLICATION_FORMULA		NOTE_CLASS_REPLFORMULA
#define LNNOTETYPE_PRIVATE					NOTE_CLASS_PRIVATE
#define LNNOTETYPE_VIEW_FOLDER				NOTE_CLASS_VIEW

typedef WORD LNNOTEOPENFLAGS;
#define LNNOTEOPENFLAGS_ABSTRACT				OPEN_ABSTRACT
#define LNNOTEOPENFLAGS_DEFAULT					0
#define LNNOTEOPENFLAGS_MARK_READ				OPEN_MARK_READ
#define LNNOTEOPENFLAGS_NO_DEFAULT_NOTE_CHECK	OPEN_NOVERIFYDEFAULT
#define LNNOTEOPENFLAGS_NO_OBJECTS				OPEN_NOOBJECTS
#define LNNOTEOPENFLAGS_SHARE					OPEN_SHARE
#define LNNOTEOPENFLAGS_SUMMARY_ONLY			OPEN_SUMMARY

typedef WORD LNNOTESAVEFLAGS;
#define LNNOTESAVEFLAGS_CHECK_FIELD_NAMES		UPDATE_NAME_KEY_WARNING
#define LNNOTESAVEFLAGS_DELAY_COMMIT			UPDATE_NOCOMMIT
#define LNNOTESAVEFLAGS_DEFAULT					0x0000
#define LNNOTESAVEFLAGS_FORCE					UPDATE_FORCE
#define LNNOTESAVEFLAGS_INCREMENTAL				UPDATE_INCREMENTAL
#define LNNOTESAVEFLAGS_NO_REVISION_HISTORY		UPDATE_NOREVISION


const LNINT LNITEMNAMESIZE=32;

// Exposed Item Types
typedef LNINT LNITEMTYPE;
#define LNITEMTYPE_ANY					0xFFFFFFFF
#define LNITEMTYPE_SPECIAL				0x80000000
#define LNITEMTYPE_DATETIMERANGES		TYPE_TIME_RANGE
#define LNITEMTYPE_DATETIMES			(TYPE_TIME_RANGE | LNITEMTYPE_SPECIAL)
#define LNITEMTYPE_ERROR				TYPE_ERROR
#define LNITEMTYPE_FONTTABLE			(TYPE_COMPOSITE | LNITEMTYPE_SPECIAL)
#define LNITEMTYPE_FORMULA				TYPE_FORMULA
#define LNITEMTYPE_ICON					TYPE_ICON
#define LNITEMTYPE_NOTELINKS			TYPE_NOTELINK_LIST
#define LNITEMTYPE_NOTEREFS				TYPE_NOTEREF_LIST
#define LNITEMTYPE_NUMBERS				TYPE_NUMBER_RANGE
#define LNITEMTYPE_OBJECT				TYPE_OBJECT
#define LNITEMTYPE_RICHTEXT				TYPE_COMPOSITE
#define LNITEMTYPE_SIGNATURE			TYPE_SIGNATURE
#define LNITEMTYPE_TEXT					TYPE_TEXT_LIST
#define LNITEMTYPE_UNAVAILABLE			TYPE_UNAVAILABLE
#define LNITEMTYPE_UNSUPPORTED			TYPE_INVALID_OR_UNKNOWN
#define LNITEMTYPE_USERDATA				TYPE_USERDATA

// Item Flags
typedef WORD LNITEMFLAGS;
#define LNITEMFLAGS_AUTHORS			ITEM_READWRITERS
#define LNITEMFLAGS_ENCRYPT			ITEM_SEAL
#define LNITEMFLAGS_NAMES			ITEM_NAMES
#define LNITEMFLAGS_PROTECTED		ITEM_PROTECTED
#define LNITEMFLAGS_READERS			ITEM_READERS
#define LNITEMFLAGS_SIGN			ITEM_SIGN
#define LNITEMFLAGS_SUMMARY			ITEM_SUMMARY

// Item Create Options
enum LNITEMOPTION
{
	LNITEMOPTION_APPEND_ONLY,
	LNITEMOPTION_DELETE_APPEND,
	LNITEMOPTION_ERROR
};

enum LNDATEFORMAT
{
	LNDATEFORMAT_ALL = TDFMT_FULL,
	LNDATEFORMAT_MONTH_DAY = TDFMT_PARTIAL,
	LNDATEFORMAT_MONTH_DAY_YEAR = TDFMT_CPARTIAL,
	LNDATEFORMAT_YEAR_MONTH = TDFMT_DPARTIAL
};

enum LNDATEORDER
{
	LNDATEORDER_DMY = DATE_DMY,
	LNDATEORDER_MDY = DATE_MDY,
	LNDATEORDER_YMD = DATE_YMD
};

enum LNDATETIMEDISPLAY
{
	LNDATETIMEDISPLAY_DATE = TSFMT_DATE,
	LNDATETIMEDISPLAY_DATE_AND_TIME = TSFMT_DATETIME,
	LNDATETIMEDISPLAY_TIME = TSFMT_TIME,
	LNDATETIMEDISPLAY_TODAY_AND_TIME = TSFMT_CDATETIME
};

enum LNDAYOFWEEK
{
	LNDAYOFWEEK_SUNDAY = 1,
	LNDAYOFWEEK_MONDAY = 2,
	LNDAYOFWEEK_TUESDAY = 3,
	LNDAYOFWEEK_WEDNESDAY = 4,
	LNDAYOFWEEK_THURSDAY = 5,
	LNDAYOFWEEK_FRIDAY = 6,
	LNDAYOFWEEK_SATURDAY = 7
};

enum LNNUMBERFORMAT
{
	LNNUMBERFORMAT_GENERAL = NFMT_GENERAL,
	LNNUMBERFORMAT_FIXED = NFMT_FIXED,
	LNNUMBERFORMAT_SCIENTIFIC = NFMT_SCIENTIFIC,
	LNNUMBERFORMAT_CURRENCY = NFMT_CURRENCY
};

enum LNTIMEFORMAT
{
	LNTIMEFORMAT_HOUR = TTFMT_HOUR,
	LNTIMEFORMAT_HOUR_MINUTE = TTFMT_PARTIAL,
	LNTIMEFORMAT_HOUR_MINUTE_SECOND = TTFMT_FULL
};

enum LNTIMEZONE
{
	LNTIMEZONE_GMT = 0,
	LNTIMEZONE_ZW1 = 1,
	LNTIMEZONE_ZW2 = 2,
	LNTIMEZONE_ZW3 = 3,
	LNTIMEZONE_NST = 3003,
	LNTIMEZONE_AST = 4,
	LNTIMEZONE_EST = 5,
	LNTIMEZONE_CST = 6,
	LNTIMEZONE_MST = 7,
	LNTIMEZONE_PST = 8,
	LNTIMEZONE_YST = 9,
	LNTIMEZONE_ZW9B = 3009,
	LNTIMEZONE_HST = 10,
	LNTIMEZONE_BST = 11,
	LNTIMEZONE_ZW12 = 12,
	LNTIMEZONE_ZE12C = -4512,
	LNTIMEZONE_ZE12 = -12,
	LNTIMEZONE_ZE11B = -3011,
	LNTIMEZONE_ZE11 = -11,
	LNTIMEZONE_ZE10B = -3010,
	LNTIMEZONE_ZE10 = -10,
	LNTIMEZONE_ZE9B = -3009,
	LNTIMEZONE_ZE9 = -9,
	LNTIMEZONE_ZE8 = -8,
	LNTIMEZONE_ZE7 = -7,
	LNTIMEZONE_ZE6B = -3006,
	LNTIMEZONE_ZE6 = -6,
	LNTIMEZONE_ZE5C = -4505,
	LNTIMEZONE_ZE5B = -3005,
	LNTIMEZONE_ZE5 = -5,
	LNTIMEZONE_ZE4B = -3004,
	LNTIMEZONE_ZE4 = -4,
	LNTIMEZONE_ZE3B = -3003,
	LNTIMEZONE_ZE3 = -3,
	LNTIMEZONE_ZE2 = -2,
	LNTIMEZONE_CET = -1
};

enum LNTIMEZONEDISPLAY
{
	LNTIMEZONEDISPLAY_ADJUST_TO_LOCAL = TZFMT_NEVER,
	LNTIMEZONEDISPLAY_SHOW_ALWAYS = TZFMT_ALWAYS,
	LNTIMEZONEDISPLAY_SHOW_IF_NOT_LOCAL = TZFMT_SOMETIMES
};
	
// Flags used by global LNStringCompare functions.
typedef DWORD LNSTRINGCOMPAREFLAGS;

#define LNSTRINGCOMPAREFLAGS_MATCH_ACCENT	INTL_ACCENT_SENSITIVE
#define LNSTRINGCOMPAREFLAGS_MATCH_CASE		INTL_CASE_SENSITIVE
#define LNSTRINGCOMPAREFLAGS_DEFAULT		0

#endif	// LNENUMS_H

