//===========================================================================
//
// Module:		LNDTS.HPP
//
// Description:	Class library definition for LNDatetimes and related classes.
//
//===========================================================================
//
// Copyright (c) 1995 Lotus Development Corporation. All rights reserved.
// This software is subject to the Lotus Software Agreement, Restricted
// Rights for U.S. government users, and applicable export regulations.
//
//===========================================================================
#ifndef LNDTS_HPP
#define LNDTS_HPP

STATUS DateListDuplicate( void *pdatelist, BOOL tprefix, HANDLE *reth );
WORD DateListGetNumEntries( void *pdatelist, BOOL tprefix );

//
//	Class definition for LNDatetimesElement.
//
class LNDatetimesElement : public LNNotesClass
{
friend class LNDatetimes;

public:
	LNDatetimesElement( const LNDatetimesElement &other );
	LNDatetimesElement( LNDatetimesBody *datebody, LNINT index );

	~LNDatetimesElement();

	LNDatetimesElement& operator=( const LNDatetime &datetime );
	LNDatetimesElement& operator=( const LNDatetimesElement &datetimeselem );

	operator LNDatetime() const;

	LNCLASSID GetClassID() const {return LNCLASSID_LNDATETIMESELEMENT;}

private:
	LNDatetimesElement();	// Disabled.

	LNDatetimesBody *Body;
	LNINT Index;	
};

//
//	Class definition for LNDatetimes.
//
class LNDatetimes : public LNItem
{

public:
	LNDatetimes();
	LNDatetimes( const LNDatetimes &other );
	LNDatetimes( const LNItem &other );

	~LNDatetimes();

	LNDatetimes& operator=( const LNDatetimes &other );
	LNDatetimes& operator=( const LNItem &other );

	LNDatetimes& operator<<( const LNDatetimes &datetimes );
	LNDatetimes& operator<<( const LNDatetime &datetime );
	LNDatetimes& operator<<( const LNDatetimesElement &datetimeselem );

	LNDatetimesElement operator[]( LNINT n ) const;

	LNSTATUS Append( const LNDatetimes &datetimes );
	LNSTATUS Append( const LNDatetime &datetime );
	LNSTATUS Append( const LNDatetimesElement &datetimeselem );

	LNSTATUS Delete( LNINT n, LNINT count=1 );

	LNSTATUS DeleteAll();

	LNCLASSID GetClassID() const {return LNCLASSID_LNDATETIMES;}

	LNINT GetCount() const;

	LNSTATUS Insert( LNINT pos, const LNDatetimes &datetimes );
	LNSTATUS Insert( LNINT pos, const LNDatetime &datetime );
	LNSTATUS Insert( LNINT pos, const LNDatetimesElement &datetimeselem );

	LNSTATUS SetValue( const LNDatetimes &datetimes );
	LNSTATUS SetValue( const LNDatetime &datetime );
	LNSTATUS SetValue( const LNDatetimesElement &datetimeselem );

protected:
	void Assign( LNNoteBody *noteb, LNDatetimesBody *datetimesb );

	LNDatetimesBody * GetDatetimesBody() const
		{return (LNDatetimesBody *)GetItemBody();}

private:
};


#endif

