//===========================================================================
//
// Module:		LNDTRS.HPP
//
// Description:	Class library definition for LNDatetimeRanges and related classes.
//
//===========================================================================
//
// Copyright (c) 1996 Lotus Development Corporation. All rights reserved.
// This software is subject to the Lotus Software Agreement, Restricted
// Rights for U.S. government users, and applicable export regulations.
//
//===========================================================================
#ifndef LNDTRS_HPP
#define LNDTRS_HPP

//
//	Class definition for LNDatetimeRangesElement.
//
class LNDatetimeRangesElement : public LNNotesClass
{
friend class LNDatetimeRanges;

public:
	LNDatetimeRangesElement( const LNDatetimeRangesElement &other );
	LNDatetimeRangesElement( LNDatetimeRangesBody *dtrsbody, LNINT index );

	~LNDatetimeRangesElement();

	LNDatetimeRangesElement& operator=( const LNDatetime &datetime );
	LNDatetimeRangesElement& operator=( const LNDatetimeRange &dtrange );
	LNDatetimeRangesElement& operator=( const LNDatetimeRangesElement &dtrselem );

	operator LNDatetimeRange() const;

	LNCLASSID GetClassID() const {return LNCLASSID_LNDATETIMERANGESELEMENT;}

private:
	LNDatetimeRangesElement();	// Disabled.

	LNDatetimeRangesBody *Body;
	LNINT Index;	
};

//
//	Class definition for LNDatetimeRanges.
//
class LNDatetimeRanges : public LNItem
{

public:
	LNDatetimeRanges();
	LNDatetimeRanges( const LNDatetimeRanges &other );
	LNDatetimeRanges( const LNItem &other );

	~LNDatetimeRanges();

	LNDatetimeRanges& operator=( const LNDatetimeRanges &other );
	LNDatetimeRanges& operator=( const LNItem &other );

	LNDatetimeRanges& operator<<( const LNDatetimeRange &dtrange );
	LNDatetimeRanges& operator<<( const LNDatetime &datetime );
	LNDatetimeRanges& operator<<( const LNDatetimeRangesElement &dtrselem );

	LNDatetimeRangesElement operator[]( LNINT n ) const;

	LNSTATUS Append( const LNDatetimeRange &dtrange );
	LNSTATUS Append( const LNDatetime &datetime );
	LNSTATUS Append( const LNDatetimeRangesElement &dtrselem );

	LNSTATUS Delete( LNINT n, LNINT count=1 );

	LNSTATUS DeleteAll();

	LNCLASSID GetClassID() const {return LNCLASSID_LNDATETIMERANGES;}

	LNINT GetCount() const;

	LNINT GetDatetimeCount() const;

	LNINT GetDatetimeRangeCount() const;

	LNSTATUS Insert( LNINT pos, const LNDatetimeRange &dtrange );
	LNSTATUS Insert( LNINT pos, const LNDatetime &datetime );
	LNSTATUS Insert( LNINT pos, const LNDatetimeRangesElement &dtrselem );

	LNSTATUS SetValue( const LNDatetimeRanges &dtranges );
	LNSTATUS SetValue( const LNDatetimeRange &dtrange );
	LNSTATUS SetValue( const LNDatetime &datetime );
	LNSTATUS SetValue( const LNDatetimeRangesElement &dtrselem );

protected:
	void Assign( LNNoteBody *noteb, LNDatetimeRangesBody *dtrsb );

	LNDatetimeRangesBody * GetDatetimeRangesBody() const
		{return (LNDatetimeRangesBody *)GetItemBody();}

private:
};


#endif

